/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2021-12-01 07:26:14 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `HhhEP_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=247 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=825 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=118 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_cff_facebook_feed_locator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `HhhEP_cff_feed_caches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` bigint(20) unsigned NOT NULL DEFAULT '1',
  `cache_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `cache_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `cron_update` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  `last_updated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_cff_feeds` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `feed_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint(20) unsigned NOT NULL DEFAULT '1',
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_cff_sources` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `account_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `privilege` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `access_token` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `username` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `info` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `expires` datetime NOT NULL,
  `last_updated` datetime NOT NULL,
  `author` bigint(20) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `account_type` (`account_type`(191)),
  KEY `author` (`author`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `HhhEP_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=3478 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2397 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=452 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_sbi_instagram_feed_locator` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `feed_id` varchar(50) NOT NULL DEFAULT '',
  `post_id` bigint(20) unsigned NOT NULL,
  `html_location` varchar(50) NOT NULL DEFAULT 'unknown',
  `shortcode_atts` longtext NOT NULL,
  `last_update` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `feed_id` (`feed_id`),
  KEY `post_id` (`post_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

CREATE TABLE `HhhEP_sbi_instagram_feeds_posts` (
  `record_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `id` int(11) unsigned NOT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `feed_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `hashtag` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`record_id`),
  KEY `hashtag` (`hashtag`(100)),
  KEY `feed_id` (`feed_id`(100))
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_sbi_instagram_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `created_on` datetime DEFAULT NULL,
  `instagram_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `time_stamp` datetime DEFAULT NULL,
  `top_time_stamp` datetime DEFAULT NULL,
  `json_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `media_id` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sizes` varchar(1000) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `aspect_ratio` decimal(4,2) NOT NULL DEFAULT '0.00',
  `images_done` tinyint(1) NOT NULL DEFAULT '0',
  `last_requested` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=665 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`),
  CONSTRAINT `fk_HhhEP_wc_download_log_permission_id` FOREIGN KEY (`permission_id`) REFERENCES `HhhEP_woocommerce_downloadable_product_permissions` (`permission_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`)
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `HhhEP_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint(20) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `HhhEP_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=270 DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: HhhEP_actionscheduler_actions */
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("208", "action_scheduler/migration_hook", "complete", "2021-11-16 07:24:32", "2021-11-16 07:24:32", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637047472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637047472;}", "1", "1", "2021-11-16 07:24:34", "2021-11-16 07:24:34", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("209", "action_scheduler/migration_hook", "complete", "2021-11-16 07:25:34", "2021-11-16 07:25:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637047534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637047534;}", "1", "1", "2021-11-16 07:25:41", "2021-11-16 07:25:41", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("210", "woocommerce_update_marketplace_suggestions", "complete", "2021-11-16 07:35:51", "2021-11-16 07:35:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637048151;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637048151;}", "0", "1", "2021-11-16 07:35:51", "2021-11-16 07:35:51", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("211", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:19:12", "2021-11-16 08:19:12", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("212", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:23:28", "2021-11-16 08:23:28", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("213", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:24:26", "2021-11-16 08:24:26", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("214", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:27:24", "2021-11-16 08:27:24", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("215", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:29:55", "2021-11-16 08:29:55", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("216", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:36:37", "2021-11-16 08:36:37", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("217", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:40:31", "2021-11-16 08:40:31", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("218", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-16 08:45:20", "2021-11-16 08:45:20", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("219", "wc-admin_import_customers", "complete", "2021-11-17 06:31:26", "2021-11-17 06:31:26", "[2]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637130686;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637130686;}", "2", "1", "2021-11-17 06:31:28", "2021-11-17 06:31:28", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("220", "wc-admin_import_customers", "complete", "2021-11-17 07:08:24", "2021-11-17 07:08:24", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637132904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637132904;}", "2", "1", "2021-11-17 07:08:26", "2021-11-17 07:08:26", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("221", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 07:48:33", "2021-11-17 07:48:33", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("222", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 07:51:10", "2021-11-17 07:51:10", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("223", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 07:55:27", "2021-11-17 07:55:27", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("224", "action_scheduler/migration_hook", "complete", "2021-11-17 08:02:34", "2021-11-17 08:02:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637136154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637136154;}", "1", "1", "2021-11-17 08:02:36", "2021-11-17 08:02:36", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("225", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 08:16:17", "2021-11-17 08:16:17", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("226", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 08:19:24", "2021-11-17 08:19:24", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("227", "adjust_download_permissions", "complete", "2021-11-17 08:18:51", "2021-11-17 08:18:51", "[232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637137131;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637137131;}", "0", "1", "2021-11-17 08:19:24", "2021-11-17 08:19:24", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("228", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 08:20:25", "2021-11-17 08:20:25", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("229", "adjust_download_permissions", "complete", "2021-11-17 08:20:26", "2021-11-17 08:20:26", "[232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637137226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637137226;}", "0", "1", "2021-11-17 08:21:25", "2021-11-17 08:21:25", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("230", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 08:21:25", "2021-11-17 08:21:25", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("231", "adjust_download_permissions", "complete", "2021-11-17 08:25:28", "2021-11-17 08:25:28", "[232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637137528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637137528;}", "0", "1", "2021-11-17 08:26:05", "2021-11-17 08:26:05", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("232", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "complete", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2021-11-17 08:26:05", "2021-11-17 08:26:05", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("233", "adjust_download_permissions", "complete", "2021-11-17 08:29:58", "2021-11-17 08:29:58", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637137798;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637137798;}", "0", "1", "2021-11-17 08:30:25", "2021-11-17 08:30:25", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("234", "adjust_download_permissions", "complete", "2021-11-17 09:04:33", "2021-11-17 09:04:33", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637139873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637139873;}", "0", "1", "2021-11-17 09:04:36", "2021-11-17 09:04:36", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("235", "adjust_download_permissions", "complete", "2021-11-17 09:04:36", "2021-11-17 09:04:36", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637139876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637139876;}", "0", "1", "2021-11-17 09:04:36", "2021-11-17 09:04:36", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("236", "adjust_download_permissions", "complete", "2021-11-17 09:06:48", "2021-11-17 09:06:48", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140008;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140008;}", "0", "1", "2021-11-17 09:07:08", "2021-11-17 09:07:08", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("237", "adjust_download_permissions", "complete", "2021-11-17 09:08:19", "2021-11-17 09:08:19", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140099;}", "0", "1", "2021-11-17 09:08:26", "2021-11-17 09:08:26", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("238", "adjust_download_permissions", "complete", "2021-11-17 09:08:54", "2021-11-17 09:08:54", "[237]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140134;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140134;}", "0", "1", "2021-11-17 09:09:46", "2021-11-17 09:09:46", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("239", "adjust_download_permissions", "complete", "2021-11-17 09:10:38", "2021-11-17 09:10:38", "[236]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140238;}", "0", "1", "2021-11-17 09:10:48", "2021-11-17 09:10:48", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("240", "adjust_download_permissions", "complete", "2021-11-17 09:11:06", "2021-11-17 09:11:06", "[236]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140266;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140266;}", "0", "1", "2021-11-17 09:11:24", "2021-11-17 09:11:24", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("241", "adjust_download_permissions", "complete", "2021-11-17 09:15:42", "2021-11-17 09:15:42", "[235]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140542;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140542;}", "0", "1", "2021-11-17 09:16:47", "2021-11-17 09:16:47", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("242", "adjust_download_permissions", "complete", "2021-11-17 09:17:52", "2021-11-17 09:17:52", "[234]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140672;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140672;}", "0", "1", "2021-11-17 09:18:25", "2021-11-17 09:18:25", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("243", "adjust_download_permissions", "complete", "2021-11-17 09:19:18", "2021-11-17 09:19:18", "[233]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140758;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140758;}", "0", "1", "2021-11-17 09:19:29", "2021-11-17 09:19:29", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("244", "adjust_download_permissions", "complete", "2021-11-17 09:21:01", "2021-11-17 09:21:01", "[232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140861;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140861;}", "0", "1", "2021-11-17 09:21:08", "2021-11-17 09:21:08", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("245", "adjust_download_permissions", "complete", "2021-11-17 09:21:16", "2021-11-17 09:21:16", "[232]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1637140876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1637140876;}", "0", "1", "2021-11-17 09:21:31", "2021-11-17 09:21:31", "0", NULL);
INSERT INTO `HhhEP_actionscheduler_actions` VALUES("246", "wc-admin_import_customers", "complete", "2021-12-01 07:23:00", "2021-12-01 07:23:00", "[1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1638343380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1638343380;}", "2", "1", "2021-12-01 07:23:32", "2021-12-01 07:23:32", "0", NULL);

/* INSERT TABLE DATA: HhhEP_actionscheduler_groups */
INSERT INTO `HhhEP_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `HhhEP_actionscheduler_groups` VALUES("2", "wc-admin-data");

/* INSERT TABLE DATA: HhhEP_actionscheduler_logs */
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("1", "208", "action created", "2021-11-16 07:23:32", "2021-11-16 07:23:32");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("2", "208", "action started via WP Cron", "2021-11-16 07:24:34", "2021-11-16 07:24:34");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("3", "208", "action complete via WP Cron", "2021-11-16 07:24:34", "2021-11-16 07:24:34");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("4", "209", "action created", "2021-11-16 07:24:34", "2021-11-16 07:24:34");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("5", "209", "action started via WP Cron", "2021-11-16 07:25:41", "2021-11-16 07:25:41");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("6", "209", "action complete via WP Cron", "2021-11-16 07:25:41", "2021-11-16 07:25:41");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("7", "210", "action created", "2021-11-16 07:35:51", "2021-11-16 07:35:51");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("8", "210", "action started via WP Cron", "2021-11-16 07:35:51", "2021-11-16 07:35:51");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("9", "210", "action complete via WP Cron", "2021-11-16 07:35:51", "2021-11-16 07:35:51");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("10", "211", "action created", "2021-11-16 08:18:53", "2021-11-16 08:18:53");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("11", "211", "action started via Async Request", "2021-11-16 08:19:12", "2021-11-16 08:19:12");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("12", "211", "action complete via Async Request", "2021-11-16 08:19:12", "2021-11-16 08:19:12");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("13", "212", "action created", "2021-11-16 08:22:53", "2021-11-16 08:22:53");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("14", "212", "action started via WP Cron", "2021-11-16 08:23:28", "2021-11-16 08:23:28");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("15", "212", "action complete via WP Cron", "2021-11-16 08:23:28", "2021-11-16 08:23:28");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("16", "213", "action created", "2021-11-16 08:23:52", "2021-11-16 08:23:52");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("17", "213", "action started via WP Cron", "2021-11-16 08:24:26", "2021-11-16 08:24:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("18", "213", "action complete via WP Cron", "2021-11-16 08:24:26", "2021-11-16 08:24:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("19", "214", "action created", "2021-11-16 08:27:00", "2021-11-16 08:27:00");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("20", "214", "action started via WP Cron", "2021-11-16 08:27:24", "2021-11-16 08:27:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("21", "214", "action complete via WP Cron", "2021-11-16 08:27:24", "2021-11-16 08:27:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("22", "215", "action created", "2021-11-16 08:29:36", "2021-11-16 08:29:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("23", "215", "action started via Async Request", "2021-11-16 08:29:55", "2021-11-16 08:29:55");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("24", "215", "action complete via Async Request", "2021-11-16 08:29:55", "2021-11-16 08:29:55");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("25", "216", "action created", "2021-11-16 08:36:02", "2021-11-16 08:36:02");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("26", "216", "action started via WP Cron", "2021-11-16 08:36:37", "2021-11-16 08:36:37");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("27", "216", "action complete via WP Cron", "2021-11-16 08:36:37", "2021-11-16 08:36:37");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("28", "217", "action created", "2021-11-16 08:39:56", "2021-11-16 08:39:56");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("29", "217", "action started via WP Cron", "2021-11-16 08:40:31", "2021-11-16 08:40:31");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("30", "217", "action complete via WP Cron", "2021-11-16 08:40:31", "2021-11-16 08:40:31");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("31", "218", "action created", "2021-11-16 08:44:39", "2021-11-16 08:44:39");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("32", "218", "action started via Async Request", "2021-11-16 08:45:20", "2021-11-16 08:45:20");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("33", "218", "action complete via Async Request", "2021-11-16 08:45:20", "2021-11-16 08:45:20");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("34", "219", "action created", "2021-11-17 06:31:21", "2021-11-17 06:31:21");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("35", "219", "action started via WP Cron", "2021-11-17 06:31:28", "2021-11-17 06:31:28");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("36", "219", "action complete via WP Cron", "2021-11-17 06:31:28", "2021-11-17 06:31:28");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("37", "220", "action created", "2021-11-17 07:08:19", "2021-11-17 07:08:19");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("38", "220", "action started via WP Cron", "2021-11-17 07:08:26", "2021-11-17 07:08:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("39", "220", "action complete via WP Cron", "2021-11-17 07:08:26", "2021-11-17 07:08:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("40", "221", "action created", "2021-11-17 07:48:33", "2021-11-17 07:48:33");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("41", "221", "action started via Async Request", "2021-11-17 07:48:33", "2021-11-17 07:48:33");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("42", "221", "action complete via Async Request", "2021-11-17 07:48:33", "2021-11-17 07:48:33");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("43", "222", "action created", "2021-11-17 07:51:02", "2021-11-17 07:51:02");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("44", "222", "action started via Async Request", "2021-11-17 07:51:10", "2021-11-17 07:51:10");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("45", "222", "action complete via Async Request", "2021-11-17 07:51:10", "2021-11-17 07:51:10");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("46", "223", "action created", "2021-11-17 07:55:02", "2021-11-17 07:55:02");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("47", "223", "action started via WP Cron", "2021-11-17 07:55:27", "2021-11-17 07:55:27");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("48", "223", "action complete via WP Cron", "2021-11-17 07:55:27", "2021-11-17 07:55:27");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("49", "224", "action created", "2021-11-17 08:01:34", "2021-11-17 08:01:34");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("50", "224", "action started via Async Request", "2021-11-17 08:02:36", "2021-11-17 08:02:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("51", "224", "action complete via Async Request", "2021-11-17 08:02:36", "2021-11-17 08:02:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("52", "225", "action created", "2021-11-17 08:15:57", "2021-11-17 08:15:57");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("53", "225", "action started via Async Request", "2021-11-17 08:16:17", "2021-11-17 08:16:17");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("54", "225", "action complete via Async Request", "2021-11-17 08:16:17", "2021-11-17 08:16:17");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("55", "226", "action created", "2021-11-17 08:18:50", "2021-11-17 08:18:50");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("56", "227", "action created", "2021-11-17 08:18:50", "2021-11-17 08:18:50");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("57", "226", "action started via WP Cron", "2021-11-17 08:19:24", "2021-11-17 08:19:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("58", "226", "action complete via WP Cron", "2021-11-17 08:19:24", "2021-11-17 08:19:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("59", "227", "action started via WP Cron", "2021-11-17 08:19:24", "2021-11-17 08:19:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("60", "227", "action complete via WP Cron", "2021-11-17 08:19:24", "2021-11-17 08:19:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("61", "228", "action created", "2021-11-17 08:20:25", "2021-11-17 08:20:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("62", "229", "action created", "2021-11-17 08:20:25", "2021-11-17 08:20:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("63", "228", "action started via WP Cron", "2021-11-17 08:20:25", "2021-11-17 08:20:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("64", "228", "action complete via WP Cron", "2021-11-17 08:20:25", "2021-11-17 08:20:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("65", "230", "action created", "2021-11-17 08:21:16", "2021-11-17 08:21:16");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("66", "230", "action started via WP Cron", "2021-11-17 08:21:25", "2021-11-17 08:21:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("67", "230", "action complete via WP Cron", "2021-11-17 08:21:25", "2021-11-17 08:21:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("68", "229", "action started via WP Cron", "2021-11-17 08:21:25", "2021-11-17 08:21:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("69", "229", "action complete via WP Cron", "2021-11-17 08:21:25", "2021-11-17 08:21:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("70", "231", "action created", "2021-11-17 08:25:27", "2021-11-17 08:25:27");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("71", "232", "action created", "2021-11-17 08:25:29", "2021-11-17 08:25:29");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("72", "232", "action started via Async Request", "2021-11-17 08:26:05", "2021-11-17 08:26:05");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("73", "232", "action complete via Async Request", "2021-11-17 08:26:05", "2021-11-17 08:26:05");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("74", "231", "action started via Async Request", "2021-11-17 08:26:05", "2021-11-17 08:26:05");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("75", "231", "action complete via Async Request", "2021-11-17 08:26:05", "2021-11-17 08:26:05");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("76", "233", "action created", "2021-11-17 08:29:57", "2021-11-17 08:29:57");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("77", "233", "action started via Async Request", "2021-11-17 08:30:24", "2021-11-17 08:30:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("78", "233", "action complete via Async Request", "2021-11-17 08:30:25", "2021-11-17 08:30:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("79", "234", "action created", "2021-11-17 09:04:32", "2021-11-17 09:04:32");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("80", "234", "action started via WP Cron", "2021-11-17 09:04:35", "2021-11-17 09:04:35");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("81", "235", "action created", "2021-11-17 09:04:35", "2021-11-17 09:04:35");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("82", "234", "action complete via WP Cron", "2021-11-17 09:04:36", "2021-11-17 09:04:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("83", "235", "action started via WP Cron", "2021-11-17 09:04:36", "2021-11-17 09:04:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("84", "235", "action complete via WP Cron", "2021-11-17 09:04:36", "2021-11-17 09:04:36");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("85", "236", "action created", "2021-11-17 09:06:47", "2021-11-17 09:06:47");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("86", "236", "action started via Async Request", "2021-11-17 09:07:08", "2021-11-17 09:07:08");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("87", "236", "action complete via Async Request", "2021-11-17 09:07:08", "2021-11-17 09:07:08");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("88", "237", "action created", "2021-11-17 09:08:18", "2021-11-17 09:08:18");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("89", "237", "action started via WP Cron", "2021-11-17 09:08:26", "2021-11-17 09:08:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("90", "237", "action complete via WP Cron", "2021-11-17 09:08:26", "2021-11-17 09:08:26");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("91", "238", "action created", "2021-11-17 09:08:53", "2021-11-17 09:08:53");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("92", "238", "action started via WP Cron", "2021-11-17 09:09:45", "2021-11-17 09:09:45");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("93", "238", "action complete via WP Cron", "2021-11-17 09:09:45", "2021-11-17 09:09:45");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("94", "239", "action created", "2021-11-17 09:10:37", "2021-11-17 09:10:37");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("95", "239", "action started via Async Request", "2021-11-17 09:10:48", "2021-11-17 09:10:48");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("96", "239", "action complete via Async Request", "2021-11-17 09:10:48", "2021-11-17 09:10:48");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("97", "240", "action created", "2021-11-17 09:11:05", "2021-11-17 09:11:05");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("98", "240", "action started via WP Cron", "2021-11-17 09:11:24", "2021-11-17 09:11:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("99", "240", "action complete via WP Cron", "2021-11-17 09:11:24", "2021-11-17 09:11:24");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("100", "241", "action created", "2021-11-17 09:15:41", "2021-11-17 09:15:41");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("101", "241", "action started via WP Cron", "2021-11-17 09:16:46", "2021-11-17 09:16:46");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("102", "241", "action complete via WP Cron", "2021-11-17 09:16:47", "2021-11-17 09:16:47");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("103", "242", "action created", "2021-11-17 09:17:51", "2021-11-17 09:17:51");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("104", "242", "action started via WP Cron", "2021-11-17 09:18:25", "2021-11-17 09:18:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("105", "242", "action complete via WP Cron", "2021-11-17 09:18:25", "2021-11-17 09:18:25");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("106", "243", "action created", "2021-11-17 09:19:17", "2021-11-17 09:19:17");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("107", "243", "action started via WP Cron", "2021-11-17 09:19:29", "2021-11-17 09:19:29");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("108", "243", "action complete via WP Cron", "2021-11-17 09:19:29", "2021-11-17 09:19:29");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("109", "244", "action created", "2021-11-17 09:21:00", "2021-11-17 09:21:00");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("110", "244", "action started via Async Request", "2021-11-17 09:21:08", "2021-11-17 09:21:08");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("111", "244", "action complete via Async Request", "2021-11-17 09:21:08", "2021-11-17 09:21:08");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("112", "245", "action created", "2021-11-17 09:21:15", "2021-11-17 09:21:15");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("113", "245", "action started via WP Cron", "2021-11-17 09:21:30", "2021-11-17 09:21:30");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("114", "245", "action complete via WP Cron", "2021-11-17 09:21:31", "2021-11-17 09:21:31");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("115", "246", "action created", "2021-12-01 07:22:55", "2021-12-01 07:22:55");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("116", "246", "action started via WP Cron", "2021-12-01 07:23:32", "2021-12-01 07:23:32");
INSERT INTO `HhhEP_actionscheduler_logs` VALUES("117", "246", "action complete via WP Cron", "2021-12-01 07:23:32", "2021-12-01 07:23:32");

/* INSERT TABLE DATA: HhhEP_cff_facebook_feed_locator */
INSERT INTO `HhhEP_cff_facebook_feed_locator` VALUES("1", "*1", "53", "content", "{\"feed\":\"1\"}", "2021-11-12 13:03:46");

/* INSERT TABLE DATA: HhhEP_cff_feed_caches */
INSERT INTO `HhhEP_cff_feed_caches` VALUES("1", "1", "header_backup", "{\"api_url\":\"https://graph.facebook.com/v4.0/108200019864023?fields=id,picture.height(150).width(150),cover,name,link,fan_count,about&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD\", \"shortcode_options\":\"&quot;{&quot;feed&quot;: &quot;1&quot;}&quot;\", \"id\":\"108200019864023\",\"picture\":{\"data\":{\"height\":160,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/p160x160\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=0c64ff&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=8bfc5d80a0b5f17349b6a88061e5d9d5&oe=61B4E51C\",\"width\":160}},\"cover\":{\"cover_id\":\"807336853283666\",\"offset_x\":50,\"offset_y\":100,\"source\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/221614607_807336859950332_6356052588540823365_n.png?_nc_cat=111&ccb=1-5&_nc_sid=1091cb&_nc_ohc=6J9Jasyo2J4AX9FkPFc&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=50ab1399de50c75a850de65da29d9608&oe=61943F1F\",\"id\":\"807336853283666\"},\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\",\"fan_count\":3430,\"about\":\"A wildlife veterinary non-profit organisation\"}", "", "2021-11-12 12:57:25");
INSERT INTO `HhhEP_cff_feed_caches` VALUES("2", "1", "header", "{\"api_url\":\"https://graph.facebook.com/v4.0/108200019864023?fields=id,picture.height(150).width(150),cover,name,link,fan_count,about&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD\", \"shortcode_options\":\"&quot;{&quot;feed&quot;: &quot;1&quot;}&quot;\", \"id\":\"108200019864023\",\"picture\":{\"data\":{\"height\":160,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/p160x160\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=0c64ff&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=8bfc5d80a0b5f17349b6a88061e5d9d5&oe=61B4E51C\",\"width\":160}},\"cover\":{\"cover_id\":\"807336853283666\",\"offset_x\":50,\"offset_y\":100,\"source\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/221614607_807336859950332_6356052588540823365_n.png?_nc_cat=111&ccb=1-5&_nc_sid=1091cb&_nc_ohc=6J9Jasyo2J4AX9FkPFc&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=50ab1399de50c75a850de65da29d9608&oe=61943F1F\",\"id\":\"807336853283666\"},\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\",\"fan_count\":3430,\"about\":\"A wildlife veterinary non-profit organisation\"}", "yes", "2021-11-12 12:57:25");
INSERT INTO `HhhEP_cff_feed_caches` VALUES("3", "1", "posts_backup", "{\"api_url\":\"https://graph.facebook.com/v4.0/108200019864023/posts?fields=id,updated_time,from{picture,id,name,link},message,message_tags,story,story_tags,status_type,created_time,backdated_time,call_to_action,attachments{title,description,media_type,unshimmed_url,target{id},media{source}}&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&limit=5&locale=en_US&return_ssl_resources=true\", \"shortcode_options\":\"&quot;{&quot;feed&quot;: &quot;1&quot;}&quot;\", \"data\":[{\"id\":\"108200019864023_872031983480819\",\"updated_time\":\"2021-11-10T11:24:41+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":652,\"length\":4},{\"id\":\"305119079613711\",\"name\":\"#hyena\",\"offset\":657,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":664,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":672,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":682,\"length\":13}],\"status_type\":\"added_photos\",\"created_time\":\"2021-11-10T11:24:41+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/872031956814155\\/?type=3\",\"target\":{\"id\":\"872031956814155\"}}]}},{\"id\":\"108200019864023_868751733808844\",\"updated_time\":\"2021-11-05T04:40:06+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"\\ud83d\\udce2 EXCITING NEWS \\ud83d\\udce2 \\nThe black rhino orphans have entered their next phase in the rehabilitation process. They were recently relocated into a large enclosure where they will learn to browse and adapt to an environment that they would naturally exist in. \\n\\nAfrican Wildlife Vets has supported and will continue to support an incredible Ezemvelo KZN Wildlife Game Capture team with the care of these orphans.\\n\\nA huge thank you to Rex the Rhino for your support in building the new rhino camp.  \\n\\n#AWV #Rhino #Nature #Conservation #Wildlife\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":492,\"length\":4},{\"id\":\"150880875075377\",\"name\":\"#rhino\",\"offset\":497,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":504,\"length\":7},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":512,\"length\":13},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":526,\"length\":9}],\"status_type\":\"added_video\",\"created_time\":\"2021-11-04T11:01:09+0000\",\"attachments\":{\"data\":[{\"media_type\":\"video\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/videos\\/170090862003158\\/\",\"target\":{\"id\":\"170090862003158\"},\"media\":{\"source\":\"https:\\/\\/video-ort2-1.xx.fbcdn.net\\/v\\/t42.1790-2\\/251093931_115384367605587_5129122713059167620_n.mp4?_nc_cat=102&ccb=1-5&_nc_sid=985c63&efg=eyJybHIiOjQxOSwicmxhIjo1MTIsInZlbmNvZGVfdGFnIjoic3ZlX3NkIn0\\u00253D&_nc_ohc=TFBBfZ6u3H4AX-jYvIZ&rl=419&vabr=233&_nc_ht=video-ort2-1.xx&edm=AKIiGfEEAAAA&oh=7555c7c2acf5f6970b91cfe87de8daff&oe=618FE46C\"}}]}},{\"id\":\"108200019864023_868289520521732\",\"updated_time\":\"2021-11-03T13:54:24+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"status_type\":\"added_photos\",\"created_time\":\"2021-11-03T13:54:24+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/868289493855068\\/?type=3\",\"target\":{\"id\":\"868289493855068\"}}]}},{\"id\":\"108200019864023_864893257528025\",\"updated_time\":\"2021-10-31T14:09:43+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":1814,\"length\":4},{\"id\":\"165827370243341\",\"name\":\"#projectpost\",\"offset\":1819,\"length\":12},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":1832,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":1840,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":1850,\"length\":13},{\"id\":\"497313510325119\",\"name\":\"#wilddog\",\"offset\":1864,\"length\":8}],\"status_type\":\"added_photos\",\"created_time\":\"2021-10-28T10:21:27+0000\",\"attachments\":{\"data\":[{\"description\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864893227528028\\/?type=3\",\"target\":{\"id\":\"864893227528028\"}}]}},{\"id\":\"108200019864023_864348374249180\",\"updated_time\":\"2021-10-27T11:06:15+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":362,\"length\":4},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":367,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":375,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":385,\"length\":13},{\"id\":\"134910703348539\",\"name\":\"#ostrich\",\"offset\":399,\"length\":8}],\"status_type\":\"added_photos\",\"created_time\":\"2021-10-27T11:06:15+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864348327582518\\/?type=3\",\"target\":{\"id\":\"864348327582518\"}}]}}],\"paging\":{\"cursors\":{\"before\":\"QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\",\"after\":\"QVFIUm9OTTNJUk1VRkgyNF9rb1pFVk13bV8ydm1PaG1FOXI4VlpoSkFyd3RPVDlSUndPMm42c3l3SFBDWlF3QzJqWWctMG16VWQyOXdlVWlFZAkIyMXAtTzk5dTV5M0pSN1EwNHFiSU81LVZArNGhhVW1xaThQcUhqeXIzS2pFR1MwMXNr\"},\"next\":\"https:\\/\\/graph.facebook.com\\/v5.0\\/108200019864023\\/posts?access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&locale=en_US&fields=id\\u00252Cupdated_time\\u00252Cfrom\\u00257Bpicture\\u00252Cid\\u00252Cname\\u00252Clink\\u00257D\\u00252Cmessage\\u00252Cmessage_tags\\u00252Cstory\\u00252Cstory_tags\\u00252Cstatus_type\\u00252Ccreated_time\\u00252Cbackdated_time\\u00252Ccall_to_action\\u00252Cattachments\\u00257Btitle\\u00252Cdescription\\u00252Cmedia_type\\u00252Cunshimmed_url\\u00252Ctarget\\u00257Bid\\u00257D\\u00252Cmedia\\u00257Bsource\\u00257D\\u00257D&limit=5&after=QVFIUm9OTTNJUk1VRkgyNF9rb1pFVk13bV8ydm1PaG1FOXI4VlpoSkFyd3RPVDlSUndPMm42c3l3SFBDWlF3QzJqWWctMG16VWQyOXdlVWlFZAkIyMXAtTzk5dTV5M0pSN1EwNHFiSU81LVZArNGhhVW1xaThQcUhqeXIzS2pFR1MwMXNr\"}}", "", "2021-11-12 12:57:22");
INSERT INTO `HhhEP_cff_feed_caches` VALUES("4", "1", "posts", "{\"api_url\":\"https://graph.facebook.com/v4.0/108200019864023/posts?fields=id,updated_time,from{picture,id,name,link},message,message_tags,story,story_tags,status_type,created_time,backdated_time,call_to_action,attachments{title,description,media_type,unshimmed_url,target{id},media{source}}&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&limit=5&locale=en_US&return_ssl_resources=true\", \"shortcode_options\":\"&quot;{&quot;feed&quot;: &quot;1&quot;}&quot;\", \"data\":[{\"id\":\"108200019864023_872031983480819\",\"updated_time\":\"2021-11-10T11:24:41+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":652,\"length\":4},{\"id\":\"305119079613711\",\"name\":\"#hyena\",\"offset\":657,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":664,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":672,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":682,\"length\":13}],\"status_type\":\"added_photos\",\"created_time\":\"2021-11-10T11:24:41+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/872031956814155\\/?type=3\",\"target\":{\"id\":\"872031956814155\"}}]}},{\"id\":\"108200019864023_868751733808844\",\"updated_time\":\"2021-11-05T04:40:06+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"\\ud83d\\udce2 EXCITING NEWS \\ud83d\\udce2 \\nThe black rhino orphans have entered their next phase in the rehabilitation process. They were recently relocated into a large enclosure where they will learn to browse and adapt to an environment that they would naturally exist in. \\n\\nAfrican Wildlife Vets has supported and will continue to support an incredible Ezemvelo KZN Wildlife Game Capture team with the care of these orphans.\\n\\nA huge thank you to Rex the Rhino for your support in building the new rhino camp.  \\n\\n#AWV #Rhino #Nature #Conservation #Wildlife\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":492,\"length\":4},{\"id\":\"150880875075377\",\"name\":\"#rhino\",\"offset\":497,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":504,\"length\":7},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":512,\"length\":13},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":526,\"length\":9}],\"status_type\":\"added_video\",\"created_time\":\"2021-11-04T11:01:09+0000\",\"attachments\":{\"data\":[{\"media_type\":\"video\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/videos\\/170090862003158\\/\",\"target\":{\"id\":\"170090862003158\"},\"media\":{\"source\":\"https:\\/\\/video-ort2-1.xx.fbcdn.net\\/v\\/t42.1790-2\\/251093931_115384367605587_5129122713059167620_n.mp4?_nc_cat=102&ccb=1-5&_nc_sid=985c63&efg=eyJybHIiOjQxOSwicmxhIjo1MTIsInZlbmNvZGVfdGFnIjoic3ZlX3NkIn0\\u00253D&_nc_ohc=TFBBfZ6u3H4AX-jYvIZ&rl=419&vabr=233&_nc_ht=video-ort2-1.xx&edm=AKIiGfEEAAAA&oh=7555c7c2acf5f6970b91cfe87de8daff&oe=618FE46C\"}}]}},{\"id\":\"108200019864023_868289520521732\",\"updated_time\":\"2021-11-03T13:54:24+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"status_type\":\"added_photos\",\"created_time\":\"2021-11-03T13:54:24+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/868289493855068\\/?type=3\",\"target\":{\"id\":\"868289493855068\"}}]}},{\"id\":\"108200019864023_864893257528025\",\"updated_time\":\"2021-10-31T14:09:43+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":1814,\"length\":4},{\"id\":\"165827370243341\",\"name\":\"#projectpost\",\"offset\":1819,\"length\":12},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":1832,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":1840,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":1850,\"length\":13},{\"id\":\"497313510325119\",\"name\":\"#wilddog\",\"offset\":1864,\"length\":8}],\"status_type\":\"added_photos\",\"created_time\":\"2021-10-28T10:21:27+0000\",\"attachments\":{\"data\":[{\"description\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864893227528028\\/?type=3\",\"target\":{\"id\":\"864893227528028\"}}]}},{\"id\":\"108200019864023_864348374249180\",\"updated_time\":\"2021-10-27T11:06:15+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":362,\"length\":4},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":367,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":375,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":385,\"length\":13},{\"id\":\"134910703348539\",\"name\":\"#ostrich\",\"offset\":399,\"length\":8}],\"status_type\":\"added_photos\",\"created_time\":\"2021-10-27T11:06:15+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864348327582518\\/?type=3\",\"target\":{\"id\":\"864348327582518\"}}]}}],\"paging\":{\"cursors\":{\"before\":\"QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\",\"after\":\"QVFIUm9OTTNJUk1VRkgyNF9rb1pFVk13bV8ydm1PaG1FOXI4VlpoSkFyd3RPVDlSUndPMm42c3l3SFBDWlF3QzJqWWctMG16VWQyOXdlVWlFZAkIyMXAtTzk5dTV5M0pSN1EwNHFiSU81LVZArNGhhVW1xaThQcUhqeXIzS2pFR1MwMXNr\"},\"next\":\"https:\\/\\/graph.facebook.com\\/v5.0\\/108200019864023\\/posts?access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&locale=en_US&fields=id\\u00252Cupdated_time\\u00252Cfrom\\u00257Bpicture\\u00252Cid\\u00252Cname\\u00252Clink\\u00257D\\u00252Cmessage\\u00252Cmessage_tags\\u00252Cstory\\u00252Cstory_tags\\u00252Cstatus_type\\u00252Ccreated_time\\u00252Cbackdated_time\\u00252Ccall_to_action\\u00252Cattachments\\u00257Btitle\\u00252Cdescription\\u00252Cmedia_type\\u00252Cunshimmed_url\\u00252Ctarget\\u00257Bid\\u00257D\\u00252Cmedia\\u00257Bsource\\u00257D\\u00257D&limit=5&after=QVFIUm9OTTNJUk1VRkgyNF9rb1pFVk13bV8ydm1PaG1FOXI4VlpoSkFyd3RPVDlSUndPMm42c3l3SFBDWlF3QzJqWWctMG16VWQyOXdlVWlFZAkIyMXAtTzk5dTV5M0pSN1EwNHFiSU81LVZArNGhhVW1xaThQcUhqeXIzS2pFR1MwMXNr\"}}", "yes", "2021-11-12 12:57:22");

/* INSERT TABLE DATA: HhhEP_cff_feeds */
INSERT INTO `HhhEP_cff_feeds` VALUES("1", "African Wildlife Vets", "", "{\"sources\":\"108200019864023\",\"accesstoken\":\"EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD\",\"ownaccesstoken\":\"true\",\"pagetoken\":\"\",\"id\":\"108200019864023\",\"pagetype\":\"page\",\"num\":\"3\",\"limit\":\"\",\"others\":\"\",\"showpostsby\":\"me\",\"cachetype\":\"background\",\"cachetime\":\"1\",\"cacheunit\":\"hours\",\"locale\":\"en_US\",\"storytags\":\"false\",\"ajax\":\"\",\"offset\":\"\",\"account\":\"\",\"width\":\"100%\",\"widthresp\":\"\",\"height\":\"650\",\"padding\":\"\",\"bgcolor\":\"#\",\"showauthor\":\"\",\"showauthornew\":\"true\",\"class\":\"\",\"type\":[\"links\",\"events\",\"videos\",\"photos\",\"albums\",\"statuses\"],\"gdpr\":\"auto\",\"loadiframes\":\"false\",\"eventsource\":\"eventspage\",\"eventoffset\":\"6\",\"eventimage\":\"full\",\"pastevents\":\"false\",\"albumsource\":\"photospage\",\"showalbumtitle\":\"on\",\"showalbumnum\":\"on\",\"albumcols\":\"4\",\"photosource\":\"photospage\",\"photocols\":\"4\",\"videosource\":\"videospage\",\"showvideoname\":\"on\",\"showvideodesc\":\"on\",\"videocols\":\"4\",\"playlist\":\"\",\"disablelightbox\":\"on\",\"filter\":\"\",\"exfilter\":\"\",\"layout\":\"full\",\"enablenarrow\":\"on\",\"oneimage\":\"\",\"mediaposition\":\"below\",\"include\":[\"author\",\"text\",\"desc\",\"sharedlinks\",\"date\",\"medialink\",\"eventtitle\",\"eventdetails\",\"link\",\"likebox\"],\"exclude\":\"\",\"masonry\":\"\",\"masonrycols\":\"\",\"masonrycolsmobile\":\"\",\"masonryjs\":\"true\",\"cols\":\"1\",\"colsmobile\":\"1\",\"colsjs\":\"true\",\"nummobile\":\"3\",\"poststyle\":\"regular\",\"postbgcolor\":\"#\",\"postcorners\":\"0\",\"boxshadow\":\"\",\"textformat\":\"p\",\"textsize\":\"inherit\",\"textweight\":\"inherit\",\"textcolor\":\"#\",\"textlinkcolor\":\"#\",\"textlink\":\"\",\"posttags\":\"on\",\"linkhashtags\":\"on\",\"lightboxcomments\":\"off\",\"authorsize\":\"inherit\",\"authorcolor\":\"#\",\"descsize\":\"12\",\"descweight\":\"inherit\",\"desccolor\":\"#\",\"linktitleformat\":\"p\",\"linktitlesize\":\"inherit\",\"linkdescsize\":\"inherit\",\"linkurlsize\":\"12\",\"linkdesccolor\":\"#\",\"linktitlecolor\":\"#\",\"linkurlcolor\":\"#\",\"linkbgcolor\":\"#\",\"linkbordercolor\":\"#\",\"disablelinkbox\":\"off\",\"eventtitleformat\":\"p\",\"eventtitlesize\":\"inherit\",\"eventtitleweight\":\"inherit\",\"eventtitlecolor\":\"#\",\"eventtitlelink\":\"true\",\"eventdatesize\":\"inherit\",\"eventdateweight\":\"inherit\",\"eventdatecolor\":\"#\",\"eventdatepos\":\"below\",\"eventdateformat\":\"14\",\"eventdatecustom\":\"\",\"timezoneoffset\":\"false\",\"cff_enqueue_with_shortcode\":\"false\",\"eventdetailssize\":\"inherit\",\"eventdetailsweight\":\"inherit\",\"eventdetailscolor\":\"#\",\"eventlinkcolor\":\"#\",\"datepos\":\"author\",\"datesize\":\"inherit\",\"dateweight\":\"inherit\",\"datecolor\":\"#\",\"dateformat\":\"1\",\"datecustom\":\"\",\"timezone\":\"America\\/Chicago\",\"beforedate\":\"\",\"afterdate\":\"\",\"linksize\":\"inherit\",\"linkweight\":\"inherit\",\"linkcolor\":\"#\",\"linktotimeline\":\"false\",\"buttoncolor\":\"\",\"buttonhovercolor\":\"\",\"buttontextcolor\":\"\",\"buttontext\":\"Load more\",\"facebooklinktext\":\"View on Facebook\",\"sharelinktext\":\"Share\",\"iconstyle\":\"light\",\"socialtextcolor\":\"#\",\"socialbgcolor\":\"#\",\"sociallinkcolor\":\"#\",\"expandcomments\":\"\",\"commentsnum\":\"4\",\"hidecommentimages\":\"\",\"loadcommentsjs\":\"false\",\"salesposts\":\"false\",\"textlength\":\"400\",\"desclength\":\"200\",\"showlikebox\":\"on\",\"likeboxpos\":\"bottom\",\"likeboxoutside\":\"\",\"likeboxcolor\":\"\",\"likeboxtextcolor\":\"blue\",\"likeboxwidth\":\"\",\"likeboxfaces\":\"\",\"likeboxborder\":\"\",\"likeboxcover\":\"on\",\"likeboxsmallheader\":\"off\",\"likeboxhidebtn\":\"\",\"credit\":\"\",\"textissue\":\"\",\"disablesvgs\":\"\",\"restrictedpage\":\"\",\"hidesupporterposts\":\"\",\"privategroup\":\"false\",\"nofollow\":\"true\",\"timelinepag\":\"date\",\"gridpag\":\"auto\",\"disableresize\":\"false\",\"showheader\":\"on\",\"headertype\":\"visual\",\"headercover\":\"on\",\"headeravatar\":\"\",\"headername\":\"on\",\"headerbio\":\"on\",\"headercoverheight\":\"300\",\"headerlikes\":\"\",\"headeroutside\":\"on\",\"headertext\":\"Facebook Posts\",\"headerbg\":\"#\",\"headerpadding\":\"\",\"headertextsize\":\"inherit\",\"headertextweight\":\"inherit\",\"headertextcolor\":\"#\",\"headericon\":\"facebook-square\",\"headericoncolor\":\"#\",\"headericonsize\":\"28\",\"headerinc\":\"\",\"headerexclude\":\"\",\"loadmore\":\"on\",\"fulllinkimages\":\"on\",\"linkimagesize\":\"largesquare\",\"postimagesize\":\"large\",\"videoheight\":\"\",\"videoaction\":\"post\",\"videoplayer\":\"facebook\",\"sepcolor\":\"#ddd\",\"sepsize\":\"1\",\"photostext\":\"photos\",\"showfacebooklink\":\"true\",\"showsharelink\":\"true\",\"multifeedactive\":\"false\",\"daterangeactive\":\"false\",\"featuredpostactive\":\"false\",\"albumactive\":\"false\",\"masonryactive\":\"false\",\"carouselactive\":\"false\",\"reviewsactive\":\"false\",\"from\":\"\",\"until\":\"\",\"daterangefromtype\":\"specific\",\"daterangefromspecific\":\"\",\"daterangefromrelative\":\"\",\"daterangeuntiltype\":\"specific\",\"daterangeuntilspecific\":\"\",\"daterangeuntilrelative\":\"\",\"featuredpost\":\"\",\"album\":\"\",\"daterange\":\"off\",\"lightbox\":\"off\",\"reviewsrated\":\"1,2,3,4,5\",\"starsize\":\"12\",\"hidenegative\":\"\",\"reviewslinktext\":\"View all Reviews\",\"reviewshidenotext\":\"\",\"reviewsmethod\":\"all\",\"feedtype\":\"timeline\",\"likeboxcustomwidth\":\"\",\"colstablet\":\"1\",\"feedlayout\":\"masonry\",\"colorpalette\":\"inherit\",\"custombgcolor1\":\"\",\"custombgcolor2\":\"\",\"textcolor1\":\"\",\"textcolor2\":\"\",\"customlinkcolor\":\"\",\"posttextcolor\":\"\",\"misctextcolor\":\"\",\"misclinkcolor\":\"\",\"headericonenabled\":\"on\",\"lightboxbgcolor\":\"\",\"lightboxtextcolor\":\"\",\"lightboxlinkcolor\":\"\",\"beforedateenabled\":\"off\",\"afterdateenabled\":\"off\",\"showpoststypes\":\"custom\",\"headerbiosize\":\"inherit\",\"headerbiocolor\":\"#\",\"apipostlimit\":\"auto\",\"carouselheight\":\"tallest\",\"carouseldesktop_cols\":\"1\",\"carouselmobile_cols\":\"1\",\"carouselnavigation\":\"none\",\"carouselpagination\":\"true\",\"carouselautoplay\":\"false\",\"carouselinterval\":\"5000\",\"nonce\":\"013bf73720\"}", "1", "publish", "2021-11-12 12:56:51");

/* INSERT TABLE DATA: HhhEP_cff_sources */
INSERT INTO `HhhEP_cff_sources` VALUES("1", "108200019864023", "page", "", "EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD", "African Wildlife Vets", "{\"api_url\":\"https:\\/\\/graph.facebook.com\\/v4.0\\/108200019864023?fields=id,picture.height(150).width(150),cover,name,link,fan_count,about&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD\",\"id\":\"108200019864023\",\"picture\":{\"data\":{\"height\":160,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/p160x160\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=0c64ff&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=8bfc5d80a0b5f17349b6a88061e5d9d5&oe=61B4E51C\",\"width\":160}},\"cover\":{\"cover_id\":\"807336853283666\",\"offset_x\":50,\"offset_y\":100,\"source\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/221614607_807336859950332_6356052588540823365_n.png?_nc_cat=111&ccb=1-5&_nc_sid=1091cb&_nc_ohc=6J9Jasyo2J4AX9FkPFc&_nc_ht=scontent-ort2-1.xx&edm=AJdBtusEAAAA&oh=50ab1399de50c75a850de65da29d9608&oe=61943F1F\",\"id\":\"807336853283666\"},\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\",\"fan_count\":3430,\"about\":\"A wildlife veterinary non-profit organisation\"}", "", "2100-12-30 00:00:00", "2021-11-12 12:48:11", "2");

/* INSERT TABLE DATA: HhhEP_commentmeta */
INSERT INTO `HhhEP_commentmeta` VALUES("1", "1", "_wp_trash_meta_status", "1");
INSERT INTO `HhhEP_commentmeta` VALUES("2", "1", "_wp_trash_meta_time", "1637061954");

/* INSERT TABLE DATA: HhhEP_comments */
INSERT INTO `HhhEP_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-10-25 13:57:57", "2021-10-25 13:57:57", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "trash", "", "comment", "0", "0");

/* INSERT TABLE DATA: HhhEP_duplicator_packages */
INSERT INTO `HhhEP_duplicator_packages` VALUES("1", "20211201_africanwildlifevets", "5c6d3c967314cadb5169_20211201072518", "22", "2021-12-01 07:26:14", "unknown", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-12-01 07:25:18\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:28:\"20211201_africanwildlifevets\";s:4:\"Hash\";s:35:\"5c6d3c967314cadb5169_20211201072518\";s:8:\"NameHash\";s:64:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:74:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.8\";s:6:\"WPUser\";s:7:\"unknown\";s:7:\"Archive\";O:11:\"DUP_Archive\":21:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:76:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:55:\"/home2/xcontent2020/public_html/dev.africanwildlifevets\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:5:\"Files\";a:0:{}s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2021-12-01 07:25:18\";s:7:\"Version\";s:5:\"1.4.3\";s:9:\"VersionWP\";s:5:\"5.8.2\";s:9:\"VersionDB\";s:6:\"5.7.36\";s:10:\"VersionPHP\";s:6:\"7.4.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:28:\"20211201_africanwildlifevets\";s:4:\"Hash\";s:35:\"5c6d3c967314cadb5169_20211201072518\";s:8:\"NameHash\";s:64:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":13:{s:4:\"File\";s:78:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518_installer.php\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:63;}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:77:\"20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:4:\"info\";O:16:\"DUP_DatabaseInfo\":16:{s:9:\"buildMode\";N;s:13:\"collationList\";a:0:{}s:17:\"isTablesUpperCase\";N;s:15:\"isNameUpperCase\";N;s:4:\"name\";N;s:15:\"tablesBaseCount\";N;s:16:\"tablesFinalCount\";N;s:14:\"tablesRowCount\";N;s:16:\"tablesSizeOnDisk\";N;s:18:\"varLowerCaseTables\";i:0;s:7:\"version\";N;s:14:\"versionComment\";N;s:18:\"tableWiseRowCounts\";a:9:{s:29:\"HhhEP_actionscheduler_actions\";s:2:\"39\";s:28:\"HhhEP_actionscheduler_claims\";s:1:\"0\";s:28:\"HhhEP_actionscheduler_groups\";s:1:\"2\";s:26:\"HhhEP_actionscheduler_logs\";s:3:\"117\";s:31:\"HhhEP_cff_facebook_feed_locator\";s:1:\"1\";s:21:\"HhhEP_cff_feed_caches\";s:1:\"4\";s:15:\"HhhEP_cff_feeds\";s:1:\"1\";s:17:\"HhhEP_cff_sources\";s:1:\"1\";s:17:\"HhhEP_commentmeta\";s:1:\"2\";}s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:165:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-content/backups-dup-lite/tmp/20211201_africanwildlifevets_5c6d3c967314cadb5169_20211201072518_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;s:19:\"sameNameTableExists\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:63;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:5:{i:0;s:64:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-admin\";i:1;s:74:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-content/uploads\";i:2;s:76:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-content/languages\";i:3;s:73:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-content/themes\";i:4;s:67:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-includes\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:2:{i:0;s:55:\"/home2/xcontent2020/public_html/dev.africanwildlifevets\";i:1;s:66:\"/home2/xcontent2020/public_html/dev.africanwildlifevets/wp-content\";}}s:9:\"Installer\";r:84;s:8:\"Database\";r:98;s:13:\"BuildProgress\";r:139;}");

/* INSERT TABLE DATA: HhhEP_options */
INSERT INTO `HhhEP_options` VALUES("1", "siteurl", "https://dev.africanwildlifevets.xcontent.com", "yes");
INSERT INTO `HhhEP_options` VALUES("2", "home", "https://dev.africanwildlifevets.xcontent.com", "yes");
INSERT INTO `HhhEP_options` VALUES("3", "blogname", "African Wildlife Vets", "yes");
INSERT INTO `HhhEP_options` VALUES("4", "blogdescription", "Protecting and Saving Wildlife Species", "yes");
INSERT INTO `HhhEP_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("6", "admin_email", "admin@dev.africanwildlifevets.xcontent.com", "yes");
INSERT INTO `HhhEP_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("10", "require_name_email", "", "yes");
INSERT INTO `HhhEP_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `HhhEP_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `HhhEP_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `HhhEP_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `HhhEP_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `HhhEP_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `HhhEP_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `HhhEP_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `HhhEP_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `HhhEP_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `HhhEP_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `HhhEP_options` VALUES("26", "comment_moderation", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `HhhEP_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `HhhEP_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `HhhEP_options` VALUES("33", "active_plugins", "a:6:{i:0;s:45:\"custom-facebook-feed/custom-facebook-feed.php\";i:1;s:25:\"duplicator/duplicator.php\";i:2;s:33:\"instagram-feed/instagram-feed.php\";i:3;s:47:\"woocommerce-payfast-gateway/gateway-payfast.php\";i:4;s:27:\"woocommerce/woocommerce.php\";i:5;s:24:\"wordpress-seo/wp-seo.php\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `HhhEP_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `HhhEP_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `HhhEP_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `HhhEP_options` VALUES("40", "template", "flatsome", "yes");
INSERT INTO `HhhEP_options` VALUES("41", "stylesheet", "flatsome", "yes");
INSERT INTO `HhhEP_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `HhhEP_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `HhhEP_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `HhhEP_options` VALUES("46", "db_version", "49752", "yes");
INSERT INTO `HhhEP_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `HhhEP_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `HhhEP_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `HhhEP_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `HhhEP_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `HhhEP_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `HhhEP_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `HhhEP_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `HhhEP_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `HhhEP_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `HhhEP_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `HhhEP_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `HhhEP_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `HhhEP_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `HhhEP_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `HhhEP_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `HhhEP_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `HhhEP_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `HhhEP_options` VALUES("69", "thread_comments", "", "yes");
INSERT INTO `HhhEP_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `HhhEP_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `HhhEP_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `HhhEP_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `HhhEP_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `HhhEP_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("79", "uninstall_plugins", "a:2:{s:33:\"instagram-feed/instagram-feed.php\";s:22:\"sb_instagram_uninstall\";s:45:\"custom-facebook-feed/custom-facebook-feed.php\";a:2:{i:0;s:39:\"CustomFacebookFeed\\Custom_Facebook_Feed\";i:1;s:13:\"cff_uninstall\";}}", "no");
INSERT INTO `HhhEP_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `HhhEP_options` VALUES("81", "page_for_posts", "283", "yes");
INSERT INTO `HhhEP_options` VALUES("82", "page_on_front", "53", "yes");
INSERT INTO `HhhEP_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("86", "site_icon", "6", "yes");
INSERT INTO `HhhEP_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `HhhEP_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `HhhEP_options` VALUES("90", "show_comments_cookies_opt_in", "", "yes");
INSERT INTO `HhhEP_options` VALUES("91", "admin_email_lifespan", "1650722277", "yes");
INSERT INTO `HhhEP_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `HhhEP_options` VALUES("93", "comment_previously_approved", "", "yes");
INSERT INTO `HhhEP_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `HhhEP_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `HhhEP_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `HhhEP_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `HhhEP_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("99", "initial_db_version", "49752", "yes");
INSERT INTO `HhhEP_options` VALUES("100", "HhhEP_user_roles", "a:9:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:117:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:20:\"wpseo_manage_options\";b:1;s:29:\"manage_instagram_feed_options\";b:1;s:35:\"manage_custom_facebook_feed_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:13:\"wpseo_manager\";a:2:{s:4:\"name\";s:11:\"SEO Manager\";s:12:\"capabilities\";a:38:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:23:\"view_site_health_checks\";b:1;}}s:12:\"wpseo_editor\";a:2:{s:4:\"name\";s:10:\"SEO Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}}", "yes");
INSERT INTO `HhhEP_options` VALUES("101", "fresh_site", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("102", "widget_block", "a:3:{i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("103", "sidebars_widgets", "a:7:{s:19:\"wp_inactive_widgets\";a:0:{}s:12:\"sidebar-main\";a:1:{i:0;s:14:\"recent-posts-2\";}s:16:\"sidebar-footer-1\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:16:\"sidebar-footer-2\";a:0:{}s:12:\"shop-sidebar\";a:1:{i:0;s:32:\"woocommerce_product_categories-3\";}s:15:\"product-sidebar\";a:1:{i:0;s:32:\"woocommerce_product_categories-2\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `HhhEP_options` VALUES("104", "cron", "a:25:{i:1638343584;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1638344088;a:1:{s:25:\"group_post_scheduler_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638345478;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638346960;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1638347011;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638347017;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1638354208;a:1:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638358479;a:1:{s:23:\"sb_instagram_twicedaily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638358488;a:1:{s:12:\"cff_cron_job\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638365008;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638367078;a:4:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:18:\"wp_https_detection\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638367203;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638367205;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638368323;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638381421;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1638403200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638429811;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638429818;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1638438298;a:1:{s:23:\"cff_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638552693;a:1:{s:23:\"sbi_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638770400;a:4:{s:29:\"sb_instagram_feed_issue_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"sbiweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:23:\"sbi_notification_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"sbiweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:20:\"cff_feed_issue_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"cffweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:23:\"cff_notification_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:9:\"cffweekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638800323;a:1:{s:16:\"wpseo_ryte_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1638885478;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1639639468;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `HhhEP_options` VALUES("105", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("106", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("107", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("108", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("109", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("110", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("111", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("112", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("113", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("114", "nonce_key", "cd=eZ)RQpD-KNKXb(kwS/U<4#P1W{kpSw/!}AQm2z<RVK8h,^jj]{Wd@O;sh(LN0", "no");
INSERT INTO `HhhEP_options` VALUES("115", "nonce_salt", "Fyk[ApnU%13_,qt*zlEOnM-[1%.M-d34`CVmF-s5>;z,t?z]9)W<c-L7i}f#Q?K[", "no");
INSERT INTO `HhhEP_options` VALUES("116", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("117", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("118", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("121", "recovery_keys", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("122", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1635170455;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "yes");
INSERT INTO `HhhEP_options` VALUES("123", "https_detection_errors", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("133", "can_compress_scripts", "0", "no");
INSERT INTO `HhhEP_options` VALUES("147", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1638343502;s:7:\"checked\";a:4:{s:8:\"flatsome\";s:6:\"3.14.3\";s:14:\"twentynineteen\";s:3:\"2.1\";s:12:\"twentytwenty\";s:3:\"1.8\";s:15:\"twentytwentyone\";s:3:\"1.4\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:4:{s:14:\"twentynineteen\";a:6:{s:5:\"theme\";s:14:\"twentynineteen\";s:11:\"new_version\";s:3:\"2.1\";s:3:\"url\";s:44:\"https://wordpress.org/themes/twentynineteen/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/theme/twentynineteen.2.1.zip\";s:8:\"requires\";s:5:\"4.9.6\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:12:\"twentytwenty\";a:6:{s:5:\"theme\";s:12:\"twentytwenty\";s:11:\"new_version\";s:3:\"1.8\";s:3:\"url\";s:42:\"https://wordpress.org/themes/twentytwenty/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/theme/twentytwenty.1.8.zip\";s:8:\"requires\";s:3:\"4.7\";s:12:\"requires_php\";s:5:\"5.2.4\";}s:15:\"twentytwentyone\";a:6:{s:5:\"theme\";s:15:\"twentytwentyone\";s:11:\"new_version\";s:3:\"1.4\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentyone/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentyone.1.4.zip\";s:8:\"requires\";s:3:\"5.3\";s:12:\"requires_php\";s:3:\"5.6\";}s:8:\"flatsome\";a:4:{s:5:\"theme\";s:8:\"flatsome\";s:11:\"new_version\";s:6:\"3.14.3\";s:3:\"url\";s:105:\"https://dev.africanwildlifevets.xcontent.com/wp-admin/admin.php?page=flatsome-version-info&version=3.14.3\";s:7:\"package\";s:127:\"https://dev.africanwildlifevets.xcontent.com/wp-admin/admin.php?page=flatsome-panel&flatsome_version=3.14.3&flatsome_download=1\";}}s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `HhhEP_options` VALUES("148", "current_theme", "Flatsome", "yes");
INSERT INTO `HhhEP_options` VALUES("149", "theme_mods_flatsome", "a:124:{i:0;b:0;s:17:\"flatsome_fallback\";i:0;s:20:\"topbar_elements_left\";a:1:{i:0;s:4:\"html\";}s:21:\"topbar_elements_right\";a:1:{i:0;s:6:\"search\";}s:20:\"header_elements_left\";a:0:{}s:21:\"header_elements_right\";a:3:{i:0;s:3:\"nav\";i:1;s:7:\"divider\";i:2;s:4:\"cart\";}s:27:\"header_elements_bottom_left\";a:0:{}s:29:\"header_elements_bottom_center\";a:0:{}s:28:\"header_elements_bottom_right\";a:1:{i:0;s:6:\"social\";}s:27:\"header_mobile_elements_left\";a:1:{i:0;s:9:\"menu-icon\";}s:28:\"header_mobile_elements_right\";a:1:{i:0;s:4:\"cart\";}s:26:\"header_mobile_elements_top\";a:1:{i:0;s:4:\"html\";}s:14:\"mobile_sidebar\";a:5:{i:0;s:11:\"search-form\";i:1;s:3:\"nav\";i:2;s:7:\"account\";i:3;s:6:\"html-2\";i:4;s:6:\"html-3\";}s:14:\"product_layout\";s:13:\"right-sidebar\";s:23:\"payment_icons_placement\";a:1:{i:0;s:6:\"footer\";}s:14:\"follow_twitter\";s:31:\"https://twitter.com/AfricanVets\";s:15:\"follow_facebook\";s:48:\"https://www.facebook.com/africanwildlifevets.org\";s:16:\"follow_instagram\";s:46:\"https://www.instagram.com/africanwildlifevets/\";s:12:\"follow_email\";s:0:\"\";s:16:\"flatsome_version\";i:3;s:24:\"portfolio_archive_filter\";s:4:\"left\";s:13:\"type_headings\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:10:\"type_texts\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"400\";}s:8:\"type_nav\";a:2:{s:11:\"font-family\";s:4:\"Lato\";s:7:\"variant\";s:3:\"700\";}s:8:\"type_alt\";a:2:{s:11:\"font-family\";s:14:\"Dancing Script\";s:7:\"variant\";s:3:\"400\";}s:14:\"pages_template\";s:5:\"blank\";s:11:\"site_loader\";s:0:\"\";s:19:\"flatsome_db_version\";s:6:\"3.14.3\";s:18:\"nav_menu_locations\";a:3:{s:7:\"primary\";i:2;s:14:\"primary_mobile\";i:2;s:6:\"footer\";i:2;}s:7:\"backups\";N;s:9:\"smof_init\";s:31:\"Mon, 25 Oct 2021 14:00:55 +0000\";s:18:\"custom_css_post_id\";i:-1;s:9:\"site_logo\";s:113:\"https://dev.africanwildlifevets.xcontent.com/wp-content/uploads/2021/10/African-Wildlife-Vets-Logo-Horizontal.png\";s:10:\"logo_width\";s:3:\"328\";s:12:\"logo_padding\";s:1:\"0\";s:11:\"topbar_left\";s:73:\"<strong class=\"uppercase\">Protecting and Saving Wildlife Species</strong>\";s:13:\"color_primary\";s:7:\"#000000\";s:15:\"color_secondary\";s:7:\"#e0e0e0\";s:11:\"color_links\";s:7:\"#1e73be\";s:13:\"header_height\";s:3:\"115\";s:12:\"header_color\";s:5:\"light\";s:9:\"header_bg\";s:22:\"rgba(255,255,255,0.51)\";s:9:\"nav_style\";s:7:\"divided\";s:10:\"nav_height\";s:2:\"16\";s:8:\"nav_push\";s:1:\"0\";s:25:\"header_height_transparent\";s:3:\"265\";s:14:\"mobile_overlay\";s:6:\"center\";s:20:\"header_height_sticky\";s:2:\"90\";s:19:\"sticky_logo_padding\";s:1:\"5\";s:17:\"nav_height_sticky\";s:2:\"50\";s:12:\"sticky_style\";s:4:\"fade\";s:17:\"dropdown_nav_size\";s:2:\"99\";s:15:\"follow_linkedin\";s:55:\"https://www.linkedin.com/company/african-wildlife-vets/\";s:11:\"preset_demo\";s:14:\"header-default\";s:22:\"topbar_elements_center\";a:0:{}s:29:\"header_mobile_elements_bottom\";a:0:{}s:13:\"logo_position\";s:4:\"left\";s:11:\"topbar_show\";b:1;s:17:\"header_top_height\";s:2:\"30\";s:12:\"topbar_color\";s:4:\"dark\";s:9:\"topbar_bg\";s:0:\"\";s:13:\"nav_style_top\";s:7:\"divided\";s:12:\"header_width\";s:10:\"full-width\";s:20:\"header_bg_img_repeat\";s:8:\"repeat-x\";s:17:\"box_shadow_header\";b:0;s:8:\"nav_size\";s:0:\"\";s:13:\"nav_uppercase\";b:1;s:14:\"type_nav_color\";s:0:\"\";s:20:\"type_nav_color_hover\";s:0:\"\";s:21:\"header_bg_transparent\";s:0:\"\";s:27:\"header_bg_transparent_shade\";b:0;s:20:\"header_bottom_height\";s:2:\"44\";s:15:\"nav_position_bg\";s:7:\"#f1f1f1\";s:16:\"nav_style_bottom\";s:0:\"\";s:15:\"nav_size_bottom\";s:0:\"\";s:20:\"nav_uppercase_bottom\";b:1;s:18:\"nav_position_color\";s:5:\"light\";s:21:\"type_nav_bottom_color\";s:0:\"\";s:27:\"type_nav_bottom_color_hover\";s:0:\"\";s:15:\"header_button_1\";s:7:\"Sign Up\";s:15:\"header_button_2\";s:4:\"Join\";s:21:\"header_button_2_color\";s:5:\"plain\";s:14:\"site_logo_dark\";s:0:\"\";s:14:\"header_divider\";b:0;s:8:\"footer_1\";b:0;s:8:\"footer_2\";b:0;s:16:\"footer_left_text\";s:258:\"Copyright [ux_current_year] © <strong>African Wildlife Vets | </strong><a href=\"mailto:info@africanwildlifevets.org\"> info@africanwildlifevets.org</a> <br>\nSite proudly designed and hosted by<a href=\"https://xcontent.com/\" target=\'_blank\'> XContent.</a></p>\";s:16:\"category_sidebar\";s:13:\"right-sidebar\";s:18:\"category_row_count\";s:1:\"2\";s:25:\"category_row_count_mobile\";s:1:\"2\";s:13:\"payment_icons\";a:2:{i:0;s:4:\"visa\";i:1;s:10:\"mastercard\";}s:20:\"payment_icons_custom\";s:105:\"https://dev.africanwildlifevets.xcontent.com/wp-content/uploads/2021/11/Payfast-Logo-White-small-icon.png\";s:17:\"cart_auto_refresh\";b:1;s:18:\"cart_estimate_text\";b:0;s:17:\"search_icon_style\";s:4:\"fill\";s:23:\"header_account_register\";b:1;s:18:\"account_icon_style\";s:0:\"\";s:23:\"header_account_username\";b:1;s:9:\"cart_icon\";s:4:\"cart\";s:15:\"dropdown_radius\";s:3:\"3px\";s:14:\"dropdown_style\";s:6:\"simple\";s:19:\"dropdown_text_style\";s:9:\"uppercase\";s:14:\"dropdown_arrow\";b:1;s:13:\"dropdown_text\";s:5:\"light\";s:10:\"blog_badge\";b:0;s:15:\"blog_author_box\";b:0;s:19:\"blog_excerpt_suffix\";s:20:\"- continue reading -\";s:23:\"blog_single_header_meta\";b:0;s:13:\"contact_phone\";s:0:\"\";s:13:\"contact_email\";s:0:\"\";s:13:\"contact_hours\";s:0:\"\";s:22:\"blog_posts_depth_hover\";s:1:\"0\";s:10:\"blog_style\";s:6:\"normal\";s:17:\"blog_show_excerpt\";b:1;s:16:\"blog_posts_depth\";s:1:\"0\";s:24:\"blog_archive_transparent\";b:0;s:19:\"blog_sticky_sidebar\";b:1;s:11:\"blog_layout\";s:13:\"right-sidebar\";s:17:\"footer_right_text\";s:0:\"\";s:25:\"product_offcanvas_sidebar\";b:1;s:19:\"category_grid_style\";s:4:\"grid\";s:25:\"category_row_count_tablet\";s:1:\"3\";s:15:\"product_display\";s:4:\"tabs\";s:18:\"product_tabs_align\";s:4:\"left\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("150", "theme_switched", "", "yes");
INSERT INTO `HhhEP_options` VALUES("151", "flatsome_wup_purchase_code", "purchase_code", "yes");
INSERT INTO `HhhEP_options` VALUES("152", "flatsome_wup_supported_until", "01.01.2050", "yes");
INSERT INTO `HhhEP_options` VALUES("153", "flatsome_wup_buyer", "buyer", "yes");
INSERT INTO `HhhEP_options` VALUES("154", "widget_flatsome_recent_posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("155", "widget_block_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("161", "finished_updating_comment_type", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("166", "recently_activated", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("170", "flatsome_wupdates", "a:2:{s:6:\"errors\";a:1:{i:0;s:79:\"Flatsome was unable to get the latest version. Your purchase code is malformed.\";}s:11:\"show_notice\";b:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("171", "flatsome_update_cache", "a:2:{s:12:\"last_checked\";i:1638343500;s:7:\"version\";s:6:\"3.14.3\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("173", "widget_recent-comments", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("174", "widget_recent-posts", "a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:17:\"Latest Operations\";s:6:\"number\";i:5;s:9:\"show_date\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("178", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"17.5\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("179", "wpseo", "a:45:{s:8:\"tracking\";b:0;s:22:\"license_server_version\";b:0;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:26:\"permalink_settings_changed\";s:29:\"indexables_indexing_completed\";b:1;s:7:\"version\";s:4:\"17.5\";s:16:\"previous_version\";s:4:\"17.4\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:1;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:22:\"show_onboarding_notice\";b:1;s:18:\"first_activated_on\";i:1635171523;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:12:\"/%postname%/\";s:8:\"home_url\";s:44:\"https://dev.africanwildlifevets.xcontent.com\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:13:{s:16:\"block_categories\";s:16:\"block_categories\";s:12:\"product_type\";s:12:\"product_type\";s:18:\"product_visibility\";s:18:\"product_visibility\";s:11:\"product_cat\";s:16:\"product-category\";s:11:\"product_tag\";s:11:\"product-tag\";s:22:\"product_shipping_class\";s:22:\"product_shipping_class\";s:14:\"pa_animal-type\";s:14:\"pa_animal-type\";s:14:\"pa_caps-colour\";s:14:\"pa_caps-colour\";s:9:\"pa_colour\";s:9:\"pa_colour\";s:9:\"pa_gender\";s:9:\"pa_gender\";s:7:\"pa_size\";s:7:\"pa_size\";s:22:\"featured_item_category\";s:22:\"featured_item_category\";s:17:\"featured_item_tag\";s:17:\"featured_item_tag\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:25:\"zapier_integration_active\";b:0;s:19:\"zapier_subscription\";a:0:{}s:14:\"zapier_api_key\";s:0:\"\";s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;}", "yes");
INSERT INTO `HhhEP_options` VALUES("180", "wpseo_titles", "a:154:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Author at %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:63:\"You searched for %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:35:\"Page not found %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:8:\"%%name%%\";s:26:\"social-title-archive-wpseo\";s:8:\"%%date%%\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:53:\"The post %%POSTLINK%% appeared first on %%BLOGLINK%%.\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:20:\"breadcrumbs-404crumb\";s:25:\"Error 404: Page not found\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:12:\"Archives for\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:4:\"Home\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:16:\"You searched for\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:12:\"%%sitename%%\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:9:\"%%title%%\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:9:\"%%title%%\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:12:\"title-blocks\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:15:\"metadesc-blocks\";s:0:\"\";s:14:\"noindex-blocks\";b:0;s:25:\"display-metabox-pt-blocks\";b:1;s:25:\"post_types-blocks-maintax\";i:0;s:23:\"schema-page-type-blocks\";s:7:\"WebPage\";s:26:\"schema-article-type-blocks\";s:4:\"None\";s:19:\"social-title-blocks\";s:9:\"%%title%%\";s:25:\"social-description-blocks\";s:0:\"\";s:23:\"social-image-url-blocks\";s:0:\"\";s:22:\"social-image-id-blocks\";i:0;s:19:\"title-featured_item\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:22:\"metadesc-featured_item\";s:0:\"\";s:21:\"noindex-featured_item\";b:0;s:32:\"display-metabox-pt-featured_item\";b:1;s:32:\"post_types-featured_item-maintax\";i:0;s:30:\"schema-page-type-featured_item\";s:7:\"WebPage\";s:33:\"schema-article-type-featured_item\";s:4:\"None\";s:26:\"social-title-featured_item\";s:9:\"%%title%%\";s:32:\"social-description-featured_item\";s:0:\"\";s:30:\"social-image-url-featured_item\";s:0:\"\";s:29:\"social-image-id-featured_item\";i:0;s:29:\"title-ptarchive-featured_item\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:32:\"metadesc-ptarchive-featured_item\";s:0:\"\";s:31:\"bctitle-ptarchive-featured_item\";s:0:\"\";s:31:\"noindex-ptarchive-featured_item\";b:0;s:36:\"social-title-ptarchive-featured_item\";s:21:\"%%pt_plural%% Archive\";s:42:\"social-description-ptarchive-featured_item\";s:0:\"\";s:40:\"social-image-url-ptarchive-featured_item\";s:0:\"\";s:39:\"social-image-id-ptarchive-featured_item\";i:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:23:\"%%term_title%% Archives\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:1;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:23:\"%%term_title%% Archives\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:32:\"title-tax-featured_item_category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-tax-featured_item_category\";s:0:\"\";s:42:\"display-metabox-tax-featured_item_category\";b:1;s:34:\"noindex-tax-featured_item_category\";b:0;s:39:\"social-title-tax-featured_item_category\";s:23:\"%%term_title%% Archives\";s:45:\"social-description-tax-featured_item_category\";s:0:\"\";s:43:\"social-image-url-tax-featured_item_category\";s:0:\"\";s:42:\"social-image-id-tax-featured_item_category\";i:0;s:40:\"taxonomy-featured_item_category-ptparent\";i:0;s:27:\"title-tax-featured_item_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:30:\"metadesc-tax-featured_item_tag\";s:0:\"\";s:37:\"display-metabox-tax-featured_item_tag\";b:1;s:29:\"noindex-tax-featured_item_tag\";b:0;s:34:\"social-title-tax-featured_item_tag\";s:23:\"%%term_title%% Archives\";s:40:\"social-description-tax-featured_item_tag\";s:0:\"\";s:38:\"social-image-url-tax-featured_item_tag\";s:0:\"\";s:37:\"social-image-id-tax-featured_item_tag\";i:0;s:35:\"taxonomy-featured_item_tag-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;}", "yes");
INSERT INTO `HhhEP_options` VALUES("181", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("202", "wpseo_ryte", "a:2:{s:6:\"status\";i:0;s:10:\"last_fetch\";i:1638221476;}", "yes");
INSERT INTO `HhhEP_options` VALUES("223", "nav_menu_options", "a:1:{s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `HhhEP_options` VALUES("315", "_transient_health-check-site-status-result", "{\"good\":15,\"recommended\":4,\"critical\":1}", "yes");
INSERT INTO `HhhEP_options` VALUES("500", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-5.8.2.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-5.8.2-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-5.8.2-new-bundled.zip\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"5.8.2\";s:7:\"version\";s:5:\"5.8.2\";s:11:\"php_version\";s:6:\"5.6.20\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"5.6\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1638343499;s:15:\"version_checked\";s:5:\"5.8.2\";s:12:\"translations\";a:0:{}}", "no");
INSERT INTO `HhhEP_options` VALUES("559", "sbi_statuses", "a:5:{s:8:\"database\";a:1:{s:14:\"hashtag_column\";b:1;}s:13:\"first_install\";i:1636716879;s:4:\"gdpr\";a:4:{s:19:\"from_update_success\";b:1;s:12:\"image_editor\";b:1;s:10:\"upload_dir\";b:1;s:6:\"tables\";b:1;}s:12:\"data_manager\";a:2:{s:9:\"last_used\";i:1636630479;s:14:\"num_db_updates\";i:31;}s:12:\"feed_locator\";a:2:{s:10:\"last_check\";i:1638343365;s:11:\"initialized\";i:1636721512;}}", "yes");
INSERT INTO `HhhEP_options` VALUES("560", "sbi_usage_tracking", "a:2:{s:7:\"enabled\";b:0;s:9:\"last_send\";i:0;}", "yes");
INSERT INTO `HhhEP_options` VALUES("561", "widget_instagram-feed-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("562", "sbi_usage_tracking_config", "a:6:{s:3:\"day\";i:5;s:4:\"hour\";i:17;s:6:\"minute\";i:31;s:6:\"second\";i:33;s:6:\"offset\";i:495093;s:8:\"initsend\";i:1637343093;}", "yes");
INSERT INTO `HhhEP_options` VALUES("565", "sbi_rating_notice", "pending", "no");
INSERT INTO `HhhEP_options` VALUES("566", "sbi_db_version", "1.91", "yes");
INSERT INTO `HhhEP_options` VALUES("567", "sb_instagram_errors", "a:9:{s:10:\"connection\";a:0:{}s:7:\"hashtag\";a:0:{}s:8:\"resizing\";a:0:{}s:15:\"database_create\";a:0:{}s:10:\"upload_dir\";a:0:{}s:8:\"accounts\";a:0:{}s:9:\"error_log\";a:0:{}s:10:\"action_log\";a:4:{i:0;s:41:\"11-12 11:34:39 - Retesting GDPR features.\";i:1;s:67:\"11-12 12:51:19 - Connection or updating account africanwildlifevets\";i:2;s:53:\"11-12 12:51:59 - Saved settings on the configure tab.\";i:3;s:53:\"11-12 12:52:03 - Saved settings on the configure tab.\";}s:7:\"revoked\";a:0:{}}", "no");
INSERT INTO `HhhEP_options` VALUES("568", "sb_instagram_settings", "a:57:{s:15:\"sb_instagram_at\";s:0:\"\";s:20:\"sb_instagram_user_id\";a:1:{i:0;s:17:\"17841405805851031\";}s:30:\"sb_instagram_preserve_settings\";s:0:\"\";s:23:\"sb_instagram_cache_time\";s:1:\"1\";s:28:\"sb_instagram_cache_time_unit\";s:5:\"hours\";s:16:\"sbi_caching_type\";s:4:\"page\";s:23:\"sbi_cache_cron_interval\";s:7:\"12hours\";s:19:\"sbi_cache_cron_time\";s:1:\"1\";s:20:\"sbi_cache_cron_am_pm\";s:2:\"am\";s:18:\"sb_instagram_width\";i:100;s:23:\"sb_instagram_width_unit\";s:1:\"%\";s:28:\"sb_instagram_feed_width_resp\";s:0:\"\";s:19:\"sb_instagram_height\";i:550;s:16:\"sb_instagram_num\";i:10;s:24:\"sb_instagram_height_unit\";s:2:\"px\";s:17:\"sb_instagram_cols\";s:1:\"5\";s:27:\"sb_instagram_disable_mobile\";s:0:\"\";s:26:\"sb_instagram_image_padding\";i:5;s:31:\"sb_instagram_image_padding_unit\";s:2:\"px\";s:17:\"sb_instagram_sort\";s:4:\"none\";s:23:\"sb_instagram_background\";s:0:\"\";s:21:\"sb_instagram_show_btn\";s:2:\"on\";s:27:\"sb_instagram_btn_background\";s:0:\"\";s:27:\"sb_instagram_btn_text_color\";s:0:\"\";s:21:\"sb_instagram_btn_text\";s:12:\"Load More...\";s:22:\"sb_instagram_image_res\";s:4:\"auto\";s:24:\"sb_instagram_show_header\";s:2:\"on\";s:24:\"sb_instagram_header_size\";s:5:\"small\";s:25:\"sb_instagram_header_color\";s:0:\"\";s:23:\"sb_instagram_custom_bio\";s:0:\"\";s:26:\"sb_instagram_custom_avatar\";s:0:\"\";s:28:\"sb_instagram_show_follow_btn\";s:2:\"on\";s:33:\"sb_instagram_folow_btn_background\";s:0:\"\";s:34:\"sb_instagram_follow_btn_text_color\";s:0:\"\";s:28:\"sb_instagram_follow_btn_text\";s:19:\"Follow on Instagram\";s:23:\"sb_instagram_custom_css\";s:0:\"\";s:22:\"sb_instagram_custom_js\";s:0:\"\";s:17:\"sb_instagram_cron\";s:2:\"no\";s:19:\"sb_instagram_backup\";s:2:\"on\";s:15:\"sb_ajax_initial\";s:0:\"\";s:24:\"enqueue_css_in_shortcode\";s:0:\"\";s:23:\"sb_instagram_ajax_theme\";s:0:\"\";s:4:\"gdpr\";s:4:\"auto\";s:27:\"sb_instagram_disable_resize\";s:0:\"\";s:24:\"sb_instagram_favor_local\";s:2:\"on\";s:19:\"sb_instagram_minnum\";s:1:\"0\";s:24:\"disable_js_image_loading\";s:0:\"\";s:18:\"enqueue_js_in_head\";s:0:\"\";s:30:\"sb_instagram_disable_mob_swipe\";b:0;s:15:\"custom_template\";s:0:\"\";s:20:\"disable_admin_notice\";s:0:\"\";s:19:\"enable_email_report\";s:2:\"on\";s:18:\"email_notification\";s:6:\"monday\";s:28:\"email_notification_addresses\";s:42:\"admin@dev.africanwildlifevets.xcontent.com\";s:28:\"sb_instagram_disable_awesome\";b:0;s:18:\"connected_accounts\";a:1:{i:17841405805851031;a:13:{s:12:\"access_token\";s:608:\"H1SldCRMFQ37eo5KF+J2k2ZaZXVBYzhHWXdzRTFlaDVnUGwxSVAxMjlHa1d0WEVQTWNjMVJUdENoYWFSdkUzUTlPQUxTbmM3LzBnaDlxU0xaWmhTdHUvZTcxZlRkcmtSN2lLYXRXcmp3dEIvdlBKVVp6NElVN01zYU1MQ1FOaG9xUDVmWmUzdk1FS1dENXBCdGV6cWZjK0R0MVd4WmIvZTFGMzNuOXBIUndQcHRSenIxRFBzamJRaTgxc3FiOHpUTGtjY1BnRGhGdGJWNDBTR1NDS2pwZko3NWt1UG9QUlIwN21UaDM0TGZVZU9iL0JuWlpzaWRqNkJ3N2k3S0E0TEh2SWNNSjUxejF6clVybUI2NUdoR1E5ZUlGT080WlEwSnhnV3Nib0gxSVFiNE9CT3ZNMkxsQkNYNjFIYTFOT1hIeWFCSUJOVkYwa0lXMjV0RjMxMlE5L1VLOU5OdFA0STUzNFFjdmM0OE12aHRia09IY04zS2tLa215ZlhCWDA0RlpkalVPaG1ybnRORFdDdGNMZWJpYVA2K1Z2U0ZXRi8xMDlGQ3BSWko0OW8vUDNpa3gvMFZJN2lCalJjRkx6UzlqMzdEQT09\";s:7:\"user_id\";s:17:\"17841405805851031\";s:8:\"username\";s:19:\"africanwildlifevets\";s:8:\"is_valid\";b:1;s:12:\"last_checked\";i:1636721475;s:4:\"type\";s:8:\"business\";s:12:\"account_type\";s:8:\"business\";s:15:\"profile_picture\";s:330:\"https://scontent-ort2-1.xx.fbcdn.net/v/t51.2885-15/29716606_207421030025964_7322697018072104960_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=86c713&_nc_ohc=kL2bfRlb9AcAX_w-nnG&_nc_oc=AQl14c2d9bigXPsnDHQwt2xE_NRDNl6NnQd3jjRYamvryq_1sJduKZub1gLFL9vT3lI&_nc_ht=scontent-ort2-1.xx&edm=AL-3X8kEAAAA&oh=7332c7f00b651ff66a44913817e9cdd7&oe=619270DA\";s:10:\"use_tagged\";s:1:\"1\";s:4:\"name\";s:39:\"{\"jsonencoded\":\"African Wildlife Vets\"}\";s:12:\"local_avatar\";b:1;s:17:\"page_access_token\";s:488:\"WhdAud/CkKmfpZ4hKmsDjy9lV1F2ZUwvbTFaRmhRWExzSThjVUV6YmNJc0N6aHVxenhaMVFLWkl1MHlNREJ2dldFTHAwMi9JVEJpQ2s2YXAyTVkyWFpyZSt6Qnd1c0tvNG1mZUtXZGZjOG5ybXN6M01lZGZycjFGNERCMVVHdmtSeXVIK3V1dGhKaXZwU1M4cy9XOWNDclp4S3dTVEozNzluN0h0SkpuazZPWXNLTFd4ZlRNNTlBbGRxUm9IOW1OTjFTNFFoc281V0pxUEhhTUVoVmlKYVo2TStXcXhWQjVmdDc5VkFWQkRacGFOWStMeFkyK0FBbGdVMzRoMU5TdjRvYVVLY3JMUzF0QVlYenFEUzgwTWNSL2RoWnBtZ0pYK2IxOXBSZ3lncXZFNDcva2J3UWEzczBrd1o1ZmJsNk80Q29zeElEVEJoK3pRMnlzMGY4QWRqdGIxbEYyeElTOEJBRGJkbVk2OTlSYw==\";s:7:\"wp_user\";i:2;}}s:21:\"sb_instagram_show_bio\";s:2:\"on\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("569", "sbi_single_cache", "/H51+yn9O32AgUXTascFzTlEMmVEeW1Dbjl2L2tJRjdYaHZoUktMR2FDcW9qMXU4YWlBVzFlcWlESklHOE1ZY2VzYjNQT0paZWpEeHpSVElWVyt5VzJwQ1YzUWc5VWRSTWx3T1B1Q0w=", "no");
INSERT INTO `HhhEP_options` VALUES("571", "sbi_notifications", "a:4:{s:6:\"update\";i:1638343378;s:4:\"feed\";a:1:{i:0;a:9:{s:5:\"title\";s:50:\"Happy Smashgiving! Save up to 65% on {plugin} Pro!\";s:7:\"content\";s:181:\"For Black Friday and Cyber Monday, we\'re offering huge savings on the Pro version for all of our users. Unlock all the Pro features to take your social media game to the next level!\";s:5:\"image\";s:7:\"balloon\";s:4:\"type\";a:1:{i:0;s:4:\"free\";}s:7:\"plugins\";a:4:{i:0;s:9:\"instagram\";i:1;s:8:\"facebook\";i:2;s:7:\"twitter\";i:3;s:7:\"youtube\";}s:2:\"id\";i:6;s:4:\"btns\";a:2:{s:7:\"primary\";a:3:{s:3:\"url\";s:109:\"https://smashballoon.com/black-friday/?utm_campaign={campaign}&utm_source=dashboard-notices&utm_medium=bf2021\";s:4:\"text\";s:16:\"Claim this deal!\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}}s:9:\"secondary\";a:2:{s:3:\"url\";a:1:{s:7:\"dismiss\";s:6:\"bf2021\";}s:4:\"text\";s:18:\"I\'m not interested\";}}s:5:\"start\";s:19:\"2021-11-22 00:00:00\";s:3:\"end\";s:19:\"2021-12-03 23:59:59\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `HhhEP_options` VALUES("572", "sbi_newuser_notifications", "a:4:{s:6:\"update\";i:1636716880;s:4:\"feed\";a:2:{s:6:\"review\";a:6:{s:5:\"title\";s:22:\"Could you help us out?\";s:7:\"content\";s:273:\"It\'s great to see that you\'ve been using the <strong><span>{plugin}</span></strong> plugin for a while now. Hopefully you\'re happy with it!&nbsp; If so, would you consider leaving a positive review? It really helps to support the plugin and helps others to discover it too!\";s:2:\"id\";s:6:\"review\";s:5:\"image\";s:12:\"sbi-icon.png\";s:4:\"btns\";a:4:{s:7:\"primary\";a:4:{s:3:\"url\";s:12:\"{review-url}\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}s:5:\"class\";s:31:\"sbi_notice_dismiss sbi_main_cta\";s:4:\"text\";s:18:\"Sure, I\'d love to!\";}s:7:\"dismiss\";a:3:{s:3:\"url\";a:1:{s:28:\"sbi_ignore_rating_notice_nag\";s:1:\"1\";}s:5:\"class\";s:18:\"sbi_notice_dismiss\";s:4:\"text\";s:9:\"No thanks\";}s:8:\"complete\";a:3:{s:3:\"url\";a:1:{s:28:\"sbi_ignore_rating_notice_nag\";s:1:\"1\";}s:5:\"class\";s:18:\"sbi_notice_dismiss\";s:4:\"text\";s:27:\"I\'ve already given a review\";}s:5:\"later\";a:3:{s:3:\"url\";a:1:{s:28:\"sbi_ignore_rating_notice_nag\";s:5:\"later\";}s:5:\"class\";s:18:\"sbi_notice_dismiss\";s:4:\"text\";s:12:\"Ask Me Later\";}}s:4:\"wait\";s:2:\"14\";}s:8:\"discount\";a:8:{s:5:\"title\";s:28:\"Attention {platform} Lovers!\";s:7:\"content\";s:221:\"<strong><span>Exclusive offer!</span></strong> We don\'t run promotions very often, but for a limited time we\'re offering <strong><span>{amount} off</span></strong> our Pro version to all users of our free {plugin} plugin.\";s:2:\"id\";s:8:\"discount\";s:6:\"amount\";s:3:\"60%\";s:5:\"image\";s:12:\"sbi-icon.png\";s:13:\"image_overlay\";s:7:\"60% off\";s:4:\"btns\";a:2:{s:7:\"primary\";a:4:{s:3:\"url\";s:127:\"https://smashballoon.com/{slug}/?utm_campaign={campaign}&utm_source=notices&utm_medium=newuser&discount={lowerplatform}thankyou\";s:5:\"class\";s:32:\"sbi_notice_dismiss sbi_offer_btn\";s:4:\"text\";s:14:\"Get this offer\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}}s:7:\"dismiss\";a:3:{s:3:\"url\";a:1:{s:31:\"sbi_ignore_new_user_sale_notice\";s:6:\"always\";}s:5:\"class\";s:18:\"sbi_notice_dismiss\";s:4:\"text\";s:18:\"I\'m not interested\";}}s:4:\"wait\";s:2:\"30\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `HhhEP_options` VALUES("573", "cff_usage_tracking", "a:2:{s:7:\"enabled\";b:0;s:9:\"last_send\";i:0;}", "no");
INSERT INTO `HhhEP_options` VALUES("574", "cff_style_settings", "a:21:{s:19:\"cff_show_links_type\";b:1;s:19:\"cff_show_event_type\";b:1;s:19:\"cff_show_video_type\";b:1;s:20:\"cff_show_photos_type\";b:1;s:20:\"cff_show_status_type\";b:1;s:20:\"cff_show_albums_type\";b:1;s:15:\"cff_show_author\";b:1;s:13:\"cff_show_text\";b:1;s:13:\"cff_show_desc\";b:1;s:21:\"cff_show_shared_links\";b:1;s:13:\"cff_show_date\";b:1;s:14:\"cff_show_media\";b:1;s:19:\"cff_show_media_link\";b:1;s:20:\"cff_show_event_title\";b:1;s:22:\"cff_show_event_details\";b:1;s:13:\"cff_show_meta\";b:1;s:13:\"cff_show_link\";b:1;s:17:\"cff_show_like_box\";b:1;s:22:\"cff_show_facebook_link\";b:1;s:23:\"cff_show_facebook_share\";b:1;s:20:\"cff_event_title_link\";b:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("575", "cff_show_access_token", "1", "yes");
INSERT INTO `HhhEP_options` VALUES("576", "cff_usage_tracking_config", "a:6:{s:3:\"day\";i:4;s:4:\"hour\";i:9;s:6:\"minute\";i:44;s:6:\"second\";i:58;s:6:\"offset\";i:380698;s:8:\"initsend\";i:1637228698;}", "yes");
INSERT INTO `HhhEP_options` VALUES("579", "cff_rating_notice", "pending", "no");
INSERT INTO `HhhEP_options` VALUES("580", "cff_statuses", "a:3:{s:13:\"first_install\";i:1636716888;s:17:\"legacy_onboarding\";a:2:{s:6:\"active\";b:0;s:4:\"type\";s:6:\"single\";}s:24:\"support_legacy_shortcode\";b:0;}", "no");
INSERT INTO `HhhEP_options` VALUES("581", "cff_db_version", "2.1", "yes");
INSERT INTO `HhhEP_options` VALUES("583", "cff_notifications", "a:4:{s:6:\"update\";i:1638343379;s:4:\"feed\";a:1:{i:0;a:9:{s:5:\"title\";s:50:\"Happy Smashgiving! Save up to 65% on {plugin} Pro!\";s:7:\"content\";s:181:\"For Black Friday and Cyber Monday, we\'re offering huge savings on the Pro version for all of our users. Unlock all the Pro features to take your social media game to the next level!\";s:5:\"image\";s:7:\"balloon\";s:4:\"type\";a:1:{i:0;s:4:\"free\";}s:7:\"plugins\";a:4:{i:0;s:9:\"instagram\";i:1;s:8:\"facebook\";i:2;s:7:\"twitter\";i:3;s:7:\"youtube\";}s:2:\"id\";i:6;s:4:\"btns\";a:2:{s:7:\"primary\";a:3:{s:3:\"url\";s:109:\"https://smashballoon.com/black-friday/?utm_campaign={campaign}&utm_source=dashboard-notices&utm_medium=bf2021\";s:4:\"text\";s:16:\"Claim this deal!\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}}s:9:\"secondary\";a:2:{s:3:\"url\";a:1:{s:7:\"dismiss\";s:6:\"bf2021\";}s:4:\"text\";s:18:\"I\'m not interested\";}}s:5:\"start\";s:19:\"2021-11-22 00:00:00\";s:3:\"end\";s:19:\"2021-12-03 23:59:59\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `HhhEP_options` VALUES("584", "cff_newuser_notifications", "a:4:{s:6:\"update\";i:1636716900;s:4:\"feed\";a:2:{s:6:\"review\";a:6:{s:5:\"title\";s:22:\"Could you help us out?\";s:7:\"content\";s:273:\"It\'s great to see that you\'ve been using the <strong><span>{plugin}</span></strong> plugin for a while now. Hopefully you\'re happy with it!&nbsp; If so, would you consider leaving a positive review? It really helps to support the plugin and helps others to discover it too!\";s:2:\"id\";s:6:\"review\";s:5:\"image\";s:12:\"cff-icon.png\";s:4:\"btns\";a:4:{s:7:\"primary\";a:4:{s:3:\"url\";s:12:\"{review-url}\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}s:5:\"class\";s:31:\"cff_notice_dismiss cff_main_cta\";s:4:\"text\";s:18:\"Sure, I\'d love to!\";}s:7:\"dismiss\";a:3:{s:3:\"url\";a:1:{s:28:\"cff_ignore_rating_notice_nag\";s:1:\"1\";}s:5:\"class\";s:18:\"cff_notice_dismiss\";s:4:\"text\";s:9:\"No thanks\";}s:8:\"complete\";a:3:{s:3:\"url\";a:1:{s:28:\"cff_ignore_rating_notice_nag\";s:1:\"1\";}s:5:\"class\";s:18:\"cff_notice_dismiss\";s:4:\"text\";s:27:\"I\'ve already given a review\";}s:5:\"later\";a:3:{s:3:\"url\";a:1:{s:28:\"cff_ignore_rating_notice_nag\";s:5:\"later\";}s:5:\"class\";s:18:\"cff_notice_dismiss\";s:4:\"text\";s:12:\"Ask Me Later\";}}s:4:\"wait\";s:2:\"14\";}s:8:\"discount\";a:8:{s:5:\"title\";s:28:\"Attention {platform} Lovers!\";s:7:\"content\";s:221:\"<strong><span>Exclusive offer!</span></strong> We don\'t run promotions very often, but for a limited time we\'re offering <strong><span>{amount} off</span></strong> our Pro version to all users of our free {plugin} plugin.\";s:2:\"id\";s:8:\"discount\";s:6:\"amount\";s:3:\"60%\";s:5:\"image\";s:12:\"cff-icon.png\";s:13:\"image_overlay\";s:7:\"60% off\";s:4:\"btns\";a:2:{s:7:\"primary\";a:4:{s:3:\"url\";s:127:\"https://smashballoon.com/{slug}/?utm_campaign={campaign}&utm_source=notices&utm_medium=newuser&discount={lowerplatform}thankyou\";s:5:\"class\";s:32:\"cff_notice_dismiss cff_offer_btn\";s:4:\"text\";s:14:\"Get this offer\";s:4:\"attr\";a:1:{i:0;s:11:\"targetblank\";}}s:7:\"dismiss\";a:3:{s:3:\"url\";a:1:{s:31:\"cff_ignore_new_user_sale_notice\";s:6:\"always\";}s:5:\"class\";s:18:\"cff_notice_dismiss\";s:4:\"text\";s:18:\"I\'m not interested\";}}s:4:\"wait\";s:2:\"30\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `HhhEP_options` VALUES("585", "cff_legacy_feed_settings", "{\"accesstoken\":\"\",\"id\":false,\"pagetype\":false,\"num\":false,\"limit\":false,\"others\":\"\",\"showpostsby\":false,\"cachetime\":false,\"cacheunit\":false,\"locale\":false,\"ajax\":false,\"offset\":\"\",\"account\":\"\",\"cff_enqueue_with_shortcode\":false,\"width\":\"\",\"widthresp\":\"\",\"height\":\"\",\"padding\":\"\",\"bgcolor\":\"\",\"showauthor\":\"\",\"showauthornew\":true,\"class\":\"\",\"layout\":\"\",\"include\":[\"author\",\"text\",\"desc\",\"sharedlinks\",\"date\",\"media\",\"medialink\",\"eventtitle\",\"eventdetails\",\"social\",\"link\",\"likebox\",\"\"],\"exclude\":[\"\"],\"gdpr\":\"auto\",\"cols\":\"\",\"colsmobile\":\"\",\"colsjs\":true,\"nummobile\":\"\",\"poststyle\":\"\",\"postbgcolor\":\"\",\"postcorners\":\"\",\"boxshadow\":\"\",\"textformat\":\"\",\"textsize\":\"\",\"textweight\":\"\",\"textcolor\":\"\",\"textlinkcolor\":\"\",\"textlink\":\"\",\"posttags\":\"\",\"linkhashtags\":\"\",\"descsize\":\"\",\"descweight\":\"\",\"desccolor\":\"\",\"linktitleformat\":\"\",\"linktitlesize\":\"\",\"linkdescsize\":\"\",\"linkurlsize\":\"\",\"linkdesccolor\":\"\",\"linktitlecolor\":\"\",\"linkurlcolor\":\"\",\"linkbgcolor\":\"\",\"linkbordercolor\":\"\",\"disablelinkbox\":\"\",\"authorsize\":\"\",\"authorcolor\":\"\",\"eventtitleformat\":\"\",\"eventtitlesize\":\"\",\"eventtitleweight\":\"\",\"eventtitlecolor\":\"\",\"eventtitlelink\":true,\"eventdatesize\":\"\",\"eventdateweight\":\"\",\"eventdatecolor\":\"\",\"eventdatepos\":\"\",\"eventdateformat\":\"\",\"eventdatecustom\":\"\",\"eventdetailssize\":\"\",\"eventdetailsweight\":\"\",\"eventdetailscolor\":\"\",\"eventlinkcolor\":\"\",\"datepos\":\"\",\"datesize\":\"\",\"dateweight\":\"\",\"datecolor\":\"\",\"dateformat\":\"\",\"datecustom\":\"\",\"beforedate\":\"\",\"afterdate\":\"\",\"timezone\":\"America\\/Chicago\",\"linksize\":\"\",\"linkweight\":\"\",\"linkcolor\":\"\",\"viewlinktext\":\"\",\"linktotimeline\":\"\",\"iconstyle\":\"\",\"socialtextcolor\":\"\",\"socialbgcolor\":\"\",\"textlength\":\"400\",\"desclength\":\"200\",\"likeboxpos\":\"\",\"likeboxoutside\":\"\",\"likeboxcolor\":\"\",\"likeboxtextcolor\":\"\",\"likeboxwidth\":\"\",\"likeboxheight\":\"\",\"likeboxfaces\":\"\",\"likeboxborder\":\"\",\"likeboxcover\":\"\",\"likeboxsmallheader\":\"\",\"likeboxhidebtn\":\"\",\"credit\":\"\",\"nofollow\":\"true\",\"disablestyles\":\"\",\"textissue\":\"\",\"restrictedpage\":\"\",\"salesposts\":\"false\",\"storytags\":\"false\",\"showheader\":\"\",\"headeroutside\":\"\",\"headertype\":\"\",\"headercover\":\"\",\"headeravatar\":\"\",\"headername\":\"\",\"headerbio\":\"\",\"headercoverheight\":\"\",\"headertext\":\"\",\"headerbg\":\"\",\"headerpadding\":\"\",\"headertextsize\":\"\",\"headertextweight\":\"\",\"headertextcolor\":\"\",\"headericon\":\"\",\"headericoncolor\":\"\",\"headericonsize\":\"\",\"headerinc\":\"\",\"headerexclude\":\"\",\"videoheight\":\"\",\"videoaction\":\"\",\"sepcolor\":\"\",\"sepsize\":\"\",\"seemoretext\":\"\",\"seelesstext\":\"\",\"photostext\":\"\",\"phototext\":\"\",\"videotext\":\"\",\"learnmoretext\":\"\",\"shopnowtext\":\"\",\"messagepage\":\"\",\"facebooklinktext\":\"\",\"sharelinktext\":\"\",\"showfacebooklink\":\"on\",\"showsharelink\":\"on\",\"secondtext\":\"second\",\"secondstext\":\"seconds\",\"minutetext\":\"minute\",\"minutestext\":\"minutes\",\"hourtext\":\"hour\",\"hourstext\":\"hours\",\"daytext\":\"day\",\"daystext\":\"days\",\"weektext\":\"week\",\"weekstext\":\"weeks\",\"monthtext\":\"month\",\"monthstext\":\"months\",\"yeartext\":\"year\",\"yearstext\":\"years\",\"agotext\":\"ago\",\"feedlayout\":\"list\",\"feedtype\":\"timeline\"}", "yes");
INSERT INTO `HhhEP_options` VALUES("586", "cff_theme_styles", "a:3:{s:4:\"file\";s:81:\"https://dev.africanwildlifevets.xcontent.com/wp-content/themes/flatsome/style.css\";s:12:\"last_checked\";i:1636717058;s:6:\"styles\";N;}", "no");
INSERT INTO `HhhEP_options` VALUES("591", "recovery_mode_email_last_sent", "1636718030", "yes");
INSERT INTO `HhhEP_options` VALUES("622", "!sbi_africanwildlifevets#20", "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", "no");
INSERT INTO `HhhEP_options` VALUES("625", "!sbi_header_africanwildlifevets#20", "l9iiSZDXU9ovixKqRqFfAFJsQ0ROM00vQUhCL1Q4V0R4cXFnaFY3b3JSZ1BmbUQwTDM1eThoTmUybHpxUkNFdUpLYVFFZFV6VXI5ckRWRnVmaFR6cGJNSmVZL0pvWE9nSm5kL0xMWkVQZE1nSXp2elIxZkxieGNvR3lkWFFEUUxXdGZLcTdHUUlzbTEwZXY0ZFp4TVIwc284SzR2bHBUZXlxVTFtY0FlNzlXUlhpMlJ0TjFVbkpFc1F6Ny9WYVlGTUxtbW1ZZWgvOEh1QWhBUTNCdVllTExHSnNCd0drR2dWdlF5Zm1BT1hVOFY0WkRSZU5hR25Ec01sZWdjTm1RdENOSUc3WldsK0dxa2RUOWV1NVBQa1lRYXA5SFRkZFJ0Q3N0UmM4Q1VhK2xqd0JMTnllMTByRVhRZTIwMWpUeHo1cVJ4SUJJL3h3YlFoM2VrNk9kMERhSll6ZlJ6ZU9zVWU4cEQ2MUdQZmp6OUJRbzU5d2lKSmI0WFZhUWVoUk9zK1owQzJ4NUpVWlVGMkJzcGxrUVJMZGoyRmkxRzJQLzNwV2tndTBuZ0xBV0xIenVQdi82dUVOc2RLTUZGYnFzdlF5Wnd0b0ZIdEVyM1Rka1ZtSTZVTDlGNEt6MWVNa2p4Y3JBVDVXUmlrUHl6KzQ5UXBNcWJtN041MlJESVZFMGY3RU1LcGc2S1JYRTNoWVVjTENYTTNXWDVrRTRacjFDZ3JWaEJmS1JXcjRNQ0VRaFIvS2RXS1hxMGZyNVBpWDZWMEIvSDZHdmZRYjRraHpJc3lPRFJTcWRWYm5maSt2QTljdmhLYUp1MzFvNHp6YXpETWZHazhBUXhRREVwUkJmQXc1bnpBN3k4VEc2Vk9YdkYyeUgxU0J4SWxlSjVBVjFQMkY5OHFac0ZMMGZpa2NPVFQrcjk4MlRTNmJ2VWdiaExJVDZNcUl4VjJQVE5pTVAzcmt3ek82cys2SEFwYjVBRnZ2OU93aVpyWHdPa0ZKM3dOTG5LZURkVnlpRy9vS0lNVFZmUlZMRjArcHJPQVBUbkZOMzBsbGdVa0lTOUwxN2NCb3F5V2ZvOVNpWHFOZU52Z3A2eElEcUR1T25VcnJHTGZURS92djg3T3JtakZqOG11c1FteFdLSHJxcjRwMGpDRVRGSXpacVljMGMxdGJvbFl1dDRIMlVlUXNFQm5pUGkra1R2MEQ5aEV1bisvVjZQbWNrN21zeUd4UnBPc2RxZ3RRajRuNnc4MnNEdHI1Q3NsbFJXS1oxRXZWcTMwRUJ4blJVa04yOHJ2RDE4bzlDRnBldGY1cEVTcnBXUHRTVlpiTFBhSHE5NUxoNExlVGtkSlZHYmZiZVlmaDM0aEUwT0FkUEVDMThkbFBFeWVla011Ry9FL0NUdFZTUGFJZk9IMXA0RUJoMEM3eStIcHlNdzhMWG9ranJoTkVCWHRCV2J1RVVheUVnUGNmSFE0MlU0ZUxmZmlkN24wRlIyZUxlcEFwYUlKaU9STnptbnpILzZOWFdoaTRhUzNiWTMxVTU4UlFXenlOR2R2czBVeEc2L2ppWnN5OHh6dEdoNVZUTWpwRmlSeGlLZzQ0SjRkUnlTUnZpZjJtTGV6aEhYeFpnWHFzV3NnVHFqbEh1c0dNMEhjY1IzTzRGcUZwaVhlazJpZ1NzPQ==", "no");
INSERT INTO `HhhEP_options` VALUES("634", "_transient_timeout_!cff_backup_cff_10820001986402082000198640237meen000", "1668257688", "no");
INSERT INTO `HhhEP_options` VALUES("635", "_transient_!cff_backup_cff_10820001986402082000198640237meen000", "{\"api_url\":\"https://graph.facebook.com/v4.0/108200019864023/posts?fields=id,updated_time,from{picture,id,name,link},message,message_tags,story,story_tags,picture,full_picture,status_type,created_time,backdated_time,attachments{title,description,media_type,unshimmed_url,target{id},multi_share_end_card,media{source,image},subattachments},shares,call_to_action,privacy&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&limit=7&locale=en_US&return_ssl_resources=true\", \"shortcode_options\":\"&quot;&quot;\", \"data\":[{\"id\":\"108200019864023_872031983480819\",\"updated_time\":\"2021-11-10T11:24:41+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":652,\"length\":4},{\"id\":\"305119079613711\",\"name\":\"#hyena\",\"offset\":657,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":664,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":672,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":682,\"length\":13}],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s130x130\\/254292269_872031950147489_6334278524307731466_n.jpg?_nc_cat=111&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=-MpxTkUZg4UAX955oKn&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=4411b77ba4e61b814505e15505679e19&oe=61939132\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p480x480\\/254292269_872031950147489_6334278524307731466_n.jpg?_nc_cat=111&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=-MpxTkUZg4UAX955oKn&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=b20a321890d63d29b4e81fd58dfdfed2&oe=61939882\",\"status_type\":\"added_photos\",\"created_time\":\"2021-11-10T11:24:41+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/872031956814155\\/?type=3\",\"target\":{\"id\":\"872031956814155\"},\"media\":{\"image\":{\"height\":480,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p480x480\\/254292269_872031950147489_6334278524307731466_n.jpg?_nc_cat=111&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=-MpxTkUZg4UAX955oKn&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=b20a321890d63d29b4e81fd58dfdfed2&oe=61939882\",\"width\":720}}}]},\"shares\":{\"count\":4},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_868751733808844\",\"updated_time\":\"2021-11-05T04:40:06+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"\\ud83d\\udce2 EXCITING NEWS \\ud83d\\udce2 \\nThe black rhino orphans have entered their next phase in the rehabilitation process. They were recently relocated into a large enclosure where they will learn to browse and adapt to an environment that they would naturally exist in. \\n\\nAfrican Wildlife Vets has supported and will continue to support an incredible Ezemvelo KZN Wildlife Game Capture team with the care of these orphans.\\n\\nA huge thank you to Rex the Rhino for your support in building the new rhino camp.  \\n\\n#AWV #Rhino #Nature #Conservation #Wildlife\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":492,\"length\":4},{\"id\":\"150880875075377\",\"name\":\"#rhino\",\"offset\":497,\"length\":6},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":504,\"length\":7},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":512,\"length\":13},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":526,\"length\":9}],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/s130x130\\/248426424_170091358669775_5812706273115663032_n.jpg?_nc_cat=107&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=X9f_VA1-SygAX_MGDAz&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=3293996a4024b04d07bf599645f4614d&oe=619437BA\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/248426424_170091358669775_5812706273115663032_n.jpg?_nc_cat=107&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=X9f_VA1-SygAX_MGDAz&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=6fcf1b43d8ca79789ef360431bb38fb5&oe=61935680\",\"status_type\":\"added_video\",\"created_time\":\"2021-11-04T11:01:09+0000\",\"attachments\":{\"data\":[{\"media_type\":\"video\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/videos\\/170090862003158\\/\",\"target\":{\"id\":\"170090862003158\"},\"media\":{\"source\":\"https:\\/\\/video-ort2-1.xx.fbcdn.net\\/v\\/t42.1790-2\\/251093931_115384367605587_5129122713059167620_n.mp4?_nc_cat=102&ccb=1-5&_nc_sid=985c63&efg=eyJybHIiOjQxOSwicmxhIjo1MTIsInZlbmNvZGVfdGFnIjoic3ZlX3NkIn0\\u00253D&_nc_ohc=TFBBfZ6u3H4AX-jYvIZ&rl=419&vabr=233&_nc_ht=video-ort2-1.xx&edm=AKIiGfEEAAAA&oh=7555c7c2acf5f6970b91cfe87de8daff&oe=618FE46C\",\"image\":{\"height\":405,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/s720x720\\/248426424_170091358669775_5812706273115663032_n.jpg?_nc_cat=107&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=X9f_VA1-SygAX_MGDAz&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=d0900921a1e5110f2978c22f8491ab26&oe=6193F1DC\",\"width\":720}}}]},\"shares\":{\"count\":2},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_868289520521732\",\"updated_time\":\"2021-11-03T13:54:24+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s130x130\\/251233876_868289490521735_6763957930071885993_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=3fBwHjWapEgAX9M1g5I&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=47d965ea7d7bc27e73582e6bcc8eaed8&oe=6193AD73\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s720x720\\/251233876_868289490521735_6763957930071885993_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=3fBwHjWapEgAX9M1g5I&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=9b47d05283393ba833cfa6e499662266&oe=61930011\",\"status_type\":\"added_photos\",\"created_time\":\"2021-11-03T13:54:24+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy don\\u2019t birds have teeth?\\n\\nEvolutionary adoption has resulted in birds losing their teeth and developing beaks. Some researchers studied mutations of the genes that control tooth production to try to better understand why birds stopped developing teeth over time. Tooth formation in vertebrates involves six genes that are crucial for the formation of enamel (the hard tissue that coats teeth) and dentin (the calcified stuff underneath it). The researchers looked at 48 bird species, representing nearly all orders of living birds. They found that all of the bird species had the same mutations in dentin- and enamel-related genes. Other researchers suggested that the reason for evolutionary tooth-loss was to reduce the incubation period. This was based on the idea that tooth development could take up to 60\\u0025 of incubation time. While still in the egg, the embryo is extremely vulnerable to predation and natural disasters.\\n\\n\\ud83d\\udcf8: \\u0040matt_durell \\n\\n#AWV #Conservation #Nature #Wildlife #Birds\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/868289493855068\\/?type=3\",\"target\":{\"id\":\"868289493855068\"},\"media\":{\"image\":{\"height\":460,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s720x720\\/251233876_868289490521735_6763957930071885993_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=3fBwHjWapEgAX9M1g5I&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=9b47d05283393ba833cfa6e499662266&oe=61930011\",\"width\":720}}}]},\"shares\":{\"count\":5},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_864893257528025\",\"updated_time\":\"2021-10-31T14:09:43+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"message_tags\":[{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":1814,\"length\":4},{\"id\":\"165827370243341\",\"name\":\"#projectpost\",\"offset\":1819,\"length\":12},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":1832,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":1840,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":1850,\"length\":13},{\"id\":\"497313510325119\",\"name\":\"#wilddog\",\"offset\":1864,\"length\":8}],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s130x130\\/248439688_864893224194695_1838423497874215535_n.jpg?_nc_cat=102&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=HgubP9QWeuMAX8RC5dA&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=fe8c4c78b4d8dc91dc562bfbd2de6934&oe=61927662\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s720x720\\/248439688_864893224194695_1838423497874215535_n.jpg?_nc_cat=102&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=HgubP9QWeuMAX8RC5dA&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=49fa024b04a4553fd5875516ed91b78c&oe=61930B84\",\"status_type\":\"added_photos\",\"created_time\":\"2021-10-28T10:21:27+0000\",\"attachments\":{\"data\":[{\"description\":\"A Wildlife ACT Priority Species Monitor had been following one of the wild dog packs in  Hluhluwe-iMfolozi Park and picked up that the tracking collar for one wild dog indicated he had remained in an area the pack had been hunting in while the rest of the pack had returned to their den. She alerted Ezemvelo KZN Wildlife who responded immediately to the incident. With the assistance of Cole du Plessis of the Endangered Wildlife Trust, Dr. Dave Druce, the Hluhluwe-iMfolozi Park Ecologist monitored the wild dog in the snare from a distance while they waited for Dr. Rowan Leeming who was rushing to the scene as quickly as possible. Moments before he got there, the wild dog thrashed about in the snare which unfortunately tightened the snare and caused the dog to lose consciousness. Dave and Cole immediately responded, ran to the dog, cut the snare off and ensured the dog was breathing. The dog remained motionless until Dr. Leeming arrived. The dog was given a mild sedation as well as some shock therapy. His collar was removed and he was treated with painkillers and antibiotics. He was then placed in the vicinity of the rest of his pack and their den. While he was waking up, other pack members spent some time sniffing him and checking in on him. He took some time to wake up and find the strength to move back towards the rest of his pack and their den site. He was closely monitored for days after the incident to ensure his full recovery. He will be collared again when his wounds have fully healed. AWV also provided the pharmaceuticals for this operation. Veterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica \\n\\nIf you want to support our operations please do so at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\\n\\n#AWV #ProjectPost #Nature #Wildlife #Conservation #Wilddog\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864893227528028\\/?type=3\",\"target\":{\"id\":\"864893227528028\"},\"media\":{\"image\":{\"height\":720,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s720x720\\/248439688_864893224194695_1838423497874215535_n.jpg?_nc_cat=102&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=HgubP9QWeuMAX8RC5dA&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=49fa024b04a4553fd5875516ed91b78c&oe=61930B84\",\"width\":576}}}]},\"shares\":{\"count\":47},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_864348374249180\",\"updated_time\":\"2021-10-27T11:06:15+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":362,\"length\":4},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":367,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":375,\"length\":9},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":385,\"length\":13},{\"id\":\"134910703348539\",\"name\":\"#ostrich\",\"offset\":399,\"length\":8}],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s130x130\\/248893004_864348314249186_5286872304036142437_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=ypTS2ijTwygAX8Z-lmJ&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=0d5ccae8fed5287e8abcd0a5683e03ec&oe=6193CA03\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p480x480\\/248893004_864348314249186_5286872304036142437_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=ypTS2ijTwygAX8Z-lmJ&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=38a44e4d7881155df2cc4e1daee2ceee&oe=6193DA33\",\"status_type\":\"added_photos\",\"created_time\":\"2021-10-27T11:06:15+0000\",\"attachments\":{\"data\":[{\"description\":\"#WednesdayWhyDay\\n\\nWhy do ostriches get red legs?\\n\\nThe male ostrich\'s beak and legs turn red\\/pink during the mating season (June-November) to attract females for mating. Male ostriches do a mating dance for females to impress her. Females will eventually mate with a male if the dance is good enough, but only after playing hard to get for long periods of time!\\n\\n#AWV #Nature #Wildlife #Conservation #Ostrich\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/864348327582518\\/?type=3\",\"target\":{\"id\":\"864348327582518\"},\"media\":{\"image\":{\"height\":480,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p480x480\\/248893004_864348314249186_5286872304036142437_n.jpg?_nc_cat=106&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=ypTS2ijTwygAX8Z-lmJ&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=38a44e4d7881155df2cc4e1daee2ceee&oe=6193DA33\",\"width\":720}}}]},\"shares\":{\"count\":2},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_861000247917326\",\"updated_time\":\"2021-10-23T12:24:04+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"Tragically, another rhino has been injured in a poaching incident. While the rhino is fortunately still alive, it had both it\'s horns forcefully removed by poachers. \\n\\nDr. Rowan Leeming immediately responded to the report of a white rhino that had been seen with severe injuries to its rostrum. The rhino was darted and the wounds were treated. A collar was also placed on its foot so that its\' condition can be assessed and monitored frequently.\\n\\nVeterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica\\n\\nWe have set up a GivenGain campaign for emergency operations. Please donate at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\",\"message_tags\":[],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/s130x130\\/247287349_861000221250662_7579237034016455759_n.jpg?_nc_cat=101&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=012rGPb7CugAX9sbE2_&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=ae1cc15f95786c731b602549da521870&oe=6192AC61\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p180x540\\/247287349_861000221250662_7579237034016455759_n.jpg?_nc_cat=101&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=012rGPb7CugAX9sbE2_&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=7488741af42bb08bc8459ec67331f2a2&oe=6193DDDD\",\"status_type\":\"added_photos\",\"created_time\":\"2021-10-21T14:07:24+0000\",\"attachments\":{\"data\":[{\"description\":\"Tragically, another rhino has been injured in a poaching incident. While the rhino is fortunately still alive, it had both it\'s horns forcefully removed by poachers. \\n\\nDr. Rowan Leeming immediately responded to the report of a white rhino that had been seen with severe injuries to its rostrum. The rhino was darted and the wounds were treated. A collar was also placed on its foot so that its\' condition can be assessed and monitored frequently.\\n\\nVeterinarian collaboratively sponsored by \\u0040africanwildlifevets , \\u0040conservation_beyond_borders , \\u0040wildlife_act and \\u0040wwfsouthafrica\\n\\nWe have set up a GivenGain campaign for emergency operations. Please donate at: \\n\\nhttps:\\/\\/www.givengain.com\\/cc\\/support-for-snaring\\/\",\"media_type\":\"photo\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/photos\\/a.211232199560804\\/861000231250661\\/?type=3\",\"target\":{\"id\":\"861000231250661\"},\"media\":{\"image\":{\"height\":540,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t39.30808-6\\/p180x540\\/247287349_861000221250662_7579237034016455759_n.jpg?_nc_cat=101&ccb=1-5&_nc_sid=9e2e56&_nc_ohc=012rGPb7CugAX9sbE2_&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=7488741af42bb08bc8459ec67331f2a2&oe=6193DDDD\",\"width\":720}}}]},\"shares\":{\"count\":46},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}},{\"id\":\"108200019864023_860417701308914\",\"updated_time\":\"2021-10-21T06:10:08+0000\",\"from\":{\"picture\":{\"data\":{\"height\":50,\"is_silhouette\":false,\"url\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t1.18169-1\\/cp0\\/p50x50\\/29541497_159149561435735_277397625810836665_n.jpg?_nc_cat=100&ccb=1-5&_nc_sid=dbb9e7&_nc_ohc=zgRARqB4yP8AX9vh73e&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=8bd57f29c20ee1ca8a2d1a0788aadbd5&oe=61B5C2F5\",\"width\":50}},\"id\":\"108200019864023\",\"name\":\"African Wildlife Vets\",\"link\":\"https:\\/\\/www.facebook.com\\/108200019864023\"},\"message\":\"#WednesdayWhyDay\\n\\nWhy dung beetles aren\\u2019t active during the winter months:\\n\\nDung beetles are very sensitive to environmental change which is why they are used as bioindicators to assess the health of an ecosystem. Various studies on dung beetles have identified different factors influencing their abundance. Some researchers found that the temperature played a larger role. Others found that higher rainfall periods influenced the number of beetles as rainfall affects the abundance and quality of dung beetles\' primary resources (manure). Different researchers found that dung beetles were present throughout the year in mild climatic conditions.\\n\\nMany insects will decrease their activity during low temperature months and increase their activity as the weather gets warmer. It seems that the seasonality of dung beetles is dependent on the region that they occur in. According to Wolda (1978), seasonality in insects is controlled by three factors: resource availability, temperature and rainfall. Apparently, insects have a variety of methods of surviving the winter months. After much research we couldn\\u2019t find what actually happens to dung beetles when they are not in abundance. A couple of articles said that they go into a state of torpor (state of inactivity). We\\u2019d love to learn more about them, so if you\\u2019re aware of any research that has been done on this, please share it with us. If we can find more, we\\u2019ll share it with you too.\\n\\n#AWV #DungBeetle #Conservation #Nature #Wildlife\",\"message_tags\":[{\"id\":\"836829693071194\",\"name\":\"#WednesdayWhyDay\",\"offset\":0,\"length\":16},{\"id\":\"406408809454656\",\"name\":\"#AWV\",\"offset\":1447,\"length\":4},{\"id\":\"175078875978881\",\"name\":\"#dungbeetle\",\"offset\":1452,\"length\":11},{\"id\":\"336291313149370\",\"name\":\"#conservation\",\"offset\":1464,\"length\":13},{\"id\":\"153472648144900\",\"name\":\"#nature\",\"offset\":1478,\"length\":7},{\"id\":\"276109265855360\",\"name\":\"#wildlife\",\"offset\":1486,\"length\":9}],\"picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/p130x130\\/245422324_237901221731763_2386439681325576648_n.jpg?_nc_cat=103&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=iTKYr_F0bxgAX_qLVhs&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=c68ef330f25773d619391b090f3d5f28&oe=61936D8B\",\"full_picture\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/245422324_237901221731763_2386439681325576648_n.jpg?_nc_cat=103&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=iTKYr_F0bxgAX_qLVhs&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=d582ecd3ce9dbbc4d90f27c5bdbfb204&oe=6192FCDD\",\"status_type\":\"added_video\",\"created_time\":\"2021-10-20T14:10:56+0000\",\"attachments\":{\"data\":[{\"media_type\":\"video\",\"unshimmed_url\":\"https:\\/\\/www.facebook.com\\/africanwildlifevets.org\\/videos\\/237900881731797\\/\",\"target\":{\"id\":\"237900881731797\"},\"media\":{\"source\":\"https:\\/\\/video-ort2-1.xx.fbcdn.net\\/v\\/t42.1790-2\\/246047874_464681151637669_8956072604381141451_n.mp4?_nc_cat=109&ccb=1-5&_nc_sid=985c63&efg=eyJybHIiOjU3NCwicmxhIjo1MTIsInZlbmNvZGVfdGFnIjoic3ZlX3NkIn0\\u00253D&_nc_ohc=E30vU8InfXcAX8XGC_2&rl=574&vabr=319&_nc_ht=video-ort2-1.xx&edm=AKIiGfEEAAAA&oh=b7c187d6c52e3f95700811adecb3d25c&oe=61904276\",\"image\":{\"height\":480,\"src\":\"https:\\/\\/scontent-ort2-1.xx.fbcdn.net\\/v\\/t15.5256-10\\/245422324_237901221731763_2386439681325576648_n.jpg?_nc_cat=103&ccb=1-5&_nc_sid=ad6a45&_nc_ohc=iTKYr_F0bxgAX_qLVhs&_nc_ht=scontent-ort2-1.xx&edm=AKIiGfEEAAAA&oh=d582ecd3ce9dbbc4d90f27c5bdbfb204&oe=6192FCDD\",\"width\":480}}}]},\"shares\":{\"count\":9},\"privacy\":{\"allow\":\"\",\"deny\":\"\",\"description\":\"Public\",\"friends\":\"\",\"value\":\"EVERYONE\"}}],\"paging\":{\"cursors\":{\"before\":\"QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\",\"after\":\"QVFIUl9Kamt1VG50aVNodFpOWHlwX3RCS1BpQy1FdGg5QnEwWFcxOTIxMThpZAU9QdjVzODZAYUlV0MVZAzeUZAHZAnBGZAlcwME5KbVRiUU54UmVERkkzN1VtWEJvakVqZAmtBWldKVERvajMtRy16bzdTVzhvNE94R2xRREtLTUlhbWl6RHlP\"},\"next\":\"https:\\/\\/graph.facebook.com\\/v5.0\\/108200019864023\\/posts?access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&locale=en_US&fields=id\\u00252Cupdated_time\\u00252Cfrom\\u00257Bpicture\\u00252Cid\\u00252Cname\\u00252Clink\\u00257D\\u00252Cmessage\\u00252Cmessage_tags\\u00252Cstory\\u00252Cstory_tags\\u00252Cpicture\\u00252Cfull_picture\\u00252Cstatus_type\\u00252Ccreated_time\\u00252Cbackdated_time\\u00252Cattachments\\u00257Btitle\\u00252Cdescription\\u00252Cmedia_type\\u00252Cunshimmed_url\\u00252Ctarget\\u00257Bid\\u00257D\\u00252Cmulti_share_end_card\\u00252Cmedia\\u00257Bsource\\u00252Cimage\\u00257D\\u00252Csubattachments\\u00257D\\u00252Cshares\\u00252Ccall_to_action\\u00252Cprivacy&limit=7&after=QVFIUl9Kamt1VG50aVNodFpOWHlwX3RCS1BpQy1FdGg5QnEwWFcxOTIxMThpZAU9QdjVzODZAYUlV0MVZAzeUZAHZAnBGZAlcwME5KbVRiUU54UmVERkkzN1VtWEJvakVqZAmtBWldKVERvajMtRy16bzdTVzhvNE94R2xRREtLTUlhbWl6RHlP\"}}", "no");
INSERT INTO `HhhEP_options` VALUES("646", "_transient_timeout_!cff_backup_cff_ppca_1082064023_lvVZAS1apv", "1668257843", "no");
INSERT INTO `HhhEP_options` VALUES("647", "_transient_!cff_backup_cff_ppca_1082064023_lvVZAS1apv", "{\"api_url\":\"https://graph.facebook.com/v8.0/108200019864023/posts?limit=1&access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD\", \"shortcode_options\":\"&quot;&quot;\", \"data\":[{\"created_time\":\"2021-11-10T11:24:41+0000\",\"message\":\"#WednesdayWhyDay\\n\\nWhy are female hyenas more dominant than males?\\n\\nHyena clans are dominated by females. It is said that in a highly competitive system, hyena females have had to compete with males for food and they have therefore had to equal or surpass them in weight and in testosterone production. Researchers also found that females become masculinized during fetal development because of a high testosterone concentration. In another study researchers have found that female hyenas are dominant due to the fact that they can rely on greater social support than males because males are more likely to disperse and therefore disrupt social bonds.\\n\\n#AWV #Hyena #Nature #Wildlife #Conservation\",\"id\":\"108200019864023_872031983480819\"}],\"paging\":{\"cursors\":{\"before\":\"QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\",\"after\":\"QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\"},\"next\":\"https:\\/\\/graph.facebook.com\\/v8.0\\/108200019864023\\/posts?access_token=EAAS8LGISx9wBALlvVZAS1apvseANZB1r3ejDlxevm9bfEYmV2Vnr06Gfl4b9xbyZA7noZB8BsawZCnHugS8VIuIslHHZASuZAQeZAirn2kHf9iRX83D0pfo1whaIl9ekenqfPlF7N0ZCC11JbFRkojmamCgZBkbkg3r8sCazvXnpo8Q8Qs0kc0WrJlH0wvTZC1638IZD&limit=1&after=QVFIUmI2YXdtNndfd1o5My1FbjZAhNDY0NmtvZAmJldFFLN0lKTG9NSFA4ZAjFmdTE4T0lnM2VOVXM0dndXMmVnM2hDd3JiUG9ZAa290eU9jeHpweWNpMTg4WllaRzlrNk9XSXRTMndIeUtJNUFnSlVONnAyeWNXSjFZAakVKRklCUXg1Ymoy\"}}", "no");
INSERT INTO `HhhEP_options` VALUES("651", "!sbi_africanwildlifevets#10", "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", "no");
INSERT INTO `HhhEP_options` VALUES("654", "!sbi_header_africanwildlifevets#10", "5I+O9qiUOi4LA05uOpHKgC9SRWpQSG04a2RZY3poSUZnUE5PYkJ0K1piWnR1OTM4dFhHYkRmeUxUMFRrVEtwOEJhUFZDSktVMzBjNGMzQi9RYUlFL3FuRzFSb2JtZGNqdDNrV0p1ZXM2R3IxaVFqTS9BdTc5MUJYU0lMZ202eDJBMDUySXFsc2swUWpwY05kakRhQ2pNSzZxRHNwSkphNzRUR3ZBdjFwV2w3NUdXRmlBZ2YrTUVGOUt6dVY4LzVtRDQ2aFltdC9sMjYyNU1UQmFJei9zMUtIblZqM2R5R2lVLzZZSWU1Yk43OGtDbE9wTHFSNmFpQi9xNnZIcmU1MzVLb0JmK2pHN1F0Z1dsbFVUZU9RMHptNVVlakpuVmVMOXJKcHpjZ3pSTHBhTjBXU0pLRXRNS05WYm5tR3hHeUd4ZVlUYTJZeU5RWUt4UzlmcDlVWWQrdUJrbG0rS1VLUU1yN1pUd2lOd0ljQm9jaUdyckhUeFk4VVM5K0NwV3hnZTVRZjEzVEdFQnVhcTdzR2pQdVhlQUJnVW9MSDlYbXJMRVJxSGJLajY0Y3ZyeVJuU1dsWmhoZkMxK25QNWRiU0ltejNTb2pmZjN3Wm8ydXdsUzE4YlpNOHJhbG1keHpZNjd6UHhYMDAyWlF1OHBpVDVJZHYxKy81Tng1Ylh6V0R4WkhCZ1lRRHRwdGRoQjNHdWlUay9pdWU2aWtUb0RZd3dTTGkrd1JnK0lqdjBYNmFtaEFWSkVTUzBROEd1eXVYOXlKZythczJNTVJRcHRpRXFkaTFKQ2w0MDlyQXhTcExPZjBhaDhFVFNYVC9PS0x3WjFFa1E1NkpTcVB0ZFVPZzVSYzhVeU1wTzJXQVdTQlpQVUtkYjZtS21JalYyTklZVnZGeVorSHVJYXNKelAzdzNMZWEvLzF6cHJkYVpYd2hVUmV3ZGN0Sk15cFIyWS95bVdnMnJBYUN3YVYyV2hGTHVNa1RjV1FnNGVXZE0yaVVEM05nemNvRzUwdmhpUERlaDMxTlgrcUp4b1VNbnRLVGttZUF2QmoxRWxNamx1aW1BV3h6QnA4bkl3dDVXNFdWZHdwejIxSlIyb2tuY3d2VE1zZ1RHQmkxTkN1QzEraS90R0hUZ0JZSW93MXc2Y3R6Zk16Z2pNV29GYjNNTkhWRjVqT2dDeUczNG1CNDdoeWlFNHZ4V3BxRStSTXgzNG1QOE00RGpQc0lWRFkxa1d5K3hLc0F4MGZPOGVoYU5iMTZHNXBzeFg3aGdGaGxaUnhZWVFxOHFGSWVndzVGUVNFZVRjNG5jWm92T3IyQ3hBc2Q0clBkQVljeXNHekU2eHNMeXAzMURmL01sK1JqN2ZRdG1mcGNId1I4SUhpcGxUUWZLZVhQUGp4MS9zTWQxU2pUSkQ3VklHQ09EQTFzc0Y5RlFOWk4vQ1R3M2hnWWhhZE9GQWZwUDVPYjB4d290dUJnU1ovamVJMmY0Y0hWWDQ1UU9tSStpY04vUWRRZHEvYkorUkpCQVN4L3U0djBRZDJqcWJkMFhhb1N6V3dJN0ZnNkIvV2N6cHljZHlNdEZZdEEwMFdCejFSd1hKRHhqSHBHb0d5L0x1VGVvQjQrc3VWdXFMVFllVTRGM0lad0ZnOHlKUnBpUDA4ellFa0VoaDVONU1pRHJzeUZqREVIT3UwMlNPeE9BMFhENEx5aW5GVFVya3RFWTVwNEVIK2I4dkVxMXZQU080SUh1d1g2emdqMG1vVTBpWGxsUDViak9LMTNsKzlPejUwUVRLUnlMRDhSSEpJVitBaVVRVTdJNUtkQXIwSDVZa3I3Y3hkeFpUUDR1bzhvTFE9PQ==", "no");
INSERT INTO `HhhEP_options` VALUES("675", "sbi_refresh_report", "a:1:{s:5:\"notes\";a:1:{s:8:\"time_ran\";s:19:\"2021-12-01 05:53:14\";}}", "no");
INSERT INTO `HhhEP_options` VALUES("831", "action_scheduler_hybrid_store_demarkation", "207", "yes");
INSERT INTO `HhhEP_options` VALUES("832", "schema-ActionScheduler_StoreSchema", "5.0.1637047404", "yes");
INSERT INTO `HhhEP_options` VALUES("833", "schema-ActionScheduler_LoggerSchema", "3.0.1637047404", "yes");
INSERT INTO `HhhEP_options` VALUES("836", "woocommerce_schema_version", "430", "yes");
INSERT INTO `HhhEP_options` VALUES("837", "woocommerce_store_address", "uMkhuze Game Reserve", "yes");
INSERT INTO `HhhEP_options` VALUES("838", "woocommerce_store_address_2", "", "yes");
INSERT INTO `HhhEP_options` VALUES("839", "woocommerce_store_city", "Mkuze", "yes");
INSERT INTO `HhhEP_options` VALUES("840", "woocommerce_default_country", "ZA:KZN", "yes");
INSERT INTO `HhhEP_options` VALUES("841", "woocommerce_store_postcode", "3965", "yes");
INSERT INTO `HhhEP_options` VALUES("842", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `HhhEP_options` VALUES("843", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("844", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("845", "woocommerce_ship_to_countries", "specific", "yes");
INSERT INTO `HhhEP_options` VALUES("846", "woocommerce_specific_ship_to_countries", "a:1:{i:0;s:2:\"ZA\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("847", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `HhhEP_options` VALUES("848", "woocommerce_calc_taxes", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("849", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("850", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `HhhEP_options` VALUES("851", "woocommerce_currency", "ZAR", "yes");
INSERT INTO `HhhEP_options` VALUES("852", "woocommerce_currency_pos", "left", "yes");
INSERT INTO `HhhEP_options` VALUES("853", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `HhhEP_options` VALUES("854", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `HhhEP_options` VALUES("855", "woocommerce_price_num_decimals", "2", "yes");
INSERT INTO `HhhEP_options` VALUES("856", "woocommerce_shop_page_id", "208", "yes");
INSERT INTO `HhhEP_options` VALUES("857", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("858", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("859", "woocommerce_placeholder_image", "207", "yes");
INSERT INTO `HhhEP_options` VALUES("860", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `HhhEP_options` VALUES("861", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `HhhEP_options` VALUES("862", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("863", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("864", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `HhhEP_options` VALUES("865", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("866", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("867", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("868", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `HhhEP_options` VALUES("869", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("870", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("871", "woocommerce_stock_email_recipient", "admin@dev.africanwildlifevets.xcontent.com", "no");
INSERT INTO `HhhEP_options` VALUES("872", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `HhhEP_options` VALUES("873", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `HhhEP_options` VALUES("874", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("875", "woocommerce_stock_format", "", "yes");
INSERT INTO `HhhEP_options` VALUES("876", "woocommerce_file_download_method", "force", "no");
INSERT INTO `HhhEP_options` VALUES("877", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `HhhEP_options` VALUES("878", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `HhhEP_options` VALUES("879", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("880", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("881", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("882", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `HhhEP_options` VALUES("883", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `HhhEP_options` VALUES("884", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("885", "woocommerce_tax_classes", "", "yes");
INSERT INTO `HhhEP_options` VALUES("886", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `HhhEP_options` VALUES("887", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `HhhEP_options` VALUES("888", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `HhhEP_options` VALUES("889", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `HhhEP_options` VALUES("890", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("891", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("892", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `HhhEP_options` VALUES("893", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("894", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("895", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `HhhEP_options` VALUES("896", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `HhhEP_options` VALUES("897", "woocommerce_enable_myaccount_registration", "no", "no");
INSERT INTO `HhhEP_options` VALUES("898", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("899", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("900", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `HhhEP_options` VALUES("901", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `HhhEP_options` VALUES("902", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `HhhEP_options` VALUES("903", "woocommerce_registration_privacy_policy_text", "Your personal data will be used to support your experience throughout this website, to manage access to your account, and for other purposes described in our [privacy_policy].", "yes");
INSERT INTO `HhhEP_options` VALUES("904", "woocommerce_checkout_privacy_policy_text", "Your personal data will be used to process your order, support your experience throughout this website, and for other purposes described in our [privacy_policy].", "yes");
INSERT INTO `HhhEP_options` VALUES("905", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `HhhEP_options` VALUES("906", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `HhhEP_options` VALUES("907", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `HhhEP_options` VALUES("908", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `HhhEP_options` VALUES("909", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `HhhEP_options` VALUES("910", "woocommerce_email_from_name", "African Wildlife Vets", "no");
INSERT INTO `HhhEP_options` VALUES("911", "woocommerce_email_from_address", "media@africanwildlifevets.org", "no");
INSERT INTO `HhhEP_options` VALUES("912", "woocommerce_email_header_image", "", "no");
INSERT INTO `HhhEP_options` VALUES("913", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `HhhEP_options` VALUES("914", "woocommerce_email_base_color", "#96588a", "no");
INSERT INTO `HhhEP_options` VALUES("915", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `HhhEP_options` VALUES("916", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `HhhEP_options` VALUES("917", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `HhhEP_options` VALUES("918", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `HhhEP_options` VALUES("919", "woocommerce_cart_page_id", "209", "no");
INSERT INTO `HhhEP_options` VALUES("920", "woocommerce_checkout_page_id", "210", "no");
INSERT INTO `HhhEP_options` VALUES("921", "woocommerce_myaccount_page_id", "211", "no");
INSERT INTO `HhhEP_options` VALUES("922", "woocommerce_terms_page_id", "", "no");
INSERT INTO `HhhEP_options` VALUES("923", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `HhhEP_options` VALUES("924", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `HhhEP_options` VALUES("925", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `HhhEP_options` VALUES("926", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `HhhEP_options` VALUES("927", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `HhhEP_options` VALUES("928", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `HhhEP_options` VALUES("929", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `HhhEP_options` VALUES("930", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `HhhEP_options` VALUES("931", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `HhhEP_options` VALUES("932", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `HhhEP_options` VALUES("933", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `HhhEP_options` VALUES("934", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `HhhEP_options` VALUES("935", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `HhhEP_options` VALUES("936", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("937", "woocommerce_allow_tracking", "no", "no");
INSERT INTO `HhhEP_options` VALUES("938", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `HhhEP_options` VALUES("939", "woocommerce_single_image_width", "450", "yes");
INSERT INTO `HhhEP_options` VALUES("940", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `HhhEP_options` VALUES("941", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("942", "woocommerce_demo_store", "no", "no");
INSERT INTO `HhhEP_options` VALUES("943", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `HhhEP_options` VALUES("944", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("945", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("948", "default_product_cat", "16", "yes");
INSERT INTO `HhhEP_options` VALUES("950", "woocommerce_refund_returns_page_id", "212", "yes");
INSERT INTO `HhhEP_options` VALUES("953", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:85:\"Pay via PayPal; you can pay with your credit card if you don\'t have a PayPal account.\";s:5:\"email\";s:42:\"admin@dev.africanwildlifevets.xcontent.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:42:\"admin@dev.africanwildlifevets.xcontent.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("954", "woocommerce_version", "5.9.0", "yes");
INSERT INTO `HhhEP_options` VALUES("955", "woocommerce_db_version", "5.9.0", "yes");
INSERT INTO `HhhEP_options` VALUES("956", "woocommerce_inbox_variant_assignment", "5", "yes");
INSERT INTO `HhhEP_options` VALUES("961", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("962", "action_scheduler_lock_async-request-runner", "1638343633", "yes");
INSERT INTO `HhhEP_options` VALUES("963", "woocommerce_admin_notices", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("964", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"XVmGJSLWtlGAnNEV61NWaULrytP6cKCc\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("965", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("966", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("967", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("968", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("969", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("970", "widget_woocommerce_product_categories", "a:3:{i:2;a:8:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}i:3;a:8:{s:5:\"title\";s:18:\"Product categories\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("971", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("972", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("973", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("974", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("975", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("976", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("977", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("978", "widget_upsell_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("981", "woocommerce_admin_version", "2.8.0", "yes");
INSERT INTO `HhhEP_options` VALUES("982", "woocommerce_admin_install_timestamp", "1637047411", "yes");
INSERT INTO `HhhEP_options` VALUES("983", "wc_remote_inbox_notifications_wca_updated", "", "no");
INSERT INTO `HhhEP_options` VALUES("984", "wc_remote_inbox_notifications_specs", "a:30:{s:27:\"stripe_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"stripe_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:380:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/stripe/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#apple-pay\">enable Apple Pay with Stripe</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"stripe_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}s:27:\"square_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"square_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:393:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/woocommerce-square/?_ga=2.90941597.642705274.1635776464-1391993999.1621950839#section-14\">enable Apple Pay with Square</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:27:\"square_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-square\";}}}}s:26:\"wcpay_applepay_holiday2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"wcpay_applepay_holiday2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Boost sales this holiday season with Apple Pay!\";s:7:\"content\";s:338:\"Increase your conversion rate by letting your customers know that you accept Apple Pay. It’s seamless to <a href=\"https://docs.woocommerce.com/document/payments/apple-pay/\">enable Apple Pay with WooCommerce Payments</a> and easy to communicate it with this <a href=\"https://developer.apple.com/apple-pay/marketing/\">marketing guide</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"wcpay_applepay_holiday2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:16:\"Accept Apple Pay\";}}s:3:\"url\";s:34:\"https://woocommerce.com/apple-pay/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-08 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-26 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}s:27:\"new_in_app_marketplace_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:27:\"new_in_app_marketplace_2021\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Customize your store with extensions\";s:7:\"content\";s:164:\"Check out our NEW Extensions tab to see our favorite extensions for customizing your store, and discover the most popular extensions in the WooCommerce Marketplace.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"browse_extensions\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Browse extensions\";}}s:3:\"url\";s:15:\"&page=wc-addons\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.7\";}}}s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:259:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store\'s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:42:\"https://woocommerce.com/products/wayflyer/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:45:\"https://woocommerce.com/woocommerce-shipping/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:30:\"wc_shipping_mobile_app_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:69:\"Print and manage your shipping labels with the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"wc_shipping_mobile_app_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:30:\"Get the WooCommerce Mobile App\";}}s:3:\"url\";s:31:\"https://woocommerce.com/mobile/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}s:37:\"ecomm-need-help-setting-up-your-store\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"ecomm-need-help-setting-up-your-store\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:32:\"Need help setting up your Store?\";s:7:\"content\";s:350:\"Schedule a free 30-min <a href=\"https://wordpress.com/support/concierge-support/\">quick start session</a> and get help from our specialists. We’re happy to walk through setup steps, show you around the WordPress.com dashboard, troubleshoot any issues you may have, and help you the find the features you need to accomplish your goals for your site.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:16:\"set-up-concierge\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Schedule free session\";}}s:3:\"url\";s:34:\"https://wordpress.com/me/concierge\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}}}s:20:\"woocommerce-services\";O:8:\"stdClass\":8:{s:4:\"slug\";s:20:\"woocommerce-services\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:26:\"WooCommerce Shipping & Tax\";s:7:\"content\";s:255:\"WooCommerce Shipping & Tax helps get your store “ready to sell” as quickly as possible. You create your products. We take care of tax calculation, payment processing, and shipping label printing! Learn more about the extension that you just installed.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:84:\"https://docs.woocommerce.com/document/woocommerce-shipping-and-tax/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:32:\"ecomm-unique-shopping-experience\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"ecomm-unique-shopping-experience\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"For a shopping experience as unique as your customers\";s:7:\"content\";s:274:\"Product Add-Ons allow your customers to personalize products while they’re shopping on your online store. No more follow-up email requests—customers get what they want, before they’re done checking out. Learn more about this extension that comes included in your plan.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"learn-more-ecomm-unique-shopping-experience\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:71:\"https://docs.woocommerce.com/document/product-add-ons/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:3:{i:0;s:35:\"woocommerce-shipping-australia-post\";i:1;s:32:\"woocommerce-shipping-canada-post\";i:2;s:30:\"woocommerce-shipping-royalmail\";}}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:2;}}}s:37:\"wc-admin-getting-started-in-ecommerce\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-getting-started-in-ecommerce\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"Getting Started in eCommerce - webinar\";s:7:\"content\";s:174:\"We want to make eCommerce and this process of getting started as easy as possible for you. Watch this webinar to get tips on how to have our store up and running in a breeze.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:17:\"watch-the-webinar\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:17:\"Watch the webinar\";}}s:3:\"url\";s:28:\"https://youtu.be/V_2XtCOyZ7o\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:12:\"setup_client\";s:9:\"operation\";s:2:\"!=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_count\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:1:\"0\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:4:\"none\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:7:\"revenue\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:10:\"up-to-2500\";}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:461:\"That\'s huge! You\'re well on your way to building a successful online store — now it’s time to think about how you\'ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:171:\"It\'s crucial to get your store\'s checkout as smooth as possible to avoid losing sales. Let\'s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:78:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:39:\"wc-admin-first-five-things-to-customize\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-admin-first-five-things-to-customize\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:45:\"The first 5 things to customize in your store\";s:7:\"content\";s:173:\"Deciding what to start with first is tricky. To help you properly prioritize, we\'ve put together this short list of the first few things you should customize in WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:82:\"https://woocommerce.com/posts/first-things-customize-woocommerce/?utm_source=inbox\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:2;}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:5:\"value\";s:9:\"NOT EMPTY\";s:7:\"default\";s:9:\"NOT EMPTY\";s:9:\"operation\";s:2:\"!=\";}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Payments setup - let us know what you think\";s:7:\"content\";s:146:\"Congrats on enabling WooCommerce Payments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:39:\"https://automattic.survey.fm/wc-pay-new\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:56:\"https://woocommerce.com/products/google-listings-and-ads\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:736:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site\'s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":7:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:5:\"rules\";a:0:{}}s:30:\"wcpay-promo-2021-6-incentive-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-1\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:25:\"get-woo-commerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"1\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"3\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"5\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"7\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"9\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"11\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:30:\"wcpay-promo-2021-6-incentive-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"wcpay-promo-2021-6-incentive-2\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:82:\"Simplify the payments process for you and your customers with WooCommerce Payments\";s:7:\"content\";s:702:\"With <a href=\"https://woocommerce.com/payments/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">WooCommerce Payments</a>, you can securely accept all major cards, Apple Pay®, and recurring revenue in over 100 currencies.\n				Built into your store’s WooCommerce dashboard, track cash flow and manage all of your transactions in one place – with no setup costs or monthly fees.\n				<br/><br/>\n				By clicking \"Get WooCommerce Payments,\" you agree to the <a href=\"https://wordpress.com/tos/?utm_medium=notification&utm_source=product&utm_campaign=wcpay601\">Terms of Service</a>\n				and acknowledge you have read the <a href=\"https://automattic.com/privacy/\">Privacy Policy</a>.\n				\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"get-woocommerce-payments\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Payments\";}}s:3:\"url\";s:57:\"admin.php?page=wc-admin&action=setup-woocommerce-payments\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:12:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:6:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"2\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"4\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"6\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:1:\"8\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"10\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";s:2:\"12\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:4:{i:0;s:17:\"crowdsignal-forms\";i:1;s:11:\"layout-grid\";i:2;s:17:\"full-site-editing\";i:3;s:13:\"page-optimize\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:5:\"value\";s:2:\"US\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:26:\"woocommerce_allow_tracking\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:2:\">=\";s:4:\"days\";i:31;}i:5;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"4.0\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:10:\"db_version\";s:5:\"value\";s:5:\"45805\";s:7:\"default\";i:0;s:9:\"operation\";s:2:\">=\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-11\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:8:\"actioned\";s:9:\"operation\";s:2:\"!=\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:19:\"wcpay-promo-2020-12\";s:6:\"status\";s:10:\"unactioned\";s:9:\"operation\";s:2:\"!=\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:440:\"Heads up! There\'s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:513:\"We\'ve developed a whole new <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension for WooCommerce</a> that combines the best features of our many PayPal extensions into just one extension.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br/><br/>Start using our latest PayPal today to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:38:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:146:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=vulnerability_comms\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"We\'re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:134:\"We\'d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}}", "no");
INSERT INTO `HhhEP_options` VALUES("985", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `HhhEP_options` VALUES("989", "wc_blocks_surface_cart_checkout_probability", "24", "yes");
INSERT INTO `HhhEP_options` VALUES("990", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `HhhEP_options` VALUES("991", "woocommerce_meta_box_errors", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("995", "_transient_woocommerce_reports-transient-version", "1637047413", "yes");
INSERT INTO `HhhEP_options` VALUES("1007", "woocommerce_onboarding_profile", "a:1:{s:7:\"skipped\";b:1;}", "yes");
INSERT INTO `HhhEP_options` VALUES("1018", "woocommerce_task_list_welcome_modal_dismissed", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("1023", "woocommerce_payfast_settings", "a:10:{s:7:\"enabled\";s:3:\"yes\";s:5:\"title\";s:7:\"PayFast\";s:11:\"description\";s:0:\"\";s:8:\"testmode\";s:3:\"yes\";s:11:\"merchant_id\";s:8:\"14343715\";s:12:\"merchant_key\";s:13:\"vh77306i1gdtv\";s:11:\"pass_phrase\";s:9:\"AWV060717\";s:16:\"send_debug_email\";s:3:\"yes\";s:11:\"debug_email\";s:28:\"kate@africanwildlifevets.org\";s:14:\"enable_logging\";s:3:\"yes\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("1042", "woocommerce_marketplace_suggestions", "a:2:{s:11:\"suggestions\";a:27:{i:0;a:4:{s:4:\"slug\";s:28:\"product-edit-meta-tab-header\";s:7:\"context\";s:28:\"product-edit-meta-tab-header\";s:5:\"title\";s:22:\"Recommended extensions\";s:13:\"allow-dismiss\";b:0;}i:1;a:6:{s:4:\"slug\";s:39:\"product-edit-meta-tab-footer-browse-all\";s:7:\"context\";s:28:\"product-edit-meta-tab-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:2;a:9:{s:4:\"slug\";s:46:\"product-edit-mailchimp-woocommerce-memberships\";s:7:\"product\";s:33:\"woocommerce-memberships-mailchimp\";s:14:\"show-if-active\";a:1:{i:0;s:23:\"woocommerce-memberships\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/mailchimp-for-memberships.svg\";s:5:\"title\";s:25:\"Mailchimp for Memberships\";s:4:\"copy\";s:79:\"Completely automate your email lists by syncing membership changes to Mailchimp\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:67:\"https://woocommerce.com/products/mailchimp-woocommerce-memberships/\";}i:3;a:9:{s:4:\"slug\";s:19:\"product-edit-addons\";s:7:\"product\";s:26:\"woocommerce-product-addons\";s:14:\"show-if-active\";a:2:{i:0;s:25:\"woocommerce-subscriptions\";i:1;s:20:\"woocommerce-bookings\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-add-ons.svg\";s:5:\"title\";s:15:\"Product Add-Ons\";s:4:\"copy\";s:93:\"Offer add-ons like gift wrapping, special messages or other special options for your products\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-add-ons/\";}i:4;a:9:{s:4:\"slug\";s:46:\"product-edit-woocommerce-subscriptions-gifting\";s:7:\"product\";s:33:\"woocommerce-subscriptions-gifting\";s:14:\"show-if-active\";a:1:{i:0;s:25:\"woocommerce-subscriptions\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:116:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/gifting-for-subscriptions.svg\";s:5:\"title\";s:25:\"Gifting for Subscriptions\";s:4:\"copy\";s:70:\"Let customers buy subscriptions for others - they\'re the ultimate gift\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:67:\"https://woocommerce.com/products/woocommerce-subscriptions-gifting/\";}i:5;a:9:{s:4:\"slug\";s:42:\"product-edit-teams-woocommerce-memberships\";s:7:\"product\";s:33:\"woocommerce-memberships-for-teams\";s:14:\"show-if-active\";a:1:{i:0;s:23:\"woocommerce-memberships\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:112:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/teams-for-memberships.svg\";s:5:\"title\";s:21:\"Teams for Memberships\";s:4:\"copy\";s:123:\"Adds B2B functionality to WooCommerce Memberships, allowing sites to sell team, group, corporate, or family member accounts\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:63:\"https://woocommerce.com/products/teams-woocommerce-memberships/\";}i:6;a:8:{s:4:\"slug\";s:29:\"product-edit-variation-images\";s:7:\"product\";s:39:\"woocommerce-additional-variation-images\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:118:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/additional-variation-images.svg\";s:5:\"title\";s:27:\"Additional Variation Images\";s:4:\"copy\";s:72:\"Showcase your products in the best light with a image for each variation\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:73:\"https://woocommerce.com/products/woocommerce-additional-variation-images/\";}i:7;a:9:{s:4:\"slug\";s:47:\"product-edit-woocommerce-subscription-downloads\";s:7:\"product\";s:34:\"woocommerce-subscription-downloads\";s:14:\"show-if-active\";a:1:{i:0;s:25:\"woocommerce-subscriptions\";}s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:113:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/subscription-downloads.svg\";s:5:\"title\";s:22:\"Subscription Downloads\";s:4:\"copy\";s:57:\"Give customers special downloads with their subscriptions\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:68:\"https://woocommerce.com/products/woocommerce-subscription-downloads/\";}i:8;a:8:{s:4:\"slug\";s:31:\"product-edit-min-max-quantities\";s:7:\"product\";s:30:\"woocommerce-min-max-quantities\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:109:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/min-max-quantities.svg\";s:5:\"title\";s:18:\"Min/Max Quantities\";s:4:\"copy\";s:81:\"Specify minimum and maximum allowed product quantities for orders to be completed\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:52:\"https://woocommerce.com/products/min-max-quantities/\";}i:9;a:8:{s:4:\"slug\";s:28:\"product-edit-name-your-price\";s:7:\"product\";s:27:\"woocommerce-name-your-price\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/name-your-price.svg\";s:5:\"title\";s:15:\"Name Your Price\";s:4:\"copy\";s:70:\"Let customers pay what they want - useful for donations, tips and more\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/name-your-price/\";}i:10;a:8:{s:4:\"slug\";s:42:\"product-edit-woocommerce-one-page-checkout\";s:7:\"product\";s:29:\"woocommerce-one-page-checkout\";s:7:\"context\";a:1:{i:0;s:26:\"product-edit-meta-tab-body\";}s:4:\"icon\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/one-page-checkout.svg\";s:5:\"title\";s:17:\"One Page Checkout\";s:4:\"copy\";s:92:\"Don\'t make customers click around - let them choose products, checkout & pay all on one page\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:63:\"https://woocommerce.com/products/woocommerce-one-page-checkout/\";}i:11;a:4:{s:4:\"slug\";s:19:\"orders-empty-header\";s:7:\"context\";s:24:\"orders-list-empty-header\";s:5:\"title\";s:20:\"Tools for your store\";s:13:\"allow-dismiss\";b:0;}i:12;a:6:{s:4:\"slug\";s:30:\"orders-empty-footer-browse-all\";s:7:\"context\";s:24:\"orders-list-empty-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:13;a:8:{s:4:\"slug\";s:19:\"orders-empty-wc-pay\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-payments\";s:4:\"icon\";s:111:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/woocommerce-payments.svg\";s:5:\"title\";s:20:\"WooCommerce Payments\";s:4:\"copy\";s:125:\"Securely accept payments and manage transactions directly from your WooCommerce dashboard – no setup costs or monthly fees.\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-payments/\";}i:14;a:8:{s:4:\"slug\";s:19:\"orders-empty-zapier\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:18:\"woocommerce-zapier\";s:4:\"icon\";s:97:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/zapier.svg\";s:5:\"title\";s:6:\"Zapier\";s:4:\"copy\";s:88:\"Save time and increase productivity by connecting your store to more than 1000+ services\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:52:\"https://woocommerce.com/products/woocommerce-zapier/\";}i:15;a:8:{s:4:\"slug\";s:30:\"orders-empty-shipment-tracking\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:29:\"woocommerce-shipment-tracking\";s:4:\"icon\";s:108:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/shipment-tracking.svg\";s:5:\"title\";s:17:\"Shipment Tracking\";s:4:\"copy\";s:86:\"Let customers know when their orders will arrive by adding shipment tracking to emails\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:51:\"https://woocommerce.com/products/shipment-tracking/\";}i:16;a:8:{s:4:\"slug\";s:32:\"orders-empty-table-rate-shipping\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:31:\"woocommerce-table-rate-shipping\";s:4:\"icon\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/table-rate-shipping.svg\";s:5:\"title\";s:19:\"Table Rate Shipping\";s:4:\"copy\";s:122:\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:53:\"https://woocommerce.com/products/table-rate-shipping/\";}i:17;a:8:{s:4:\"slug\";s:40:\"orders-empty-shipping-carrier-extensions\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:4:\"icon\";s:118:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/shipping-carrier-extensions.svg\";s:5:\"title\";s:27:\"Shipping Carrier Extensions\";s:4:\"copy\";s:116:\"Show live rates from FedEx, UPS, USPS and more directly on your store - never under or overcharge for shipping again\";s:11:\"button-text\";s:13:\"Find Carriers\";s:8:\"promoted\";s:26:\"category-shipping-carriers\";s:3:\"url\";s:99:\"https://woocommerce.com/product-category/woocommerce-extensions/shipping-methods/shipping-carriers/\";}i:18;a:8:{s:4:\"slug\";s:32:\"orders-empty-google-product-feed\";s:7:\"context\";s:22:\"orders-list-empty-body\";s:7:\"product\";s:25:\"woocommerce-product-feeds\";s:4:\"icon\";s:110:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/google-product-feed.svg\";s:5:\"title\";s:19:\"Google Product Feed\";s:4:\"copy\";s:76:\"Increase sales by letting customers find you when they\'re shopping on Google\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:53:\"https://woocommerce.com/products/google-product-feed/\";}i:19;a:4:{s:4:\"slug\";s:35:\"products-empty-header-product-types\";s:7:\"context\";s:26:\"products-list-empty-header\";s:5:\"title\";s:23:\"Other types of products\";s:13:\"allow-dismiss\";b:0;}i:20;a:6:{s:4:\"slug\";s:32:\"products-empty-footer-browse-all\";s:7:\"context\";s:26:\"products-list-empty-footer\";s:9:\"link-text\";s:21:\"Browse all extensions\";s:3:\"url\";s:64:\"https://woocommerce.com/product-category/woocommerce-extensions/\";s:8:\"promoted\";s:31:\"category-woocommerce-extensions\";s:13:\"allow-dismiss\";b:0;}i:21;a:8:{s:4:\"slug\";s:30:\"products-empty-product-vendors\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:27:\"woocommerce-product-vendors\";s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-vendors.svg\";s:5:\"title\";s:15:\"Product Vendors\";s:4:\"copy\";s:47:\"Turn your store into a multi-vendor marketplace\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-vendors/\";}i:22;a:8:{s:4:\"slug\";s:26:\"products-empty-memberships\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:23:\"woocommerce-memberships\";s:4:\"icon\";s:102:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/memberships.svg\";s:5:\"title\";s:11:\"Memberships\";s:4:\"copy\";s:76:\"Give members access to restricted content or products, for a fee or for free\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:57:\"https://woocommerce.com/products/woocommerce-memberships/\";}i:23;a:9:{s:4:\"slug\";s:35:\"products-empty-woocommerce-deposits\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-deposits\";s:14:\"show-if-active\";a:1:{i:0;s:20:\"woocommerce-bookings\";}s:4:\"icon\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/deposits.svg\";s:5:\"title\";s:8:\"Deposits\";s:4:\"copy\";s:75:\"Make it easier for customers to pay by offering a deposit or a payment plan\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-deposits/\";}i:24;a:8:{s:4:\"slug\";s:40:\"products-empty-woocommerce-subscriptions\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:25:\"woocommerce-subscriptions\";s:4:\"icon\";s:104:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/subscriptions.svg\";s:5:\"title\";s:13:\"Subscriptions\";s:4:\"copy\";s:97:\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:59:\"https://woocommerce.com/products/woocommerce-subscriptions/\";}i:25;a:8:{s:4:\"slug\";s:35:\"products-empty-woocommerce-bookings\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:20:\"woocommerce-bookings\";s:4:\"icon\";s:99:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/bookings.svg\";s:5:\"title\";s:8:\"Bookings\";s:4:\"copy\";s:99:\"Allow customers to book appointments, make reservations or rent equipment without leaving your site\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:54:\"https://woocommerce.com/products/woocommerce-bookings/\";}i:26;a:8:{s:4:\"slug\";s:30:\"products-empty-product-bundles\";s:7:\"context\";s:24:\"products-list-empty-body\";s:7:\"product\";s:27:\"woocommerce-product-bundles\";s:4:\"icon\";s:106:\"https://woocommerce.com/wp-content/plugins/wccom-plugins/marketplace-suggestions/icons/product-bundles.svg\";s:5:\"title\";s:15:\"Product Bundles\";s:4:\"copy\";s:49:\"Offer customizable bundles and assembled products\";s:11:\"button-text\";s:10:\"Learn More\";s:3:\"url\";s:49:\"https://woocommerce.com/products/product-bundles/\";}}s:7:\"updated\";i:1637048151;}", "no");
INSERT INTO `HhhEP_options` VALUES("1073", "_transient_product_query-transient-version", "1638343379", "yes");
INSERT INTO `HhhEP_options` VALUES("1074", "_transient_product-transient-version", "1637140875", "yes");
INSERT INTO `HhhEP_options` VALUES("1145", "_transient_shipping-transient-version", "1637052344", "yes");
INSERT INTO `HhhEP_options` VALUES("1146", "_transient_timeout_wc_shipping_method_count_legacy", "1639644344", "no");
INSERT INTO `HhhEP_options` VALUES("1147", "_transient_wc_shipping_method_count_legacy", "a:2:{s:7:\"version\";s:10:\"1637052344\";s:5:\"value\";i:0;}", "no");
INSERT INTO `HhhEP_options` VALUES("1148", "woocommerce_demo_store_notice", "", "yes");
INSERT INTO `HhhEP_options` VALUES("1149", "woocommerce_maybe_regenerate_images_hash", "0de65104e99c1f16f59c910a1c062cfb", "yes");
INSERT INTO `HhhEP_options` VALUES("1292", "woocommerce_default_catalog_orderby", "menu_order", "yes");
INSERT INTO `HhhEP_options` VALUES("1648", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:0;s:3:\"all\";i:0;s:5:\"trash\";s:1:\"1\";s:9:\"moderated\";i:0;s:8:\"approved\";i:0;s:4:\"spam\";i:0;s:12:\"post-trashed\";i:0;}", "yes");
INSERT INTO `HhhEP_options` VALUES("1660", "category_children", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("1958", "woocommerce_shop_page_display", "subcategories", "yes");
INSERT INTO `HhhEP_options` VALUES("1959", "woocommerce_category_archive_display", "", "yes");
INSERT INTO `HhhEP_options` VALUES("1965", "wpseo_taxonomy_meta", "a:1:{s:11:\"product_cat\";a:4:{i:20;a:3:{s:13:\"wpseo_focuskw\";s:4:\"Caps\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:23;a:3:{s:13:\"wpseo_focuskw\";s:7:\"Hoodies\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:21;a:3:{s:13:\"wpseo_focuskw\";s:11:\"Sports Wear\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:22;a:3:{s:13:\"wpseo_focuskw\";s:8:\"T-shirts\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:1:\"0\";}}}", "yes");
INSERT INTO `HhhEP_options` VALUES("2000", "product_cat_children", "a:0:{}", "yes");
INSERT INTO `HhhEP_options` VALUES("2004", "woocommerce_new_order_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:9:\"recipient\";s:60:\"media@africanwildlifevets.org , kate@africanwildlifevets.org\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:28:\"Congratulations on the sale.\";s:10:\"email_type\";s:4:\"html\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("2006", "woocommerce_cancelled_order_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:9:\"recipient\";s:59:\"media@africanwildlifevets.org, kate@africanwildlifevets.org\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:19:\"Thanks for reading.\";s:10:\"email_type\";s:4:\"html\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("2010", "woocommerce_failed_order_settings", "a:6:{s:7:\"enabled\";s:3:\"yes\";s:9:\"recipient\";s:59:\"media@africanwildlifevets.org, kate@africanwildlifevets.org\";s:7:\"subject\";s:0:\"\";s:7:\"heading\";s:0:\"\";s:18:\"additional_content\";s:146:\"Hopefully they’ll be back. Read more about <a href=\"https://docs.woocommerce.com/document/managing-orders/\">troubleshooting failed payments</a>.\";s:10:\"email_type\";s:4:\"html\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("2210", "_transient_wc_attribute_taxonomies", "a:5:{i:0;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:11:\"animal-type\";s:15:\"attribute_label\";s:11:\"Animal Type\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:1;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"5\";s:14:\"attribute_name\";s:11:\"caps-colour\";s:15:\"attribute_label\";s:11:\"Caps Colour\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:2;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"3\";s:14:\"attribute_name\";s:6:\"colour\";s:15:\"attribute_label\";s:6:\"Colour\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:3;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"4\";s:14:\"attribute_name\";s:6:\"gender\";s:15:\"attribute_label\";s:6:\"Gender\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}i:4;O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"2\";s:14:\"attribute_name\";s:4:\"size\";s:15:\"attribute_label\";s:4:\"Size\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";s:1:\"0\";}}", "yes");
INSERT INTO `HhhEP_options` VALUES("2267", "wcsa_product", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("2268", "woocommerce_show_attributes_on_shop", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2269", "wcsa_cart", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("2270", "wcsa_customer_order_emails", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("2271", "wcsa_admin_email", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("2272", "wcsa_admin_order_details", "yes", "yes");
INSERT INTO `HhhEP_options` VALUES("2273", "woocommerce_show_attributes_hide_labels", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2274", "woocommerce_show_attributes_span", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2275", "wcsa_remove_semicolon", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2276", "wcsa_weight_product", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2277", "wcsa_dimensions_product", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2278", "wcsa_weight_cart", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2279", "wcsa_dimensions_cart", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2280", "wcsa_weight_customer_order_emails", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2281", "wcsa_dimensions_customer_order_emails", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2282", "wcsa_weight_admin_email", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2283", "wcsa_dimensions_admin_email", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2284", "wcsa_weight_admin_order_details", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2285", "wcsa_dimensions_admin_order_details", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2286", "wcsa_terms_as_links", "no", "yes");
INSERT INTO `HhhEP_options` VALUES("2295", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `HhhEP_options` VALUES("2509", "_transient_timeout_wc_product_children_237", "1639732145", "no");
INSERT INTO `HhhEP_options` VALUES("2510", "_transient_wc_product_children_237", "a:2:{s:3:\"all\";a:1:{i:0;i:443;}s:7:\"visible\";a:1:{i:0;i:443;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2511", "_transient_timeout_wc_var_prices_237", "1639732977", "no");
INSERT INTO `HhhEP_options` VALUES("2512", "_transient_wc_var_prices_237", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"443\":\"300.00\"},\"regular_price\":{\"443\":\"300.00\"},\"sale_price\":{\"443\":\"300.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"443\":\"300.00\"},\"regular_price\":{\"443\":\"300.00\"},\"sale_price\":{\"443\":\"300.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2515", "_transient_timeout_wc_child_has_weight_237", "1639732155", "no");
INSERT INTO `HhhEP_options` VALUES("2516", "_transient_wc_child_has_weight_237", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2517", "_transient_timeout_wc_child_has_dimensions_237", "1639732155", "no");
INSERT INTO `HhhEP_options` VALUES("2518", "_transient_wc_child_has_dimensions_237", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2541", "_transient_timeout_wc_product_children_236", "1639732266", "no");
INSERT INTO `HhhEP_options` VALUES("2542", "_transient_wc_product_children_236", "a:2:{s:3:\"all\";a:1:{i:0;i:444;}s:7:\"visible\";a:1:{i:0;i:444;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2543", "_transient_timeout_wc_var_prices_236", "1639732974", "no");
INSERT INTO `HhhEP_options` VALUES("2544", "_transient_wc_var_prices_236", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"444\":\"250.00\"},\"regular_price\":{\"444\":\"250.00\"},\"sale_price\":{\"444\":\"250.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"444\":\"250.00\"},\"regular_price\":{\"444\":\"250.00\"},\"sale_price\":{\"444\":\"250.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2547", "_transient_timeout_wc_child_has_weight_236", "1639732278", "no");
INSERT INTO `HhhEP_options` VALUES("2548", "_transient_wc_child_has_weight_236", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2549", "_transient_timeout_wc_child_has_dimensions_236", "1639732278", "no");
INSERT INTO `HhhEP_options` VALUES("2550", "_transient_wc_child_has_dimensions_236", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2580", "_transient_timeout_wc_product_children_235", "1639732561", "no");
INSERT INTO `HhhEP_options` VALUES("2581", "_transient_wc_product_children_235", "a:2:{s:3:\"all\";a:1:{i:0;i:445;}s:7:\"visible\";a:1:{i:0;i:445;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2582", "_transient_timeout_wc_var_prices_235", "1639732977", "no");
INSERT INTO `HhhEP_options` VALUES("2583", "_transient_wc_var_prices_235", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"445\":\"650.00\"},\"regular_price\":{\"445\":\"650.00\"},\"sale_price\":{\"445\":\"650.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"445\":\"650.00\"},\"regular_price\":{\"445\":\"650.00\"},\"sale_price\":{\"445\":\"650.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2586", "_transient_timeout_wc_child_has_weight_235", "1639732567", "no");
INSERT INTO `HhhEP_options` VALUES("2587", "_transient_wc_child_has_weight_235", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2588", "_transient_timeout_wc_child_has_dimensions_235", "1639732567", "no");
INSERT INTO `HhhEP_options` VALUES("2589", "_transient_wc_child_has_dimensions_235", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2606", "_transient_timeout_wc_product_children_234", "1639732686", "no");
INSERT INTO `HhhEP_options` VALUES("2607", "_transient_wc_product_children_234", "a:2:{s:3:\"all\";a:1:{i:0;i:446;}s:7:\"visible\";a:1:{i:0;i:446;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2608", "_transient_timeout_wc_var_prices_234", "1639732936", "no");
INSERT INTO `HhhEP_options` VALUES("2609", "_transient_wc_var_prices_234", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"446\":\"300.00\"},\"regular_price\":{\"446\":\"300.00\"},\"sale_price\":{\"446\":\"300.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"446\":\"300.00\"},\"regular_price\":{\"446\":\"300.00\"},\"sale_price\":{\"446\":\"300.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2612", "_transient_timeout_wc_child_has_weight_234", "1639732695", "no");
INSERT INTO `HhhEP_options` VALUES("2613", "_transient_wc_child_has_weight_234", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2614", "_transient_timeout_wc_child_has_dimensions_234", "1639732695", "no");
INSERT INTO `HhhEP_options` VALUES("2615", "_transient_wc_child_has_dimensions_234", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2634", "_transient_timeout_wc_product_children_233", "1639732769", "no");
INSERT INTO `HhhEP_options` VALUES("2635", "_transient_wc_product_children_233", "a:2:{s:3:\"all\";a:1:{i:0;i:448;}s:7:\"visible\";a:1:{i:0;i:448;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2636", "_transient_timeout_wc_var_prices_233", "1639732937", "no");
INSERT INTO `HhhEP_options` VALUES("2637", "_transient_wc_var_prices_233", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"448\":\"400.00\"},\"regular_price\":{\"448\":\"400.00\"},\"sale_price\":{\"448\":\"400.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"448\":\"400.00\"},\"regular_price\":{\"448\":\"400.00\"},\"sale_price\":{\"448\":\"400.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2638", "_transient_timeout_wc_child_has_weight_233", "1639732777", "no");
INSERT INTO `HhhEP_options` VALUES("2639", "_transient_wc_child_has_weight_233", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2640", "_transient_timeout_wc_child_has_dimensions_233", "1639732777", "no");
INSERT INTO `HhhEP_options` VALUES("2641", "_transient_wc_child_has_dimensions_233", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2659", "_transient_timeout_wc_product_children_232", "1639732876", "no");
INSERT INTO `HhhEP_options` VALUES("2660", "_transient_wc_product_children_232", "a:2:{s:3:\"all\";a:1:{i:0;i:449;}s:7:\"visible\";a:1:{i:0;i:449;}}", "no");
INSERT INTO `HhhEP_options` VALUES("2662", "_transient_timeout_wc_term_counts", "1639733009", "no");
INSERT INTO `HhhEP_options` VALUES("2663", "_transient_wc_term_counts", "a:15:{i:21;s:1:\"3\";i:20;s:1:\"2\";i:23;s:1:\"1\";i:22;s:1:\"1\";i:16;s:1:\"0\";i:17;s:1:\"6\";i:24;s:1:\"1\";i:25;s:1:\"2\";i:27;s:1:\"1\";i:26;s:1:\"1\";i:28;s:1:\"1\";i:18;s:1:\"2\";i:29;s:1:\"1\";i:30;s:1:\"1\";i:19;s:1:\"1\";}", "no");
INSERT INTO `HhhEP_options` VALUES("2664", "_transient_timeout_wc_var_prices_232", "1639732937", "no");
INSERT INTO `HhhEP_options` VALUES("2665", "_transient_wc_var_prices_232", "{\"version\":\"1637140875\",\"f9e544f77b7eac7add281ef28ca5559f\":{\"price\":{\"449\":\"600.00\"},\"regular_price\":{\"449\":\"600.00\"},\"sale_price\":{\"449\":\"600.00\"}},\"4173c8e28f114c545d779c47fd7e2df1\":{\"price\":{\"449\":\"600.00\"},\"regular_price\":{\"449\":\"600.00\"},\"sale_price\":{\"449\":\"600.00\"}}}", "no");
INSERT INTO `HhhEP_options` VALUES("2667", "_transient_timeout_wc_child_has_weight_232", "1639732954", "no");
INSERT INTO `HhhEP_options` VALUES("2668", "_transient_wc_child_has_weight_232", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2669", "_transient_timeout_wc_child_has_dimensions_232", "1639732954", "no");
INSERT INTO `HhhEP_options` VALUES("2670", "_transient_wc_child_has_dimensions_232", "0", "no");
INSERT INTO `HhhEP_options` VALUES("2759", "rewrite_rules", "a:219:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:19:\"sitemap_index\\.xml$\";s:19:\"index.php?sitemap=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:51:\"index.php?sitemap=$matches[1]&sitemap_n=$matches[2]\";s:24:\"([a-z]+)?-?sitemap\\.xsl$\";s:39:\"index.php?yoast-sitemap-xsl=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:16:\"featured_item/?$\";s:33:\"index.php?post_type=featured_item\";s:46:\"featured_item/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:41:\"featured_item/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_type=featured_item&feed=$matches[1]\";s:33:\"featured_item/page/([0-9]{1,})/?$\";s:51:\"index.php?post_type=featured_item&paged=$matches[1]\";s:32:\"blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"blocks/(.+?)/embed/?$\";s:39:\"index.php?blocks=$matches[1]&embed=true\";s:25:\"blocks/(.+?)/trackback/?$\";s:33:\"index.php?blocks=$matches[1]&tb=1\";s:33:\"blocks/(.+?)/page/?([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&paged=$matches[2]\";s:40:\"blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?blocks=$matches[1]&cpage=$matches[2]\";s:30:\"blocks/(.+?)/wc-api(/(.*))?/?$\";s:47:\"index.php?blocks=$matches[1]&wc-api=$matches[3]\";s:36:\"blocks/.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:47:\"blocks/.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:29:\"blocks/(.+?)(?:/([0-9]+))?/?$\";s:45:\"index.php?blocks=$matches[1]&page=$matches[2]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"block_categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=block_categories&term=$matches[1]&feed=$matches[2]\";s:52:\"block_categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?taxonomy=block_categories&term=$matches[1]&feed=$matches[2]\";s:33:\"block_categories/([^/]+)/embed/?$\";s:63:\"index.php?taxonomy=block_categories&term=$matches[1]&embed=true\";s:45:\"block_categories/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?taxonomy=block_categories&term=$matches[1]&paged=$matches[2]\";s:27:\"block_categories/([^/]+)/?$\";s:52:\"index.php?taxonomy=block_categories&term=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"featured_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"featured_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"featured_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"featured_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"featured_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"featured_item/([^/]+)/embed/?$\";s:46:\"index.php?featured_item=$matches[1]&embed=true\";s:34:\"featured_item/([^/]+)/trackback/?$\";s:40:\"index.php?featured_item=$matches[1]&tb=1\";s:54:\"featured_item/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:49:\"featured_item/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?featured_item=$matches[1]&feed=$matches[2]\";s:42:\"featured_item/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&paged=$matches[2]\";s:49:\"featured_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?featured_item=$matches[1]&cpage=$matches[2]\";s:39:\"featured_item/([^/]+)/wc-api(/(.*))?/?$\";s:54:\"index.php?featured_item=$matches[1]&wc-api=$matches[3]\";s:45:\"featured_item/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:56:\"featured_item/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:38:\"featured_item/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?featured_item=$matches[1]&page=$matches[2]\";s:30:\"featured_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"featured_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"featured_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"featured_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"featured_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"featured_item_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:58:\"featured_item_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:61:\"index.php?featured_item_category=$matches[1]&feed=$matches[2]\";s:39:\"featured_item_category/([^/]+)/embed/?$\";s:55:\"index.php?featured_item_category=$matches[1]&embed=true\";s:51:\"featured_item_category/([^/]+)/page/?([0-9]{1,})/?$\";s:62:\"index.php?featured_item_category=$matches[1]&paged=$matches[2]\";s:33:\"featured_item_category/([^/]+)/?$\";s:44:\"index.php?featured_item_category=$matches[1]\";s:58:\"featured_item_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:53:\"featured_item_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?featured_item_tag=$matches[1]&feed=$matches[2]\";s:34:\"featured_item_tag/([^/]+)/embed/?$\";s:50:\"index.php?featured_item_tag=$matches[1]&embed=true\";s:46:\"featured_item_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?featured_item_tag=$matches[1]&paged=$matches[2]\";s:28:\"featured_item_tag/([^/]+)/?$\";s:39:\"index.php?featured_item_tag=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=53&cpage=$matches[1]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `HhhEP_options` VALUES("3408", "_transient_timeout__woocommerce_helper_updates", "1638381198", "no");
INSERT INTO `HhhEP_options` VALUES("3409", "_transient__woocommerce_helper_updates", "a:4:{s:4:\"hash\";s:32:\"d751713988987e9331980363e24189ce\";s:7:\"updated\";i:1638337998;s:8:\"products\";a:0:{}s:6:\"errors\";a:1:{i:0;s:10:\"http-error\";}}", "no");
INSERT INTO `HhhEP_options` VALUES("3415", "_transient_timeout_sbi_africanwildlifevets#10", "1638346961", "no");
INSERT INTO `HhhEP_options` VALUES("3416", "_transient_sbi_africanwildlifevets#10", "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", "no");
INSERT INTO `HhhEP_options` VALUES("3417", "_transient_timeout_sbi_header_africanwildlifevets#10", "1638346961", "no");
INSERT INTO `HhhEP_options` VALUES("3418", "_transient_sbi_header_africanwildlifevets#10", "5I+O9qiUOi4LA05uOpHKgC9SRWpQSG04a2RZY3poSUZnUE5PYkJ0K1piWnR1OTM4dFhHYkRmeUxUMFRrVEtwOEJhUFZDSktVMzBjNGMzQi9RYUlFL3FuRzFSb2JtZGNqdDNrV0p1ZXM2R3IxaVFqTS9BdTc5MUJYU0lMZ202eDJBMDUySXFsc2swUWpwY05kakRhQ2pNSzZxRHNwSkphNzRUR3ZBdjFwV2w3NUdXRmlBZ2YrTUVGOUt6dVY4LzVtRDQ2aFltdC9sMjYyNU1UQmFJei9zMUtIblZqM2R5R2lVLzZZSWU1Yk43OGtDbE9wTHFSNmFpQi9xNnZIcmU1MzVLb0JmK2pHN1F0Z1dsbFVUZU9RMHptNVVlakpuVmVMOXJKcHpjZ3pSTHBhTjBXU0pLRXRNS05WYm5tR3hHeUd4ZVlUYTJZeU5RWUt4UzlmcDlVWWQrdUJrbG0rS1VLUU1yN1pUd2lOd0ljQm9jaUdyckhUeFk4VVM5K0NwV3hnZTVRZjEzVEdFQnVhcTdzR2pQdVhlQUJnVW9MSDlYbXJMRVJxSGJLajY0Y3ZyeVJuU1dsWmhoZkMxK25QNWRiU0ltejNTb2pmZjN3Wm8ydXdsUzE4YlpNOHJhbG1keHpZNjd6UHhYMDAyWlF1OHBpVDVJZHYxKy81Tng1Ylh6V0R4WkhCZ1lRRHRwdGRoQjNHdWlUay9pdWU2aWtUb0RZd3dTTGkrd1JnK0lqdjBYNmFtaEFWSkVTUzBROEd1eXVYOXlKZythczJNTVJRcHRpRXFkaTFKQ2w0MDlyQXhTcExPZjBhaDhFVFNYVC9PS0x3WjFFa1E1NkpTcVB0ZFVPZzVSYzhVeU1wTzJXQVdTQlpQVUtkYjZtS21JalYyTklZVnZGeVorSHVJYXNKelAzdzNMZWEvLzF6cHJkYVpYd2hVUmV3ZGN0Sk15cFIyWS95bVdnMnJBYUN3YVYyV2hGTHVNa1RjV1FnNGVXZE0yaVVEM05nemNvRzUwdmhpUERlaDMxTlgrcUp4b1VNbnRLVGttZUF2QmoxRWxNamx1aW1BV3h6QnA4bkl3dDVXNFdWZHdwejIxSlIyb2tuY3d2VE1zZ1RHQmkxTkN1QzEraS90R0hUZ0JZSW93MXc2Y3R6Zk16Z2pNV29GYjNNTkhWRjVqT2dDeUczNG1CNDdoeWlFNHZ4V3BxRStSTXgzNG1QOE00RGpQc0lWRFkxa1d5K3hLc0F4MGZPOGVoYU5iMTZHNXBzeFg3aGdGaGxaUnhZWVFxOHFGSWVndzVGUVNFZVRjNG5jWm92T3IyQ3hBc2Q0clBkQVljeXNHekU2eHNMeXAzMURmL01sK1JqN2ZRdG1mcGNId1I4SUhpcGxUUWZLZVhQUGp4MS9zTWQxU2pUSkQ3VklHQ09EQTFzc0Y5RlFOWk4vQ1R3M2hnWWhhZE9GQWZwUDVPYjB4d290dUJnU1ovamVJMmY0Y0hWWDQ1UU9tSStpY04vUWRRZHEvYkorUkpCQVN4L3U0djBRZDJqcWJkMFhhb1N6V3dJN0ZnNkIvV2N6cHljZHlNdEZZdEEwMFdCejFSd1hKRHhqSHBHb0d5L0x1VGVvQjQrc3VWdXFMVFllVTRGM0lad0ZnOHlKUnBpUDA4ellFa0VoaDVONU1pRHJzeUZqREVIT3UwMlNPeE9BMFhENEx5aW5GVFVya3RFWTVwNEVIK2I4dkVxMXZQU080SUh1d1g2emdqMG1vVTBpWGxsUDViak9LMTNsKzlPejUwUVRLUnlMRDhSSEpJVitBaVVRVTdJNUtkQXIwSDVZa3I3Y3hkeFpUUDR1bzhvTFE9PQ==", "no");
INSERT INTO `HhhEP_options` VALUES("3421", "_transient_timeout_wpseo_total_unindexed_posts_limited", "1638344265", "no");
INSERT INTO `HhhEP_options` VALUES("3422", "_transient_wpseo_total_unindexed_posts_limited", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3423", "_transient_timeout_wpseo_total_unindexed_terms_limited", "1638344265", "no");
INSERT INTO `HhhEP_options` VALUES("3424", "_transient_wpseo_total_unindexed_terms_limited", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3425", "_transient_timeout_wpseo_total_unindexed_post_type_archives", "1638429765", "no");
INSERT INTO `HhhEP_options` VALUES("3426", "_transient_wpseo_total_unindexed_post_type_archives", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3427", "_transient_timeout_wpseo_total_unindexed_general_items", "1638429765", "no");
INSERT INTO `HhhEP_options` VALUES("3428", "_transient_wpseo_total_unindexed_general_items", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3429", "_transient_timeout_wpseo_unindexed_post_link_count", "1638429765", "no");
INSERT INTO `HhhEP_options` VALUES("3430", "_transient_wpseo_unindexed_post_link_count", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3431", "_transient_timeout_wpseo_unindexed_term_link_count", "1638429765", "no");
INSERT INTO `HhhEP_options` VALUES("3432", "_transient_wpseo_unindexed_term_link_count", "0", "no");
INSERT INTO `HhhEP_options` VALUES("3433", "_site_transient_timeout_kirki_googlefonts_cache", "1638429776", "no");
INSERT INTO `HhhEP_options` VALUES("3434", "_site_transient_kirki_googlefonts_cache", "a:1064:{s:7:\"ABeeZee\";a:3:{s:5:\"label\";s:7:\"ABeeZee\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Abel\";a:3:{s:5:\"label\";s:4:\"Abel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Abhaya Libre\";a:3:{s:5:\"label\";s:12:\"Abhaya Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Abril Fatface\";a:3:{s:5:\"label\";s:13:\"Abril Fatface\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Aclonica\";a:3:{s:5:\"label\";s:8:\"Aclonica\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Acme\";a:3:{s:5:\"label\";s:4:\"Acme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Actor\";a:3:{s:5:\"label\";s:5:\"Actor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Adamina\";a:3:{s:5:\"label\";s:7:\"Adamina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Advent Pro\";a:3:{s:5:\"label\";s:10:\"Advent Pro\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Aguafina Script\";a:3:{s:5:\"label\";s:15:\"Aguafina Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Akaya Kanadaka\";a:3:{s:5:\"label\";s:14:\"Akaya Kanadaka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Akaya Telivigala\";a:3:{s:5:\"label\";s:16:\"Akaya Telivigala\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Akronim\";a:3:{s:5:\"label\";s:7:\"Akronim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aladin\";a:3:{s:5:\"label\";s:6:\"Aladin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Alata\";a:3:{s:5:\"label\";s:5:\"Alata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Alatsi\";a:3:{s:5:\"label\";s:6:\"Alatsi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Aldrich\";a:3:{s:5:\"label\";s:7:\"Aldrich\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Alef\";a:3:{s:5:\"label\";s:4:\"Alef\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Alegreya\";a:3:{s:5:\"label\";s:8:\"Alegreya\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Alegreya SC\";a:3:{s:5:\"label\";s:11:\"Alegreya SC\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"800\";i:5;s:9:\"800italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alegreya Sans\";a:3:{s:5:\"label\";s:13:\"Alegreya Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Alegreya Sans SC\";a:3:{s:5:\"label\";s:16:\"Alegreya Sans SC\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Aleo\";a:3:{s:5:\"label\";s:4:\"Aleo\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Alex Brush\";a:3:{s:5:\"label\";s:10:\"Alex Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Alfa Slab One\";a:3:{s:5:\"label\";s:13:\"Alfa Slab One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Alice\";a:3:{s:5:\"label\";s:5:\"Alice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Alike\";a:3:{s:5:\"label\";s:5:\"Alike\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Alike Angular\";a:3:{s:5:\"label\";s:13:\"Alike Angular\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Allan\";a:3:{s:5:\"label\";s:5:\"Allan\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Allerta\";a:3:{s:5:\"label\";s:7:\"Allerta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Allerta Stencil\";a:3:{s:5:\"label\";s:15:\"Allerta Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Allura\";a:3:{s:5:\"label\";s:6:\"Allura\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Almarai\";a:3:{s:5:\"label\";s:7:\"Almarai\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:3:\"800\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Almendra\";a:3:{s:5:\"label\";s:8:\"Almendra\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Almendra Display\";a:3:{s:5:\"label\";s:16:\"Almendra Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Almendra SC\";a:3:{s:5:\"label\";s:11:\"Almendra SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Amarante\";a:3:{s:5:\"label\";s:8:\"Amarante\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Amaranth\";a:3:{s:5:\"label\";s:8:\"Amaranth\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Amatic SC\";a:3:{s:5:\"label\";s:9:\"Amatic SC\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Amethysta\";a:3:{s:5:\"label\";s:9:\"Amethysta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amiko\";a:3:{s:5:\"label\";s:5:\"Amiko\";s:8:\"variants\";a:3:{i:0;s:3:\"600\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Amiri\";a:3:{s:5:\"label\";s:5:\"Amiri\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Amita\";a:3:{s:5:\"label\";s:5:\"Amita\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Anaheim\";a:3:{s:5:\"label\";s:7:\"Anaheim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Andada\";a:3:{s:5:\"label\";s:6:\"Andada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Andika\";a:3:{s:5:\"label\";s:6:\"Andika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Andika New Basic\";a:3:{s:5:\"label\";s:16:\"Andika New Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Angkor\";a:3:{s:5:\"label\";s:6:\"Angkor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Annie Use Your Telescope\";a:3:{s:5:\"label\";s:24:\"Annie Use Your Telescope\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Anonymous Pro\";a:3:{s:5:\"label\";s:13:\"Anonymous Pro\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Antic\";a:3:{s:5:\"label\";s:5:\"Antic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Antic Didone\";a:3:{s:5:\"label\";s:12:\"Antic Didone\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Antic Slab\";a:3:{s:5:\"label\";s:10:\"Antic Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Anton\";a:3:{s:5:\"label\";s:5:\"Anton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Antonio\";a:3:{s:5:\"label\";s:7:\"Antonio\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Arapey\";a:3:{s:5:\"label\";s:6:\"Arapey\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Arbutus\";a:3:{s:5:\"label\";s:7:\"Arbutus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Arbutus Slab\";a:3:{s:5:\"label\";s:12:\"Arbutus Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Architects Daughter\";a:3:{s:5:\"label\";s:19:\"Architects Daughter\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Archivo\";a:3:{s:5:\"label\";s:7:\"Archivo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Archivo Black\";a:3:{s:5:\"label\";s:13:\"Archivo Black\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Archivo Narrow\";a:3:{s:5:\"label\";s:14:\"Archivo Narrow\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Aref Ruqaa\";a:3:{s:5:\"label\";s:10:\"Aref Ruqaa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Arima Madurai\";a:3:{s:5:\"label\";s:13:\"Arima Madurai\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Arimo\";a:3:{s:5:\"label\";s:5:\"Arimo\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Arizonia\";a:3:{s:5:\"label\";s:8:\"Arizonia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Armata\";a:3:{s:5:\"label\";s:6:\"Armata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Arsenal\";a:3:{s:5:\"label\";s:7:\"Arsenal\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Artifika\";a:3:{s:5:\"label\";s:8:\"Artifika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arvo\";a:3:{s:5:\"label\";s:4:\"Arvo\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Arya\";a:3:{s:5:\"label\";s:4:\"Arya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asap\";a:3:{s:5:\"label\";s:4:\"Asap\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Asap Condensed\";a:3:{s:5:\"label\";s:14:\"Asap Condensed\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Asar\";a:3:{s:5:\"label\";s:4:\"Asar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Asset\";a:3:{s:5:\"label\";s:5:\"Asset\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Assistant\";a:3:{s:5:\"label\";s:9:\"Assistant\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Astloch\";a:3:{s:5:\"label\";s:7:\"Astloch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Asul\";a:3:{s:5:\"label\";s:4:\"Asul\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Athiti\";a:3:{s:5:\"label\";s:6:\"Athiti\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Atma\";a:3:{s:5:\"label\";s:4:\"Atma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Atomic Age\";a:3:{s:5:\"label\";s:10:\"Atomic Age\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Aubrey\";a:3:{s:5:\"label\";s:6:\"Aubrey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Audiowide\";a:3:{s:5:\"label\";s:9:\"Audiowide\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Autour One\";a:3:{s:5:\"label\";s:10:\"Autour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Average\";a:3:{s:5:\"label\";s:7:\"Average\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Average Sans\";a:3:{s:5:\"label\";s:12:\"Average Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Averia Gruesa Libre\";a:3:{s:5:\"label\";s:19:\"Averia Gruesa Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Averia Libre\";a:3:{s:5:\"label\";s:12:\"Averia Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Averia Sans Libre\";a:3:{s:5:\"label\";s:17:\"Averia Sans Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Averia Serif Libre\";a:3:{s:5:\"label\";s:18:\"Averia Serif Libre\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"B612\";a:3:{s:5:\"label\";s:4:\"B612\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"B612 Mono\";a:3:{s:5:\"label\";s:9:\"B612 Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:10:\"Bad Script\";a:3:{s:5:\"label\";s:10:\"Bad Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Bahiana\";a:3:{s:5:\"label\";s:7:\"Bahiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bahianita\";a:3:{s:5:\"label\";s:9:\"Bahianita\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bai Jamjuree\";a:3:{s:5:\"label\";s:12:\"Bai Jamjuree\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Ballet\";a:3:{s:5:\"label\";s:6:\"Ballet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Baloo 2\";a:3:{s:5:\"label\";s:7:\"Baloo 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Baloo Bhai 2\";a:3:{s:5:\"label\";s:12:\"Baloo Bhai 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Bhaina 2\";a:3:{s:5:\"label\";s:14:\"Baloo Bhaina 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Chettan 2\";a:3:{s:5:\"label\";s:15:\"Baloo Chettan 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Baloo Da 2\";a:3:{s:5:\"label\";s:10:\"Baloo Da 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Paaji 2\";a:3:{s:5:\"label\";s:13:\"Baloo Paaji 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Baloo Tamma 2\";a:3:{s:5:\"label\";s:13:\"Baloo Tamma 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Baloo Tammudu 2\";a:3:{s:5:\"label\";s:15:\"Baloo Tammudu 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Baloo Thambi 2\";a:3:{s:5:\"label\";s:14:\"Baloo Thambi 2\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Balsamiq Sans\";a:3:{s:5:\"label\";s:13:\"Balsamiq Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Balthazar\";a:3:{s:5:\"label\";s:9:\"Balthazar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bangers\";a:3:{s:5:\"label\";s:7:\"Bangers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barlow\";a:3:{s:5:\"label\";s:6:\"Barlow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Barlow Condensed\";a:3:{s:5:\"label\";s:16:\"Barlow Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Barlow Semi Condensed\";a:3:{s:5:\"label\";s:21:\"Barlow Semi Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Barriecito\";a:3:{s:5:\"label\";s:10:\"Barriecito\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Barrio\";a:3:{s:5:\"label\";s:6:\"Barrio\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Basic\";a:3:{s:5:\"label\";s:5:\"Basic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Baskervville\";a:3:{s:5:\"label\";s:12:\"Baskervville\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Battambang\";a:3:{s:5:\"label\";s:10:\"Battambang\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Baumans\";a:3:{s:5:\"label\";s:7:\"Baumans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bayon\";a:3:{s:5:\"label\";s:5:\"Bayon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Be Vietnam\";a:3:{s:5:\"label\";s:10:\"Be Vietnam\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Bebas Neue\";a:3:{s:5:\"label\";s:10:\"Bebas Neue\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Belgrano\";a:3:{s:5:\"label\";s:8:\"Belgrano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Bellefair\";a:3:{s:5:\"label\";s:9:\"Bellefair\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Belleza\";a:3:{s:5:\"label\";s:7:\"Belleza\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Bellota\";a:3:{s:5:\"label\";s:7:\"Bellota\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bellota Text\";a:3:{s:5:\"label\";s:12:\"Bellota Text\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"BenchNine\";a:3:{s:5:\"label\";s:9:\"BenchNine\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Benne\";a:3:{s:5:\"label\";s:5:\"Benne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Bentham\";a:3:{s:5:\"label\";s:7:\"Bentham\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Berkshire Swash\";a:3:{s:5:\"label\";s:15:\"Berkshire Swash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Beth Ellen\";a:3:{s:5:\"label\";s:10:\"Beth Ellen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Bevan\";a:3:{s:5:\"label\";s:5:\"Bevan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Big Shoulders Display\";a:3:{s:5:\"label\";s:21:\"Big Shoulders Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:28:\"Big Shoulders Inline Display\";a:3:{s:5:\"label\";s:28:\"Big Shoulders Inline Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Big Shoulders Inline Text\";a:3:{s:5:\"label\";s:25:\"Big Shoulders Inline Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:29:\"Big Shoulders Stencil Display\";a:3:{s:5:\"label\";s:29:\"Big Shoulders Stencil Display\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:26:\"Big Shoulders Stencil Text\";a:3:{s:5:\"label\";s:26:\"Big Shoulders Stencil Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Big Shoulders Text\";a:3:{s:5:\"label\";s:18:\"Big Shoulders Text\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bigelow Rules\";a:3:{s:5:\"label\";s:13:\"Bigelow Rules\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bigshot One\";a:3:{s:5:\"label\";s:11:\"Bigshot One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Bilbo\";a:3:{s:5:\"label\";s:5:\"Bilbo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Bilbo Swash Caps\";a:3:{s:5:\"label\";s:16:\"Bilbo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"BioRhyme\";a:3:{s:5:\"label\";s:8:\"BioRhyme\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"BioRhyme Expanded\";a:3:{s:5:\"label\";s:17:\"BioRhyme Expanded\";s:8:\"variants\";a:5:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Biryani\";a:3:{s:5:\"label\";s:7:\"Biryani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Bitter\";a:3:{s:5:\"label\";s:6:\"Bitter\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Black And White Picture\";a:3:{s:5:\"label\";s:23:\"Black And White Picture\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Black Han Sans\";a:3:{s:5:\"label\";s:14:\"Black Han Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Black Ops One\";a:3:{s:5:\"label\";s:13:\"Black Ops One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Blinker\";a:3:{s:5:\"label\";s:7:\"Blinker\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Bodoni Moda\";a:3:{s:5:\"label\";s:11:\"Bodoni Moda\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Bokor\";a:3:{s:5:\"label\";s:5:\"Bokor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Bona Nova\";a:3:{s:5:\"label\";s:9:\"Bona Nova\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bonbon\";a:3:{s:5:\"label\";s:6:\"Bonbon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Boogaloo\";a:3:{s:5:\"label\";s:8:\"Boogaloo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Bowlby One\";a:3:{s:5:\"label\";s:10:\"Bowlby One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bowlby One SC\";a:3:{s:5:\"label\";s:13:\"Bowlby One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Brawler\";a:3:{s:5:\"label\";s:7:\"Brawler\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Bree Serif\";a:3:{s:5:\"label\";s:10:\"Bree Serif\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Brygada 1918\";a:3:{s:5:\"label\";s:12:\"Brygada 1918\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Bubblegum Sans\";a:3:{s:5:\"label\";s:14:\"Bubblegum Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Bubbler One\";a:3:{s:5:\"label\";s:11:\"Bubbler One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Buda\";a:3:{s:5:\"label\";s:4:\"Buda\";s:8:\"variants\";a:1:{i:0;s:3:\"300\";}s:8:\"category\";s:7:\"display\";}s:7:\"Buenard\";a:3:{s:5:\"label\";s:7:\"Buenard\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Bungee\";a:3:{s:5:\"label\";s:6:\"Bungee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Bungee Hairline\";a:3:{s:5:\"label\";s:15:\"Bungee Hairline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Bungee Inline\";a:3:{s:5:\"label\";s:13:\"Bungee Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Bungee Outline\";a:3:{s:5:\"label\";s:14:\"Bungee Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Bungee Shade\";a:3:{s:5:\"label\";s:12:\"Bungee Shade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Butcherman\";a:3:{s:5:\"label\";s:10:\"Butcherman\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Butterfly Kids\";a:3:{s:5:\"label\";s:14:\"Butterfly Kids\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Cabin\";a:3:{s:5:\"label\";s:5:\"Cabin\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Cabin Condensed\";a:3:{s:5:\"label\";s:15:\"Cabin Condensed\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Cabin Sketch\";a:3:{s:5:\"label\";s:12:\"Cabin Sketch\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Caesar Dressing\";a:3:{s:5:\"label\";s:15:\"Caesar Dressing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Cagliostro\";a:3:{s:5:\"label\";s:10:\"Cagliostro\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cairo\";a:3:{s:5:\"label\";s:5:\"Cairo\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Caladea\";a:3:{s:5:\"label\";s:7:\"Caladea\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Calistoga\";a:3:{s:5:\"label\";s:9:\"Calistoga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Calligraffitti\";a:3:{s:5:\"label\";s:14:\"Calligraffitti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Cambay\";a:3:{s:5:\"label\";s:6:\"Cambay\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cambo\";a:3:{s:5:\"label\";s:5:\"Cambo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Candal\";a:3:{s:5:\"label\";s:6:\"Candal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cantarell\";a:3:{s:5:\"label\";s:9:\"Cantarell\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Cantata One\";a:3:{s:5:\"label\";s:11:\"Cantata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cantora One\";a:3:{s:5:\"label\";s:11:\"Cantora One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Capriola\";a:3:{s:5:\"label\";s:8:\"Capriola\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Cardo\";a:3:{s:5:\"label\";s:5:\"Cardo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Carme\";a:3:{s:5:\"label\";s:5:\"Carme\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Carrois Gothic\";a:3:{s:5:\"label\";s:14:\"Carrois Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Carrois Gothic SC\";a:3:{s:5:\"label\";s:17:\"Carrois Gothic SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Carter One\";a:3:{s:5:\"label\";s:10:\"Carter One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Castoro\";a:3:{s:5:\"label\";s:7:\"Castoro\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Catamaran\";a:3:{s:5:\"label\";s:9:\"Catamaran\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Caudex\";a:3:{s:5:\"label\";s:6:\"Caudex\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Caveat\";a:3:{s:5:\"label\";s:6:\"Caveat\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Caveat Brush\";a:3:{s:5:\"label\";s:12:\"Caveat Brush\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:18:\"Cedarville Cursive\";a:3:{s:5:\"label\";s:18:\"Cedarville Cursive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Ceviche One\";a:3:{s:5:\"label\";s:11:\"Ceviche One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Chakra Petch\";a:3:{s:5:\"label\";s:12:\"Chakra Petch\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Changa\";a:3:{s:5:\"label\";s:6:\"Changa\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Changa One\";a:3:{s:5:\"label\";s:10:\"Changa One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chango\";a:3:{s:5:\"label\";s:6:\"Chango\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Charm\";a:3:{s:5:\"label\";s:5:\"Charm\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Charmonman\";a:3:{s:5:\"label\";s:10:\"Charmonman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Chathura\";a:3:{s:5:\"label\";s:8:\"Chathura\";s:8:\"variants\";a:5:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Chau Philomene One\";a:3:{s:5:\"label\";s:18:\"Chau Philomene One\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Chela One\";a:3:{s:5:\"label\";s:9:\"Chela One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Chelsea Market\";a:3:{s:5:\"label\";s:14:\"Chelsea Market\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chenla\";a:3:{s:5:\"label\";s:6:\"Chenla\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Cherry Cream Soda\";a:3:{s:5:\"label\";s:17:\"Cherry Cream Soda\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Cherry Swash\";a:3:{s:5:\"label\";s:12:\"Cherry Swash\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Chewy\";a:3:{s:5:\"label\";s:5:\"Chewy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Chicle\";a:3:{s:5:\"label\";s:6:\"Chicle\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Chilanka\";a:3:{s:5:\"label\";s:8:\"Chilanka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Chivo\";a:3:{s:5:\"label\";s:5:\"Chivo\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Chonburi\";a:3:{s:5:\"label\";s:8:\"Chonburi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cinzel\";a:3:{s:5:\"label\";s:6:\"Cinzel\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cinzel Decorative\";a:3:{s:5:\"label\";s:17:\"Cinzel Decorative\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Clicker Script\";a:3:{s:5:\"label\";s:14:\"Clicker Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Coda\";a:3:{s:5:\"label\";s:4:\"Coda\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Coda Caption\";a:3:{s:5:\"label\";s:12:\"Coda Caption\";s:8:\"variants\";a:1:{i:0;s:3:\"800\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Codystar\";a:3:{s:5:\"label\";s:8:\"Codystar\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Coiny\";a:3:{s:5:\"label\";s:5:\"Coiny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Combo\";a:3:{s:5:\"label\";s:5:\"Combo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Comfortaa\";a:3:{s:5:\"label\";s:9:\"Comfortaa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Comic Neue\";a:3:{s:5:\"label\";s:10:\"Comic Neue\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Coming Soon\";a:3:{s:5:\"label\";s:11:\"Coming Soon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Commissioner\";a:3:{s:5:\"label\";s:12:\"Commissioner\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Concert One\";a:3:{s:5:\"label\";s:11:\"Concert One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Condiment\";a:3:{s:5:\"label\";s:9:\"Condiment\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Content\";a:3:{s:5:\"label\";s:7:\"Content\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Contrail One\";a:3:{s:5:\"label\";s:12:\"Contrail One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Convergence\";a:3:{s:5:\"label\";s:11:\"Convergence\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Cookie\";a:3:{s:5:\"label\";s:6:\"Cookie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Copse\";a:3:{s:5:\"label\";s:5:\"Copse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Corben\";a:3:{s:5:\"label\";s:6:\"Corben\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Cormorant\";a:3:{s:5:\"label\";s:9:\"Cormorant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Cormorant Garamond\";a:3:{s:5:\"label\";s:18:\"Cormorant Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Cormorant Infant\";a:3:{s:5:\"label\";s:16:\"Cormorant Infant\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Cormorant SC\";a:3:{s:5:\"label\";s:12:\"Cormorant SC\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Unicase\";a:3:{s:5:\"label\";s:17:\"Cormorant Unicase\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Cormorant Upright\";a:3:{s:5:\"label\";s:17:\"Cormorant Upright\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Courgette\";a:3:{s:5:\"label\";s:9:\"Courgette\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Courier Prime\";a:3:{s:5:\"label\";s:13:\"Courier Prime\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"Cousine\";a:3:{s:5:\"label\";s:7:\"Cousine\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:8:\"Coustard\";a:3:{s:5:\"label\";s:8:\"Coustard\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Covered By Your Grace\";a:3:{s:5:\"label\";s:21:\"Covered By Your Grace\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Crafty Girls\";a:3:{s:5:\"label\";s:12:\"Crafty Girls\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Creepster\";a:3:{s:5:\"label\";s:9:\"Creepster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Crete Round\";a:3:{s:5:\"label\";s:11:\"Crete Round\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Crimson Pro\";a:3:{s:5:\"label\";s:11:\"Crimson Pro\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Crimson Text\";a:3:{s:5:\"label\";s:12:\"Crimson Text\";s:8:\"variants\";a:6:{i:0;s:3:\"600\";i:1;s:9:\"600italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Croissant One\";a:3:{s:5:\"label\";s:13:\"Croissant One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Crushed\";a:3:{s:5:\"label\";s:7:\"Crushed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cuprum\";a:3:{s:5:\"label\";s:6:\"Cuprum\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Cute Font\";a:3:{s:5:\"label\";s:9:\"Cute Font\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Cutive\";a:3:{s:5:\"label\";s:6:\"Cutive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Cutive Mono\";a:3:{s:5:\"label\";s:11:\"Cutive Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Mono\";a:3:{s:5:\"label\";s:7:\"DM Mono\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"DM Sans\";a:3:{s:5:\"label\";s:7:\"DM Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"DM Serif Display\";a:3:{s:5:\"label\";s:16:\"DM Serif Display\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"DM Serif Text\";a:3:{s:5:\"label\";s:13:\"DM Serif Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Damion\";a:3:{s:5:\"label\";s:6:\"Damion\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Dancing Script\";a:3:{s:5:\"label\";s:14:\"Dancing Script\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Dangrek\";a:3:{s:5:\"label\";s:7:\"Dangrek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Darker Grotesque\";a:3:{s:5:\"label\";s:16:\"Darker Grotesque\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"David Libre\";a:3:{s:5:\"label\";s:11:\"David Libre\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Dawning of a New Day\";a:3:{s:5:\"label\";s:20:\"Dawning of a New Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Days One\";a:3:{s:5:\"label\";s:8:\"Days One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dekko\";a:3:{s:5:\"label\";s:5:\"Dekko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Dela Gothic One\";a:3:{s:5:\"label\";s:15:\"Dela Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Delius\";a:3:{s:5:\"label\";s:6:\"Delius\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:17:\"Delius Swash Caps\";a:3:{s:5:\"label\";s:17:\"Delius Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Delius Unicase\";a:3:{s:5:\"label\";s:14:\"Delius Unicase\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Della Respira\";a:3:{s:5:\"label\";s:13:\"Della Respira\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Denk One\";a:3:{s:5:\"label\";s:8:\"Denk One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Devonshire\";a:3:{s:5:\"label\";s:10:\"Devonshire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Dhurjati\";a:3:{s:5:\"label\";s:8:\"Dhurjati\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Didact Gothic\";a:3:{s:5:\"label\";s:13:\"Didact Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Diplomata\";a:3:{s:5:\"label\";s:9:\"Diplomata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Diplomata SC\";a:3:{s:5:\"label\";s:12:\"Diplomata SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Do Hyeon\";a:3:{s:5:\"label\";s:8:\"Do Hyeon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dokdo\";a:3:{s:5:\"label\";s:5:\"Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Domine\";a:3:{s:5:\"label\";s:6:\"Domine\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Donegal One\";a:3:{s:5:\"label\";s:11:\"Donegal One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Doppio One\";a:3:{s:5:\"label\";s:10:\"Doppio One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dorsa\";a:3:{s:5:\"label\";s:5:\"Dorsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Dosis\";a:3:{s:5:\"label\";s:5:\"Dosis\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"DotGothic16\";a:3:{s:5:\"label\";s:11:\"DotGothic16\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Dr Sugiyama\";a:3:{s:5:\"label\";s:11:\"Dr Sugiyama\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Duru Sans\";a:3:{s:5:\"label\";s:9:\"Duru Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Dynalight\";a:3:{s:5:\"label\";s:9:\"Dynalight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"EB Garamond\";a:3:{s:5:\"label\";s:11:\"EB Garamond\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Eagle Lake\";a:3:{s:5:\"label\";s:10:\"Eagle Lake\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"East Sea Dokdo\";a:3:{s:5:\"label\";s:14:\"East Sea Dokdo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Eater\";a:3:{s:5:\"label\";s:5:\"Eater\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Economica\";a:3:{s:5:\"label\";s:9:\"Economica\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Eczar\";a:3:{s:5:\"label\";s:5:\"Eczar\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"El Messiri\";a:3:{s:5:\"label\";s:10:\"El Messiri\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Electrolize\";a:3:{s:5:\"label\";s:11:\"Electrolize\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Elsie\";a:3:{s:5:\"label\";s:5:\"Elsie\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Elsie Swash Caps\";a:3:{s:5:\"label\";s:16:\"Elsie Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"900\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Emblema One\";a:3:{s:5:\"label\";s:11:\"Emblema One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Emilys Candy\";a:3:{s:5:\"label\";s:12:\"Emilys Candy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Encode Sans\";a:3:{s:5:\"label\";s:11:\"Encode Sans\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Encode Sans Condensed\";a:3:{s:5:\"label\";s:21:\"Encode Sans Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Encode Sans Expanded\";a:3:{s:5:\"label\";s:20:\"Encode Sans Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Encode Sans SC\";a:3:{s:5:\"label\";s:14:\"Encode Sans SC\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:26:\"Encode Sans Semi Condensed\";a:3:{s:5:\"label\";s:26:\"Encode Sans Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Encode Sans Semi Expanded\";a:3:{s:5:\"label\";s:25:\"Encode Sans Semi Expanded\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Engagement\";a:3:{s:5:\"label\";s:10:\"Engagement\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Englebert\";a:3:{s:5:\"label\";s:9:\"Englebert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Enriqueta\";a:3:{s:5:\"label\";s:9:\"Enriqueta\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Epilogue\";a:3:{s:5:\"label\";s:8:\"Epilogue\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Erica One\";a:3:{s:5:\"label\";s:9:\"Erica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Esteban\";a:3:{s:5:\"label\";s:7:\"Esteban\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Euphoria Script\";a:3:{s:5:\"label\";s:15:\"Euphoria Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ewert\";a:3:{s:5:\"label\";s:5:\"Ewert\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Exo\";a:3:{s:5:\"label\";s:3:\"Exo\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Exo 2\";a:3:{s:5:\"label\";s:5:\"Exo 2\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Expletus Sans\";a:3:{s:5:\"label\";s:13:\"Expletus Sans\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Fahkwang\";a:3:{s:5:\"label\";s:8:\"Fahkwang\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Fanwood Text\";a:3:{s:5:\"label\";s:12:\"Fanwood Text\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Farro\";a:3:{s:5:\"label\";s:5:\"Farro\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Farsan\";a:3:{s:5:\"label\";s:6:\"Farsan\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fascinate\";a:3:{s:5:\"label\";s:9:\"Fascinate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Fascinate Inline\";a:3:{s:5:\"label\";s:16:\"Fascinate Inline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Faster One\";a:3:{s:5:\"label\";s:10:\"Faster One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Fasthand\";a:3:{s:5:\"label\";s:8:\"Fasthand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Fauna One\";a:3:{s:5:\"label\";s:9:\"Fauna One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Faustina\";a:3:{s:5:\"label\";s:8:\"Faustina\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Federant\";a:3:{s:5:\"label\";s:8:\"Federant\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Federo\";a:3:{s:5:\"label\";s:6:\"Federo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Felipa\";a:3:{s:5:\"label\";s:6:\"Felipa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Fenix\";a:3:{s:5:\"label\";s:5:\"Fenix\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Festive\";a:3:{s:5:\"label\";s:7:\"Festive\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Finger Paint\";a:3:{s:5:\"label\";s:12:\"Finger Paint\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fira Code\";a:3:{s:5:\"label\";s:9:\"Fira Code\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Mono\";a:3:{s:5:\"label\";s:9:\"Fira Mono\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Fira Sans\";a:3:{s:5:\"label\";s:9:\"Fira Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Fira Sans Condensed\";a:3:{s:5:\"label\";s:19:\"Fira Sans Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:25:\"Fira Sans Extra Condensed\";a:3:{s:5:\"label\";s:25:\"Fira Sans Extra Condensed\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Fjalla One\";a:3:{s:5:\"label\";s:10:\"Fjalla One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Fjord One\";a:3:{s:5:\"label\";s:9:\"Fjord One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Flamenco\";a:3:{s:5:\"label\";s:8:\"Flamenco\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Flavors\";a:3:{s:5:\"label\";s:7:\"Flavors\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Fondamento\";a:3:{s:5:\"label\";s:10:\"Fondamento\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Fontdiner Swanky\";a:3:{s:5:\"label\";s:16:\"Fontdiner Swanky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Forum\";a:3:{s:5:\"label\";s:5:\"Forum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Francois One\";a:3:{s:5:\"label\";s:12:\"Francois One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Frank Ruhl Libre\";a:3:{s:5:\"label\";s:16:\"Frank Ruhl Libre\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"900\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Fraunces\";a:3:{s:5:\"label\";s:8:\"Fraunces\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Freckle Face\";a:3:{s:5:\"label\";s:12:\"Freckle Face\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Fredericka the Great\";a:3:{s:5:\"label\";s:20:\"Fredericka the Great\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Fredoka One\";a:3:{s:5:\"label\";s:11:\"Fredoka One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Freehand\";a:3:{s:5:\"label\";s:8:\"Freehand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Fresca\";a:3:{s:5:\"label\";s:6:\"Fresca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Frijole\";a:3:{s:5:\"label\";s:7:\"Frijole\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fruktur\";a:3:{s:5:\"label\";s:7:\"Fruktur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Fugaz One\";a:3:{s:5:\"label\";s:9:\"Fugaz One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Fuggles\";a:3:{s:5:\"label\";s:7:\"Fuggles\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"GFS Didot\";a:3:{s:5:\"label\";s:9:\"GFS Didot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"GFS Neohellenic\";a:3:{s:5:\"label\";s:15:\"GFS Neohellenic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Gabriela\";a:3:{s:5:\"label\";s:8:\"Gabriela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Gaegu\";a:3:{s:5:\"label\";s:5:\"Gaegu\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Gafata\";a:3:{s:5:\"label\";s:6:\"Gafata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Galada\";a:3:{s:5:\"label\";s:6:\"Galada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Galdeano\";a:3:{s:5:\"label\";s:8:\"Galdeano\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Galindo\";a:3:{s:5:\"label\";s:7:\"Galindo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gamja Flower\";a:3:{s:5:\"label\";s:12:\"Gamja Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Gayathri\";a:3:{s:5:\"label\";s:8:\"Gayathri\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Gelasio\";a:3:{s:5:\"label\";s:7:\"Gelasio\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Gentium Basic\";a:3:{s:5:\"label\";s:13:\"Gentium Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Gentium Book Basic\";a:3:{s:5:\"label\";s:18:\"Gentium Book Basic\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:3:\"Geo\";a:3:{s:5:\"label\";s:3:\"Geo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Geostar\";a:3:{s:5:\"label\";s:7:\"Geostar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Geostar Fill\";a:3:{s:5:\"label\";s:12:\"Geostar Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Germania One\";a:3:{s:5:\"label\";s:12:\"Germania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gidugu\";a:3:{s:5:\"label\";s:6:\"Gidugu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Gilda Display\";a:3:{s:5:\"label\";s:13:\"Gilda Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Girassol\";a:3:{s:5:\"label\";s:8:\"Girassol\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Give You Glory\";a:3:{s:5:\"label\";s:14:\"Give You Glory\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Glass Antiqua\";a:3:{s:5:\"label\";s:13:\"Glass Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Glegoo\";a:3:{s:5:\"label\";s:6:\"Glegoo\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Gloria Hallelujah\";a:3:{s:5:\"label\";s:17:\"Gloria Hallelujah\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Goblin One\";a:3:{s:5:\"label\";s:10:\"Goblin One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Gochi Hand\";a:3:{s:5:\"label\";s:10:\"Gochi Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Goldman\";a:3:{s:5:\"label\";s:7:\"Goldman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Gorditas\";a:3:{s:5:\"label\";s:8:\"Gorditas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Gothic A1\";a:3:{s:5:\"label\";s:9:\"Gothic A1\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gotu\";a:3:{s:5:\"label\";s:4:\"Gotu\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Goudy Bookletter 1911\";a:3:{s:5:\"label\";s:21:\"Goudy Bookletter 1911\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Graduate\";a:3:{s:5:\"label\";s:8:\"Graduate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Grand Hotel\";a:3:{s:5:\"label\";s:11:\"Grand Hotel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Grandstander\";a:3:{s:5:\"label\";s:12:\"Grandstander\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Gravitas One\";a:3:{s:5:\"label\";s:12:\"Gravitas One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Great Vibes\";a:3:{s:5:\"label\";s:11:\"Great Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Grenze\";a:3:{s:5:\"label\";s:6:\"Grenze\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Grenze Gotisch\";a:3:{s:5:\"label\";s:14:\"Grenze Gotisch\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Griffy\";a:3:{s:5:\"label\";s:6:\"Griffy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gruppo\";a:3:{s:5:\"label\";s:6:\"Gruppo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Gudea\";a:3:{s:5:\"label\";s:5:\"Gudea\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Gugi\";a:3:{s:5:\"label\";s:4:\"Gugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Gupter\";a:3:{s:5:\"label\";s:6:\"Gupter\";s:8:\"variants\";a:3:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Gurajada\";a:3:{s:5:\"label\";s:8:\"Gurajada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Habibi\";a:3:{s:5:\"label\";s:6:\"Habibi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Hachi Maru Pop\";a:3:{s:5:\"label\";s:14:\"Hachi Maru Pop\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Halant\";a:3:{s:5:\"label\";s:6:\"Halant\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Hammersmith One\";a:3:{s:5:\"label\";s:15:\"Hammersmith One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Hanalei\";a:3:{s:5:\"label\";s:7:\"Hanalei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Hanalei Fill\";a:3:{s:5:\"label\";s:12:\"Hanalei Fill\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Handlee\";a:3:{s:5:\"label\";s:7:\"Handlee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Hanuman\";a:3:{s:5:\"label\";s:7:\"Hanuman\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Happy Monkey\";a:3:{s:5:\"label\";s:12:\"Happy Monkey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Harmattan\";a:3:{s:5:\"label\";s:9:\"Harmattan\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Headland One\";a:3:{s:5:\"label\";s:12:\"Headland One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Heebo\";a:3:{s:5:\"label\";s:5:\"Heebo\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Henny Penny\";a:3:{s:5:\"label\";s:11:\"Henny Penny\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Hepta Slab\";a:3:{s:5:\"label\";s:10:\"Hepta Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Herr Von Muellerhoff\";a:3:{s:5:\"label\";s:20:\"Herr Von Muellerhoff\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Hi Melody\";a:3:{s:5:\"label\";s:9:\"Hi Melody\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Hind\";a:3:{s:5:\"label\";s:4:\"Hind\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Hind Guntur\";a:3:{s:5:\"label\";s:11:\"Hind Guntur\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Hind Madurai\";a:3:{s:5:\"label\";s:12:\"Hind Madurai\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Siliguri\";a:3:{s:5:\"label\";s:13:\"Hind Siliguri\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Hind Vadodara\";a:3:{s:5:\"label\";s:13:\"Hind Vadodara\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Holtwood One SC\";a:3:{s:5:\"label\";s:15:\"Holtwood One SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Homemade Apple\";a:3:{s:5:\"label\";s:14:\"Homemade Apple\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Homenaje\";a:3:{s:5:\"label\";s:8:\"Homenaje\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"IBM Plex Mono\";a:3:{s:5:\"label\";s:13:\"IBM Plex Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:13:\"IBM Plex Sans\";a:3:{s:5:\"label\";s:13:\"IBM Plex Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"IBM Plex Sans Condensed\";a:3:{s:5:\"label\";s:23:\"IBM Plex Sans Condensed\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"IBM Plex Serif\";a:3:{s:5:\"label\";s:14:\"IBM Plex Serif\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell DW Pica\";a:3:{s:5:\"label\";s:15:\"IM Fell DW Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell DW Pica SC\";a:3:{s:5:\"label\";s:18:\"IM Fell DW Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"IM Fell Double Pica\";a:3:{s:5:\"label\";s:19:\"IM Fell Double Pica\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:22:\"IM Fell Double Pica SC\";a:3:{s:5:\"label\";s:22:\"IM Fell Double Pica SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"IM Fell English\";a:3:{s:5:\"label\";s:15:\"IM Fell English\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"IM Fell English SC\";a:3:{s:5:\"label\";s:18:\"IM Fell English SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell French Canon\";a:3:{s:5:\"label\";s:20:\"IM Fell French Canon\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell French Canon SC\";a:3:{s:5:\"label\";s:23:\"IM Fell French Canon SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"IM Fell Great Primer\";a:3:{s:5:\"label\";s:20:\"IM Fell Great Primer\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"IM Fell Great Primer SC\";a:3:{s:5:\"label\";s:23:\"IM Fell Great Primer SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Ibarra Real Nova\";a:3:{s:5:\"label\";s:16:\"Ibarra Real Nova\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Iceberg\";a:3:{s:5:\"label\";s:7:\"Iceberg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Iceland\";a:3:{s:5:\"label\";s:7:\"Iceland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Imbue\";a:3:{s:5:\"label\";s:5:\"Imbue\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Imprima\";a:3:{s:5:\"label\";s:7:\"Imprima\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inconsolata\";a:3:{s:5:\"label\";s:11:\"Inconsolata\";s:8:\"variants\";a:8:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:3:\"900\";i:7;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Inder\";a:3:{s:5:\"label\";s:5:\"Inder\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Indie Flower\";a:3:{s:5:\"label\";s:12:\"Indie Flower\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Inika\";a:3:{s:5:\"label\";s:5:\"Inika\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Inknut Antiqua\";a:3:{s:5:\"label\";s:14:\"Inknut Antiqua\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Inria Sans\";a:3:{s:5:\"label\";s:10:\"Inria Sans\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Inria Serif\";a:3:{s:5:\"label\";s:11:\"Inria Serif\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Inter\";a:3:{s:5:\"label\";s:5:\"Inter\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Irish Grover\";a:3:{s:5:\"label\";s:12:\"Irish Grover\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Istok Web\";a:3:{s:5:\"label\";s:9:\"Istok Web\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Italiana\";a:3:{s:5:\"label\";s:8:\"Italiana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Italianno\";a:3:{s:5:\"label\";s:9:\"Italianno\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Itim\";a:3:{s:5:\"label\";s:4:\"Itim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Jacques Francois\";a:3:{s:5:\"label\";s:16:\"Jacques Francois\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:23:\"Jacques Francois Shadow\";a:3:{s:5:\"label\";s:23:\"Jacques Francois Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Jaldi\";a:3:{s:5:\"label\";s:5:\"Jaldi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"JetBrains Mono\";a:3:{s:5:\"label\";s:14:\"JetBrains Mono\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Jim Nightshade\";a:3:{s:5:\"label\";s:14:\"Jim Nightshade\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Jockey One\";a:3:{s:5:\"label\";s:10:\"Jockey One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Jolly Lodger\";a:3:{s:5:\"label\";s:12:\"Jolly Lodger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Jomhuria\";a:3:{s:5:\"label\";s:8:\"Jomhuria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Jomolhari\";a:3:{s:5:\"label\";s:9:\"Jomolhari\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Josefin Sans\";a:3:{s:5:\"label\";s:12:\"Josefin Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Josefin Slab\";a:3:{s:5:\"label\";s:12:\"Josefin Slab\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jost\";a:3:{s:5:\"label\";s:4:\"Jost\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Joti One\";a:3:{s:5:\"label\";s:8:\"Joti One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"Jua\";a:3:{s:5:\"label\";s:3:\"Jua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Judson\";a:3:{s:5:\"label\";s:6:\"Judson\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Julee\";a:3:{s:5:\"label\";s:5:\"Julee\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Julius Sans One\";a:3:{s:5:\"label\";s:15:\"Julius Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Junge\";a:3:{s:5:\"label\";s:5:\"Junge\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Jura\";a:3:{s:5:\"label\";s:4:\"Jura\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Just Another Hand\";a:3:{s:5:\"label\";s:17:\"Just Another Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:23:\"Just Me Again Down Here\";a:3:{s:5:\"label\";s:23:\"Just Me Again Down Here\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"K2D\";a:3:{s:5:\"label\";s:3:\"K2D\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kadwa\";a:3:{s:5:\"label\";s:5:\"Kadwa\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kalam\";a:3:{s:5:\"label\";s:5:\"Kalam\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Kameron\";a:3:{s:5:\"label\";s:7:\"Kameron\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Kanit\";a:3:{s:5:\"label\";s:5:\"Kanit\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kantumruy\";a:3:{s:5:\"label\";s:9:\"Kantumruy\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Karantina\";a:3:{s:5:\"label\";s:9:\"Karantina\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Karla\";a:3:{s:5:\"label\";s:5:\"Karla\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Karma\";a:3:{s:5:\"label\";s:5:\"Karma\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Katibeh\";a:3:{s:5:\"label\";s:7:\"Katibeh\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Kaushan Script\";a:3:{s:5:\"label\";s:14:\"Kaushan Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Kavivanar\";a:3:{s:5:\"label\";s:9:\"Kavivanar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Kavoon\";a:3:{s:5:\"label\";s:6:\"Kavoon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kdam Thmor\";a:3:{s:5:\"label\";s:10:\"Kdam Thmor\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Keania One\";a:3:{s:5:\"label\";s:10:\"Keania One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kelly Slab\";a:3:{s:5:\"label\";s:10:\"Kelly Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kenia\";a:3:{s:5:\"label\";s:5:\"Kenia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khand\";a:3:{s:5:\"label\";s:5:\"Khand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Khmer\";a:3:{s:5:\"label\";s:5:\"Khmer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Khula\";a:3:{s:5:\"label\";s:5:\"Khula\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Kirang Haerang\";a:3:{s:5:\"label\";s:14:\"Kirang Haerang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Kite One\";a:3:{s:5:\"label\";s:8:\"Kite One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kiwi Maru\";a:3:{s:5:\"label\";s:9:\"Kiwi Maru\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Knewave\";a:3:{s:5:\"label\";s:7:\"Knewave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"KoHo\";a:3:{s:5:\"label\";s:4:\"KoHo\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kodchasan\";a:3:{s:5:\"label\";s:9:\"Kodchasan\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Kosugi\";a:3:{s:5:\"label\";s:6:\"Kosugi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Kosugi Maru\";a:3:{s:5:\"label\";s:11:\"Kosugi Maru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kotta One\";a:3:{s:5:\"label\";s:9:\"Kotta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Koulen\";a:3:{s:5:\"label\";s:6:\"Koulen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Kranky\";a:3:{s:5:\"label\";s:6:\"Kranky\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Kreon\";a:3:{s:5:\"label\";s:5:\"Kreon\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Kristi\";a:3:{s:5:\"label\";s:6:\"Kristi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Krona One\";a:3:{s:5:\"label\";s:9:\"Krona One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Krub\";a:3:{s:5:\"label\";s:4:\"Krub\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Kufam\";a:3:{s:5:\"label\";s:5:\"Kufam\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Kulim Park\";a:3:{s:5:\"label\";s:10:\"Kulim Park\";s:8:\"variants\";a:10:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Kumar One\";a:3:{s:5:\"label\";s:9:\"Kumar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Kumar One Outline\";a:3:{s:5:\"label\";s:17:\"Kumar One Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Kumbh Sans\";a:3:{s:5:\"label\";s:10:\"Kumbh Sans\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Kurale\";a:3:{s:5:\"label\";s:6:\"Kurale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"La Belle Aurore\";a:3:{s:5:\"label\";s:15:\"La Belle Aurore\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Lacquer\";a:3:{s:5:\"label\";s:7:\"Lacquer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Laila\";a:3:{s:5:\"label\";s:5:\"Laila\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lakki Reddy\";a:3:{s:5:\"label\";s:11:\"Lakki Reddy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Lalezar\";a:3:{s:5:\"label\";s:7:\"Lalezar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lancelot\";a:3:{s:5:\"label\";s:8:\"Lancelot\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Langar\";a:3:{s:5:\"label\";s:6:\"Langar\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lateef\";a:3:{s:5:\"label\";s:6:\"Lateef\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Lato\";a:3:{s:5:\"label\";s:4:\"Lato\";s:8:\"variants\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"900\";i:7;s:9:\"900italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"League Script\";a:3:{s:5:\"label\";s:13:\"League Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Leckerli One\";a:3:{s:5:\"label\";s:12:\"Leckerli One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ledger\";a:3:{s:5:\"label\";s:6:\"Ledger\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Lekton\";a:3:{s:5:\"label\";s:6:\"Lekton\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Lemon\";a:3:{s:5:\"label\";s:5:\"Lemon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lemonada\";a:3:{s:5:\"label\";s:8:\"Lemonada\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Lexend\";a:3:{s:5:\"label\";s:6:\"Lexend\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Deca\";a:3:{s:5:\"label\";s:11:\"Lexend Deca\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Lexend Exa\";a:3:{s:5:\"label\";s:10:\"Lexend Exa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Giga\";a:3:{s:5:\"label\";s:11:\"Lexend Giga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Mega\";a:3:{s:5:\"label\";s:11:\"Lexend Mega\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Peta\";a:3:{s:5:\"label\";s:11:\"Lexend Peta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Lexend Tera\";a:3:{s:5:\"label\";s:11:\"Lexend Tera\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Lexend Zetta\";a:3:{s:5:\"label\";s:12:\"Lexend Zetta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Libre Barcode 128\";a:3:{s:5:\"label\";s:17:\"Libre Barcode 128\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Libre Barcode 128 Text\";a:3:{s:5:\"label\";s:22:\"Libre Barcode 128 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Libre Barcode 39\";a:3:{s:5:\"label\";s:16:\"Libre Barcode 39\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:25:\"Libre Barcode 39 Extended\";a:3:{s:5:\"label\";s:25:\"Libre Barcode 39 Extended\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:30:\"Libre Barcode 39 Extended Text\";a:3:{s:5:\"label\";s:30:\"Libre Barcode 39 Extended Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"Libre Barcode 39 Text\";a:3:{s:5:\"label\";s:21:\"Libre Barcode 39 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:24:\"Libre Barcode EAN13 Text\";a:3:{s:5:\"label\";s:24:\"Libre Barcode EAN13 Text\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Libre Baskerville\";a:3:{s:5:\"label\";s:17:\"Libre Baskerville\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Libre Caslon Display\";a:3:{s:5:\"label\";s:20:\"Libre Caslon Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Libre Caslon Text\";a:3:{s:5:\"label\";s:17:\"Libre Caslon Text\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Libre Franklin\";a:3:{s:5:\"label\";s:14:\"Libre Franklin\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Life Savers\";a:3:{s:5:\"label\";s:11:\"Life Savers\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Lilita One\";a:3:{s:5:\"label\";s:10:\"Lilita One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Lily Script One\";a:3:{s:5:\"label\";s:15:\"Lily Script One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Limelight\";a:3:{s:5:\"label\";s:9:\"Limelight\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Linden Hill\";a:3:{s:5:\"label\";s:11:\"Linden Hill\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Literata\";a:3:{s:5:\"label\";s:8:\"Literata\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Liu Jian Mao Cao\";a:3:{s:5:\"label\";s:16:\"Liu Jian Mao Cao\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Livvic\";a:3:{s:5:\"label\";s:6:\"Livvic\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Lobster\";a:3:{s:5:\"label\";s:7:\"Lobster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Lobster Two\";a:3:{s:5:\"label\";s:11:\"Lobster Two\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Londrina Outline\";a:3:{s:5:\"label\";s:16:\"Londrina Outline\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Shadow\";a:3:{s:5:\"label\";s:15:\"Londrina Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Londrina Sketch\";a:3:{s:5:\"label\";s:15:\"Londrina Sketch\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Londrina Solid\";a:3:{s:5:\"label\";s:14:\"Londrina Solid\";s:8:\"variants\";a:4:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Long Cang\";a:3:{s:5:\"label\";s:9:\"Long Cang\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Lora\";a:3:{s:5:\"label\";s:4:\"Lora\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:21:\"Love Ya Like A Sister\";a:3:{s:5:\"label\";s:21:\"Love Ya Like A Sister\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:17:\"Loved by the King\";a:3:{s:5:\"label\";s:17:\"Loved by the King\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Lovers Quarrel\";a:3:{s:5:\"label\";s:14:\"Lovers Quarrel\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Luckiest Guy\";a:3:{s:5:\"label\";s:12:\"Luckiest Guy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Lusitana\";a:3:{s:5:\"label\";s:8:\"Lusitana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Lustria\";a:3:{s:5:\"label\";s:7:\"Lustria\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"M PLUS 1p\";a:3:{s:5:\"label\";s:9:\"M PLUS 1p\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"M PLUS Rounded 1c\";a:3:{s:5:\"label\";s:17:\"M PLUS Rounded 1c\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Ma Shan Zheng\";a:3:{s:5:\"label\";s:13:\"Ma Shan Zheng\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Macondo\";a:3:{s:5:\"label\";s:7:\"Macondo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Macondo Swash Caps\";a:3:{s:5:\"label\";s:18:\"Macondo Swash Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mada\";a:3:{s:5:\"label\";s:4:\"Mada\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Magra\";a:3:{s:5:\"label\";s:5:\"Magra\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Maiden Orange\";a:3:{s:5:\"label\";s:13:\"Maiden Orange\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Maitree\";a:3:{s:5:\"label\";s:7:\"Maitree\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Major Mono Display\";a:3:{s:5:\"label\";s:18:\"Major Mono Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:4:\"Mako\";a:3:{s:5:\"label\";s:4:\"Mako\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mali\";a:3:{s:5:\"label\";s:4:\"Mali\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mallanna\";a:3:{s:5:\"label\";s:8:\"Mallanna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Mandali\";a:3:{s:5:\"label\";s:7:\"Mandali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manjari\";a:3:{s:5:\"label\";s:7:\"Manjari\";s:8:\"variants\";a:3:{i:0;s:3:\"100\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Manrope\";a:3:{s:5:\"label\";s:7:\"Manrope\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Mansalva\";a:3:{s:5:\"label\";s:8:\"Mansalva\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Manuale\";a:3:{s:5:\"label\";s:7:\"Manuale\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marcellus\";a:3:{s:5:\"label\";s:9:\"Marcellus\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marcellus SC\";a:3:{s:5:\"label\";s:12:\"Marcellus SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Marck Script\";a:3:{s:5:\"label\";s:12:\"Marck Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Margarine\";a:3:{s:5:\"label\";s:9:\"Margarine\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Markazi Text\";a:3:{s:5:\"label\";s:12:\"Markazi Text\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Marko One\";a:3:{s:5:\"label\";s:9:\"Marko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Marmelad\";a:3:{s:5:\"label\";s:8:\"Marmelad\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Martel\";a:3:{s:5:\"label\";s:6:\"Martel\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Martel Sans\";a:3:{s:5:\"label\";s:11:\"Martel Sans\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Marvel\";a:3:{s:5:\"label\";s:6:\"Marvel\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Mate\";a:3:{s:5:\"label\";s:4:\"Mate\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Mate SC\";a:3:{s:5:\"label\";s:7:\"Mate SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Maven Pro\";a:3:{s:5:\"label\";s:9:\"Maven Pro\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"McLaren\";a:3:{s:5:\"label\";s:7:\"McLaren\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Meddon\";a:3:{s:5:\"label\";s:6:\"Meddon\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"MedievalSharp\";a:3:{s:5:\"label\";s:13:\"MedievalSharp\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Medula One\";a:3:{s:5:\"label\";s:10:\"Medula One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Meera Inimai\";a:3:{s:5:\"label\";s:12:\"Meera Inimai\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Megrim\";a:3:{s:5:\"label\";s:6:\"Megrim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Meie Script\";a:3:{s:5:\"label\";s:11:\"Meie Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Merienda\";a:3:{s:5:\"label\";s:8:\"Merienda\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Merienda One\";a:3:{s:5:\"label\";s:12:\"Merienda One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Merriweather\";a:3:{s:5:\"label\";s:12:\"Merriweather\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Merriweather Sans\";a:3:{s:5:\"label\";s:17:\"Merriweather Sans\";s:8:\"variants\";a:12:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Metal\";a:3:{s:5:\"label\";s:5:\"Metal\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metal Mania\";a:3:{s:5:\"label\";s:11:\"Metal Mania\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Metamorphous\";a:3:{s:5:\"label\";s:12:\"Metamorphous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Metrophobic\";a:3:{s:5:\"label\";s:11:\"Metrophobic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Michroma\";a:3:{s:5:\"label\";s:8:\"Michroma\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Milonga\";a:3:{s:5:\"label\";s:7:\"Milonga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Miltonian\";a:3:{s:5:\"label\";s:9:\"Miltonian\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Miltonian Tattoo\";a:3:{s:5:\"label\";s:16:\"Miltonian Tattoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Mina\";a:3:{s:5:\"label\";s:4:\"Mina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Miniver\";a:3:{s:5:\"label\";s:7:\"Miniver\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Miriam Libre\";a:3:{s:5:\"label\";s:12:\"Miriam Libre\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Mirza\";a:3:{s:5:\"label\";s:5:\"Mirza\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Miss Fajardose\";a:3:{s:5:\"label\";s:14:\"Miss Fajardose\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Mitr\";a:3:{s:5:\"label\";s:4:\"Mitr\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Modak\";a:3:{s:5:\"label\";s:5:\"Modak\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Modern Antiqua\";a:3:{s:5:\"label\";s:14:\"Modern Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Mogra\";a:3:{s:5:\"label\";s:5:\"Mogra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Molengo\";a:3:{s:5:\"label\";s:7:\"Molengo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Molle\";a:3:{s:5:\"label\";s:5:\"Molle\";s:8:\"variants\";a:1:{i:0;s:6:\"italic\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Monda\";a:3:{s:5:\"label\";s:5:\"Monda\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Monofett\";a:3:{s:5:\"label\";s:8:\"Monofett\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Monoton\";a:3:{s:5:\"label\";s:7:\"Monoton\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Monsieur La Doulaise\";a:3:{s:5:\"label\";s:20:\"Monsieur La Doulaise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Montaga\";a:3:{s:5:\"label\";s:7:\"Montaga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Montez\";a:3:{s:5:\"label\";s:6:\"Montez\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Montserrat\";a:3:{s:5:\"label\";s:10:\"Montserrat\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Montserrat Alternates\";a:3:{s:5:\"label\";s:21:\"Montserrat Alternates\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Montserrat Subrayada\";a:3:{s:5:\"label\";s:20:\"Montserrat Subrayada\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Moul\";a:3:{s:5:\"label\";s:4:\"Moul\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Moulpali\";a:3:{s:5:\"label\";s:8:\"Moulpali\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Mountains of Christmas\";a:3:{s:5:\"label\";s:22:\"Mountains of Christmas\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Mouse Memoirs\";a:3:{s:5:\"label\";s:13:\"Mouse Memoirs\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Mr Bedfort\";a:3:{s:5:\"label\";s:10:\"Mr Bedfort\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Mr Dafoe\";a:3:{s:5:\"label\";s:8:\"Mr Dafoe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:14:\"Mr De Haviland\";a:3:{s:5:\"label\";s:14:\"Mr De Haviland\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Mrs Saint Delafield\";a:3:{s:5:\"label\";s:19:\"Mrs Saint Delafield\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Mrs Sheppards\";a:3:{s:5:\"label\";s:13:\"Mrs Sheppards\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Mukta\";a:3:{s:5:\"label\";s:5:\"Mukta\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Mahee\";a:3:{s:5:\"label\";s:11:\"Mukta Mahee\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Malar\";a:3:{s:5:\"label\";s:11:\"Mukta Malar\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Mukta Vaani\";a:3:{s:5:\"label\";s:11:\"Mukta Vaani\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Mulish\";a:3:{s:5:\"label\";s:6:\"Mulish\";s:8:\"variants\";a:16:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"MuseoModerno\";a:3:{s:5:\"label\";s:12:\"MuseoModerno\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Mystery Quest\";a:3:{s:5:\"label\";s:13:\"Mystery Quest\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:3:\"NTR\";a:3:{s:5:\"label\";s:3:\"NTR\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Nanum Brush Script\";a:3:{s:5:\"label\";s:18:\"Nanum Brush Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Nanum Gothic\";a:3:{s:5:\"label\";s:12:\"Nanum Gothic\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Nanum Gothic Coding\";a:3:{s:5:\"label\";s:19:\"Nanum Gothic Coding\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:14:\"Nanum Myeongjo\";a:3:{s:5:\"label\";s:14:\"Nanum Myeongjo\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"Nanum Pen Script\";a:3:{s:5:\"label\";s:16:\"Nanum Pen Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Nerko One\";a:3:{s:5:\"label\";s:9:\"Nerko One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neucha\";a:3:{s:5:\"label\";s:6:\"Neucha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Neuton\";a:3:{s:5:\"label\";s:6:\"Neuton\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"New Rocker\";a:3:{s:5:\"label\";s:10:\"New Rocker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"New Tegomin\";a:3:{s:5:\"label\";s:11:\"New Tegomin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"News Cycle\";a:3:{s:5:\"label\";s:10:\"News Cycle\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Newsreader\";a:3:{s:5:\"label\";s:10:\"Newsreader\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Niconne\";a:3:{s:5:\"label\";s:7:\"Niconne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Niramit\";a:3:{s:5:\"label\";s:7:\"Niramit\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Nixie One\";a:3:{s:5:\"label\";s:9:\"Nixie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Nobile\";a:3:{s:5:\"label\";s:6:\"Nobile\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nokora\";a:3:{s:5:\"label\";s:6:\"Nokora\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Norican\";a:3:{s:5:\"label\";s:7:\"Norican\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Nosifer\";a:3:{s:5:\"label\";s:7:\"Nosifer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Notable\";a:3:{s:5:\"label\";s:7:\"Notable\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Nothing You Could Do\";a:3:{s:5:\"label\";s:20:\"Nothing You Could Do\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:12:\"Noticia Text\";a:3:{s:5:\"label\";s:12:\"Noticia Text\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Noto Sans\";a:3:{s:5:\"label\";s:9:\"Noto Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans HK\";a:3:{s:5:\"label\";s:12:\"Noto Sans HK\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans JP\";a:3:{s:5:\"label\";s:12:\"Noto Sans JP\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans KR\";a:3:{s:5:\"label\";s:12:\"Noto Sans KR\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans SC\";a:3:{s:5:\"label\";s:12:\"Noto Sans SC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Noto Sans TC\";a:3:{s:5:\"label\";s:12:\"Noto Sans TC\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Noto Serif\";a:3:{s:5:\"label\";s:10:\"Noto Serif\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif JP\";a:3:{s:5:\"label\";s:13:\"Noto Serif JP\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif KR\";a:3:{s:5:\"label\";s:13:\"Noto Serif KR\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif SC\";a:3:{s:5:\"label\";s:13:\"Noto Serif SC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Noto Serif TC\";a:3:{s:5:\"label\";s:13:\"Noto Serif TC\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Nova Cut\";a:3:{s:5:\"label\";s:8:\"Nova Cut\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Flat\";a:3:{s:5:\"label\";s:9:\"Nova Flat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Mono\";a:3:{s:5:\"label\";s:9:\"Nova Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:9:\"Nova Oval\";a:3:{s:5:\"label\";s:9:\"Nova Oval\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Nova Round\";a:3:{s:5:\"label\";s:10:\"Nova Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Script\";a:3:{s:5:\"label\";s:11:\"Nova Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Nova Slim\";a:3:{s:5:\"label\";s:9:\"Nova Slim\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Nova Square\";a:3:{s:5:\"label\";s:11:\"Nova Square\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Numans\";a:3:{s:5:\"label\";s:6:\"Numans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Nunito\";a:3:{s:5:\"label\";s:6:\"Nunito\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Nunito Sans\";a:3:{s:5:\"label\";s:11:\"Nunito Sans\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Odibee Sans\";a:3:{s:5:\"label\";s:11:\"Odibee Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Odor Mean Chey\";a:3:{s:5:\"label\";s:14:\"Odor Mean Chey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Offside\";a:3:{s:5:\"label\";s:7:\"Offside\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:2:\"Oi\";a:3:{s:5:\"label\";s:2:\"Oi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Old Standard TT\";a:3:{s:5:\"label\";s:15:\"Old Standard TT\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Oldenburg\";a:3:{s:5:\"label\";s:9:\"Oldenburg\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Oleo Script\";a:3:{s:5:\"label\";s:11:\"Oleo Script\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:22:\"Oleo Script Swash Caps\";a:3:{s:5:\"label\";s:22:\"Oleo Script Swash Caps\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Open Sans\";a:3:{s:5:\"label\";s:9:\"Open Sans\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Open Sans Condensed\";a:3:{s:5:\"label\";s:19:\"Open Sans Condensed\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oranienbaum\";a:3:{s:5:\"label\";s:11:\"Oranienbaum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Orbitron\";a:3:{s:5:\"label\";s:8:\"Orbitron\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Oregano\";a:3:{s:5:\"label\";s:7:\"Oregano\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Orelega One\";a:3:{s:5:\"label\";s:11:\"Orelega One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Orienta\";a:3:{s:5:\"label\";s:7:\"Orienta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Original Surfer\";a:3:{s:5:\"label\";s:15:\"Original Surfer\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oswald\";a:3:{s:5:\"label\";s:6:\"Oswald\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Otomanopee One\";a:3:{s:5:\"label\";s:14:\"Otomanopee One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Over the Rainbow\";a:3:{s:5:\"label\";s:16:\"Over the Rainbow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Overlock\";a:3:{s:5:\"label\";s:8:\"Overlock\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Overlock SC\";a:3:{s:5:\"label\";s:11:\"Overlock SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Overpass\";a:3:{s:5:\"label\";s:8:\"Overpass\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Overpass Mono\";a:3:{s:5:\"label\";s:13:\"Overpass Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:3:\"Ovo\";a:3:{s:5:\"label\";s:3:\"Ovo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Oxanium\";a:3:{s:5:\"label\";s:7:\"Oxanium\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:3:\"800\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Oxygen\";a:3:{s:5:\"label\";s:6:\"Oxygen\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Oxygen Mono\";a:3:{s:5:\"label\";s:11:\"Oxygen Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Mono\";a:3:{s:5:\"label\";s:7:\"PT Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"PT Sans\";a:3:{s:5:\"label\";s:7:\"PT Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"PT Sans Caption\";a:3:{s:5:\"label\";s:15:\"PT Sans Caption\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"PT Sans Narrow\";a:3:{s:5:\"label\";s:14:\"PT Sans Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"PT Serif\";a:3:{s:5:\"label\";s:8:\"PT Serif\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:16:\"PT Serif Caption\";a:3:{s:5:\"label\";s:16:\"PT Serif Caption\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pacifico\";a:3:{s:5:\"label\";s:8:\"Pacifico\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Padauk\";a:3:{s:5:\"label\";s:6:\"Padauk\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Palanquin\";a:3:{s:5:\"label\";s:9:\"Palanquin\";s:8:\"variants\";a:7:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Palanquin Dark\";a:3:{s:5:\"label\";s:14:\"Palanquin Dark\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Pangolin\";a:3:{s:5:\"label\";s:8:\"Pangolin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Paprika\";a:3:{s:5:\"label\";s:7:\"Paprika\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Parisienne\";a:3:{s:5:\"label\";s:10:\"Parisienne\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:11:\"Passero One\";a:3:{s:5:\"label\";s:11:\"Passero One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Passion One\";a:3:{s:5:\"label\";s:11:\"Passion One\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Pathway Gothic One\";a:3:{s:5:\"label\";s:18:\"Pathway Gothic One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Patrick Hand\";a:3:{s:5:\"label\";s:12:\"Patrick Hand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Patrick Hand SC\";a:3:{s:5:\"label\";s:15:\"Patrick Hand SC\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Pattaya\";a:3:{s:5:\"label\";s:7:\"Pattaya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Patua One\";a:3:{s:5:\"label\";s:9:\"Patua One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Pavanam\";a:3:{s:5:\"label\";s:7:\"Pavanam\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Paytone One\";a:3:{s:5:\"label\";s:11:\"Paytone One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Peddana\";a:3:{s:5:\"label\";s:7:\"Peddana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Peralta\";a:3:{s:5:\"label\";s:7:\"Peralta\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Permanent Marker\";a:3:{s:5:\"label\";s:16:\"Permanent Marker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:19:\"Petit Formal Script\";a:3:{s:5:\"label\";s:19:\"Petit Formal Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Petrona\";a:3:{s:5:\"label\";s:7:\"Petrona\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Philosopher\";a:3:{s:5:\"label\";s:11:\"Philosopher\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Piazzolla\";a:3:{s:5:\"label\";s:9:\"Piazzolla\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Piedra\";a:3:{s:5:\"label\";s:6:\"Piedra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Pinyon Script\";a:3:{s:5:\"label\";s:13:\"Pinyon Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Pirata One\";a:3:{s:5:\"label\";s:10:\"Pirata One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Plaster\";a:3:{s:5:\"label\";s:7:\"Plaster\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Play\";a:3:{s:5:\"label\";s:4:\"Play\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Playball\";a:3:{s:5:\"label\";s:8:\"Playball\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:16:\"Playfair Display\";a:3:{s:5:\"label\";s:16:\"Playfair Display\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:19:\"Playfair Display SC\";a:3:{s:5:\"label\";s:19:\"Playfair Display SC\";s:8:\"variants\";a:6:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"900\";i:3;s:9:\"900italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Podkova\";a:3:{s:5:\"label\";s:7:\"Podkova\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Poiret One\";a:3:{s:5:\"label\";s:10:\"Poiret One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Poller One\";a:3:{s:5:\"label\";s:10:\"Poller One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Poly\";a:3:{s:5:\"label\";s:4:\"Poly\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Pompiere\";a:3:{s:5:\"label\";s:8:\"Pompiere\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Pontano Sans\";a:3:{s:5:\"label\";s:12:\"Pontano Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Poor Story\";a:3:{s:5:\"label\";s:10:\"Poor Story\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Poppins\";a:3:{s:5:\"label\";s:7:\"Poppins\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Sans\";a:3:{s:5:\"label\";s:16:\"Port Lligat Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Port Lligat Slab\";a:3:{s:5:\"label\";s:16:\"Port Lligat Slab\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Potta One\";a:3:{s:5:\"label\";s:9:\"Potta One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Pragati Narrow\";a:3:{s:5:\"label\";s:14:\"Pragati Narrow\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Prata\";a:3:{s:5:\"label\";s:5:\"Prata\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Preahvihear\";a:3:{s:5:\"label\";s:11:\"Preahvihear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"Press Start 2P\";a:3:{s:5:\"label\";s:14:\"Press Start 2P\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Pridi\";a:3:{s:5:\"label\";s:5:\"Pridi\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Princess Sofia\";a:3:{s:5:\"label\";s:14:\"Princess Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Prociono\";a:3:{s:5:\"label\";s:8:\"Prociono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Prompt\";a:3:{s:5:\"label\";s:6:\"Prompt\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Prosto One\";a:3:{s:5:\"label\";s:10:\"Prosto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Proza Libre\";a:3:{s:5:\"label\";s:11:\"Proza Libre\";s:8:\"variants\";a:10:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Public Sans\";a:3:{s:5:\"label\";s:11:\"Public Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Puritan\";a:3:{s:5:\"label\";s:7:\"Puritan\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Purple Purse\";a:3:{s:5:\"label\";s:12:\"Purple Purse\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Qahiri\";a:3:{s:5:\"label\";s:6:\"Qahiri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Quando\";a:3:{s:5:\"label\";s:6:\"Quando\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Quantico\";a:3:{s:5:\"label\";s:8:\"Quantico\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Quattrocento\";a:3:{s:5:\"label\";s:12:\"Quattrocento\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:17:\"Quattrocento Sans\";a:3:{s:5:\"label\";s:17:\"Quattrocento Sans\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Questrial\";a:3:{s:5:\"label\";s:9:\"Questrial\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Quicksand\";a:3:{s:5:\"label\";s:9:\"Quicksand\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Quintessential\";a:3:{s:5:\"label\";s:14:\"Quintessential\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Qwigley\";a:3:{s:5:\"label\";s:7:\"Qwigley\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Racing Sans One\";a:3:{s:5:\"label\";s:15:\"Racing Sans One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Radley\";a:3:{s:5:\"label\";s:6:\"Radley\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Rajdhani\";a:3:{s:5:\"label\";s:8:\"Rajdhani\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rakkas\";a:3:{s:5:\"label\";s:6:\"Rakkas\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Raleway\";a:3:{s:5:\"label\";s:7:\"Raleway\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Raleway Dots\";a:3:{s:5:\"label\";s:12:\"Raleway Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Ramabhadra\";a:3:{s:5:\"label\";s:10:\"Ramabhadra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Ramaraja\";a:3:{s:5:\"label\";s:8:\"Ramaraja\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Rambla\";a:3:{s:5:\"label\";s:6:\"Rambla\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Rammetto One\";a:3:{s:5:\"label\";s:12:\"Rammetto One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Ranchers\";a:3:{s:5:\"label\";s:8:\"Ranchers\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Rancho\";a:3:{s:5:\"label\";s:6:\"Rancho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:5:\"Ranga\";a:3:{s:5:\"label\";s:5:\"Ranga\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Rasa\";a:3:{s:5:\"label\";s:4:\"Rasa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rationale\";a:3:{s:5:\"label\";s:9:\"Rationale\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Ravi Prakash\";a:3:{s:5:\"label\";s:12:\"Ravi Prakash\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Recursive\";a:3:{s:5:\"label\";s:9:\"Recursive\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Red Hat Display\";a:3:{s:5:\"label\";s:15:\"Red Hat Display\";s:8:\"variants\";a:8:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Red Hat Text\";a:3:{s:5:\"label\";s:12:\"Red Hat Text\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Red Rose\";a:3:{s:5:\"label\";s:8:\"Red Rose\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Redressed\";a:3:{s:5:\"label\";s:9:\"Redressed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Reem Kufi\";a:3:{s:5:\"label\";s:9:\"Reem Kufi\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Reenie Beanie\";a:3:{s:5:\"label\";s:13:\"Reenie Beanie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Reggae One\";a:3:{s:5:\"label\";s:10:\"Reggae One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Revalia\";a:3:{s:5:\"label\";s:7:\"Revalia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Rhodium Libre\";a:3:{s:5:\"label\";s:13:\"Rhodium Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Ribeye\";a:3:{s:5:\"label\";s:6:\"Ribeye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Ribeye Marrow\";a:3:{s:5:\"label\";s:13:\"Ribeye Marrow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Righteous\";a:3:{s:5:\"label\";s:9:\"Righteous\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Risque\";a:3:{s:5:\"label\";s:6:\"Risque\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Roboto\";a:3:{s:5:\"label\";s:6:\"Roboto\";s:8:\"variants\";a:12:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Roboto Condensed\";a:3:{s:5:\"label\";s:16:\"Roboto Condensed\";s:8:\"variants\";a:6:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:6:\"italic\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Roboto Mono\";a:3:{s:5:\"label\";s:11:\"Roboto Mono\";s:8:\"variants\";a:14:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:11:\"Roboto Slab\";a:3:{s:5:\"label\";s:11:\"Roboto Slab\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Rochester\";a:3:{s:5:\"label\";s:9:\"Rochester\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Rock Salt\";a:3:{s:5:\"label\";s:9:\"Rock Salt\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"RocknRoll One\";a:3:{s:5:\"label\";s:13:\"RocknRoll One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rokkitt\";a:3:{s:5:\"label\";s:7:\"Rokkitt\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Romanesco\";a:3:{s:5:\"label\";s:9:\"Romanesco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Ropa Sans\";a:3:{s:5:\"label\";s:9:\"Ropa Sans\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Rosario\";a:3:{s:5:\"label\";s:7:\"Rosario\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Rosarivo\";a:3:{s:5:\"label\";s:8:\"Rosarivo\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Rouge Script\";a:3:{s:5:\"label\";s:12:\"Rouge Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Rowdies\";a:3:{s:5:\"label\";s:7:\"Rowdies\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Rozha One\";a:3:{s:5:\"label\";s:9:\"Rozha One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Rubik\";a:3:{s:5:\"label\";s:5:\"Rubik\";s:8:\"variants\";a:14:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Rubik Mono One\";a:3:{s:5:\"label\";s:14:\"Rubik Mono One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Ruda\";a:3:{s:5:\"label\";s:4:\"Ruda\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Rufina\";a:3:{s:5:\"label\";s:6:\"Rufina\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Ruge Boogie\";a:3:{s:5:\"label\";s:11:\"Ruge Boogie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Ruluko\";a:3:{s:5:\"label\";s:6:\"Ruluko\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Rum Raisin\";a:3:{s:5:\"label\";s:10:\"Rum Raisin\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:14:\"Ruslan Display\";a:3:{s:5:\"label\";s:14:\"Ruslan Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Russo One\";a:3:{s:5:\"label\";s:9:\"Russo One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Ruthie\";a:3:{s:5:\"label\";s:6:\"Ruthie\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Rye\";a:3:{s:5:\"label\";s:3:\"Rye\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"STIX Two Math\";a:3:{s:5:\"label\";s:13:\"STIX Two Math\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Sacramento\";a:3:{s:5:\"label\";s:10:\"Sacramento\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Sahitya\";a:3:{s:5:\"label\";s:7:\"Sahitya\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Sail\";a:3:{s:5:\"label\";s:4:\"Sail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Saira\";a:3:{s:5:\"label\";s:5:\"Saira\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Saira Condensed\";a:3:{s:5:\"label\";s:15:\"Saira Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Saira Extra Condensed\";a:3:{s:5:\"label\";s:21:\"Saira Extra Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:20:\"Saira Semi Condensed\";a:3:{s:5:\"label\";s:20:\"Saira Semi Condensed\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:17:\"Saira Stencil One\";a:3:{s:5:\"label\";s:17:\"Saira Stencil One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Salsa\";a:3:{s:5:\"label\";s:5:\"Salsa\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sanchez\";a:3:{s:5:\"label\";s:7:\"Sanchez\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sancreek\";a:3:{s:5:\"label\";s:8:\"Sancreek\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sansita\";a:3:{s:5:\"label\";s:7:\"Sansita\";s:8:\"variants\";a:8:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:3:\"800\";i:3;s:9:\"800italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sansita Swashed\";a:3:{s:5:\"label\";s:15:\"Sansita Swashed\";s:8:\"variants\";a:7:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sarabun\";a:3:{s:5:\"label\";s:7:\"Sarabun\";s:8:\"variants\";a:16:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:6:\"italic\";i:15;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarala\";a:3:{s:5:\"label\";s:6:\"Sarala\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sarina\";a:3:{s:5:\"label\";s:6:\"Sarina\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Sarpanch\";a:3:{s:5:\"label\";s:8:\"Sarpanch\";s:8:\"variants\";a:6:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Satisfy\";a:3:{s:5:\"label\";s:7:\"Satisfy\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:15:\"Sawarabi Gothic\";a:3:{s:5:\"label\";s:15:\"Sawarabi Gothic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Sawarabi Mincho\";a:3:{s:5:\"label\";s:15:\"Sawarabi Mincho\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Scada\";a:3:{s:5:\"label\";s:5:\"Scada\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Scheherazade\";a:3:{s:5:\"label\";s:12:\"Scheherazade\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Schoolbell\";a:3:{s:5:\"label\";s:10:\"Schoolbell\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Scope One\";a:3:{s:5:\"label\";s:9:\"Scope One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Seaweed Script\";a:3:{s:5:\"label\";s:14:\"Seaweed Script\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Secular One\";a:3:{s:5:\"label\";s:11:\"Secular One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Sedgwick Ave\";a:3:{s:5:\"label\";s:12:\"Sedgwick Ave\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:20:\"Sedgwick Ave Display\";a:3:{s:5:\"label\";s:20:\"Sedgwick Ave Display\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:3:\"Sen\";a:3:{s:5:\"label\";s:3:\"Sen\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"800\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Sevillana\";a:3:{s:5:\"label\";s:9:\"Sevillana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Seymour One\";a:3:{s:5:\"label\";s:11:\"Seymour One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Shadows Into Light\";a:3:{s:5:\"label\";s:18:\"Shadows Into Light\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:22:\"Shadows Into Light Two\";a:3:{s:5:\"label\";s:22:\"Shadows Into Light Two\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Shanti\";a:3:{s:5:\"label\";s:6:\"Shanti\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Share\";a:3:{s:5:\"label\";s:5:\"Share\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Share Tech\";a:3:{s:5:\"label\";s:10:\"Share Tech\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Share Tech Mono\";a:3:{s:5:\"label\";s:15:\"Share Tech Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:15:\"Shippori Mincho\";a:3:{s:5:\"label\";s:15:\"Shippori Mincho\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:18:\"Shippori Mincho B1\";a:3:{s:5:\"label\";s:18:\"Shippori Mincho B1\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Shojumaru\";a:3:{s:5:\"label\";s:9:\"Shojumaru\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Short Stack\";a:3:{s:5:\"label\";s:11:\"Short Stack\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Shrikhand\";a:3:{s:5:\"label\";s:9:\"Shrikhand\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Siemreap\";a:3:{s:5:\"label\";s:8:\"Siemreap\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sigmar One\";a:3:{s:5:\"label\";s:10:\"Sigmar One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Signika\";a:3:{s:5:\"label\";s:7:\"Signika\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Signika Negative\";a:3:{s:5:\"label\";s:16:\"Signika Negative\";s:8:\"variants\";a:4:{i:0;s:3:\"300\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Simonetta\";a:3:{s:5:\"label\";s:9:\"Simonetta\";s:8:\"variants\";a:4:{i:0;s:3:\"900\";i:1;s:9:\"900italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Single Day\";a:3:{s:5:\"label\";s:10:\"Single Day\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sintony\";a:3:{s:5:\"label\";s:7:\"Sintony\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Sirin Stencil\";a:3:{s:5:\"label\";s:13:\"Sirin Stencil\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Six Caps\";a:3:{s:5:\"label\";s:8:\"Six Caps\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Skranji\";a:3:{s:5:\"label\";s:7:\"Skranji\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Slabo 13px\";a:3:{s:5:\"label\";s:10:\"Slabo 13px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Slabo 27px\";a:3:{s:5:\"label\";s:10:\"Slabo 27px\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Slackey\";a:3:{s:5:\"label\";s:7:\"Slackey\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Smokum\";a:3:{s:5:\"label\";s:6:\"Smokum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Smythe\";a:3:{s:5:\"label\";s:6:\"Smythe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Sniglet\";a:3:{s:5:\"label\";s:7:\"Sniglet\";s:8:\"variants\";a:2:{i:0;s:3:\"800\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Snippet\";a:3:{s:5:\"label\";s:7:\"Snippet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Snowburst One\";a:3:{s:5:\"label\";s:13:\"Snowburst One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Sofadi One\";a:3:{s:5:\"label\";s:10:\"Sofadi One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Sofia\";a:3:{s:5:\"label\";s:5:\"Sofia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Solway\";a:3:{s:5:\"label\";s:6:\"Solway\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Song Myung\";a:3:{s:5:\"label\";s:10:\"Song Myung\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Sonsie One\";a:3:{s:5:\"label\";s:10:\"Sonsie One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sora\";a:3:{s:5:\"label\";s:4:\"Sora\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Sorts Mill Goudy\";a:3:{s:5:\"label\";s:16:\"Sorts Mill Goudy\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:15:\"Source Code Pro\";a:3:{s:5:\"label\";s:15:\"Source Code Pro\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:15:\"Source Sans Pro\";a:3:{s:5:\"label\";s:15:\"Source Sans Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Source Serif Pro\";a:3:{s:5:\"label\";s:16:\"Source Serif Pro\";s:8:\"variants\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Space Grotesk\";a:3:{s:5:\"label\";s:13:\"Space Grotesk\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Space Mono\";a:3:{s:5:\"label\";s:10:\"Space Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:7:\"Spartan\";a:3:{s:5:\"label\";s:7:\"Spartan\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:13:\"Special Elite\";a:3:{s:5:\"label\";s:13:\"Special Elite\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Spectral\";a:3:{s:5:\"label\";s:8:\"Spectral\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Spectral SC\";a:3:{s:5:\"label\";s:11:\"Spectral SC\";s:8:\"variants\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"500\";i:5;s:9:\"500italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:6:\"italic\";i:13;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Spicy Rice\";a:3:{s:5:\"label\";s:10:\"Spicy Rice\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Spinnaker\";a:3:{s:5:\"label\";s:9:\"Spinnaker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Spirax\";a:3:{s:5:\"label\";s:6:\"Spirax\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Squada One\";a:3:{s:5:\"label\";s:10:\"Squada One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Sree Krushnadevaraya\";a:3:{s:5:\"label\";s:20:\"Sree Krushnadevaraya\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Sriracha\";a:3:{s:5:\"label\";s:8:\"Sriracha\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Srisakdi\";a:3:{s:5:\"label\";s:8:\"Srisakdi\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Staatliches\";a:3:{s:5:\"label\";s:11:\"Staatliches\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Stalemate\";a:3:{s:5:\"label\";s:9:\"Stalemate\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Stalinist One\";a:3:{s:5:\"label\";s:13:\"Stalinist One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Stardos Stencil\";a:3:{s:5:\"label\";s:15:\"Stardos Stencil\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stick\";a:3:{s:5:\"label\";s:5:\"Stick\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:21:\"Stint Ultra Condensed\";a:3:{s:5:\"label\";s:21:\"Stint Ultra Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:20:\"Stint Ultra Expanded\";a:3:{s:5:\"label\";s:20:\"Stint Ultra Expanded\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Stoke\";a:3:{s:5:\"label\";s:5:\"Stoke\";s:8:\"variants\";a:2:{i:0;s:3:\"300\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:6:\"Strait\";a:3:{s:5:\"label\";s:6:\"Strait\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Stylish\";a:3:{s:5:\"label\";s:7:\"Stylish\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:19:\"Sue Ellen Francisco\";a:3:{s:5:\"label\";s:19:\"Sue Ellen Francisco\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Suez One\";a:3:{s:5:\"label\";s:8:\"Suez One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:13:\"Sulphur Point\";a:3:{s:5:\"label\";s:13:\"Sulphur Point\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"700\";i:2;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Sumana\";a:3:{s:5:\"label\";s:6:\"Sumana\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Sunflower\";a:3:{s:5:\"label\";s:9:\"Sunflower\";s:8:\"variants\";a:3:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"700\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Sunshiney\";a:3:{s:5:\"label\";s:9:\"Sunshiney\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:16:\"Supermercado One\";a:3:{s:5:\"label\";s:16:\"Supermercado One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Sura\";a:3:{s:5:\"label\";s:4:\"Sura\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Suranna\";a:3:{s:5:\"label\";s:7:\"Suranna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Suravaram\";a:3:{s:5:\"label\";s:9:\"Suravaram\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Suwannaphum\";a:3:{s:5:\"label\";s:11:\"Suwannaphum\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:18:\"Swanky and Moo Moo\";a:3:{s:5:\"label\";s:18:\"Swanky and Moo Moo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Syncopate\";a:3:{s:5:\"label\";s:9:\"Syncopate\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:4:\"Syne\";a:3:{s:5:\"label\";s:4:\"Syne\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Syne Mono\";a:3:{s:5:\"label\";s:9:\"Syne Mono\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:12:\"Syne Tactile\";a:3:{s:5:\"label\";s:12:\"Syne Tactile\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Tajawal\";a:3:{s:5:\"label\";s:7:\"Tajawal\";s:8:\"variants\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:3:\"900\";i:6;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Tangerine\";a:3:{s:5:\"label\";s:9:\"Tangerine\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Taprom\";a:3:{s:5:\"label\";s:6:\"Taprom\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Tauri\";a:3:{s:5:\"label\";s:5:\"Tauri\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Taviraj\";a:3:{s:5:\"label\";s:7:\"Taviraj\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Teko\";a:3:{s:5:\"label\";s:4:\"Teko\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Telex\";a:3:{s:5:\"label\";s:5:\"Telex\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"Tenali Ramakrishna\";a:3:{s:5:\"label\";s:18:\"Tenali Ramakrishna\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:10:\"Tenor Sans\";a:3:{s:5:\"label\";s:10:\"Tenor Sans\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Text Me One\";a:3:{s:5:\"label\";s:11:\"Text Me One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Texturina\";a:3:{s:5:\"label\";s:9:\"Texturina\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Thasadith\";a:3:{s:5:\"label\";s:9:\"Thasadith\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:18:\"The Girl Next Door\";a:3:{s:5:\"label\";s:18:\"The Girl Next Door\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Tienne\";a:3:{s:5:\"label\";s:6:\"Tienne\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:3:\"900\";i:2;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Tillana\";a:3:{s:5:\"label\";s:7:\"Tillana\";s:8:\"variants\";a:5:{i:0;s:3:\"500\";i:1;s:3:\"600\";i:2;s:3:\"700\";i:3;s:3:\"800\";i:4;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:7:\"Timmana\";a:3:{s:5:\"label\";s:7:\"Timmana\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Tinos\";a:3:{s:5:\"label\";s:5:\"Tinos\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:9:\"Titan One\";a:3:{s:5:\"label\";s:9:\"Titan One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Titillium Web\";a:3:{s:5:\"label\";s:13:\"Titillium Web\";s:8:\"variants\";a:11:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:6:\"italic\";i:10;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Tomorrow\";a:3:{s:5:\"label\";s:8:\"Tomorrow\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Tourney\";a:3:{s:5:\"label\";s:7:\"Tourney\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Trade Winds\";a:3:{s:5:\"label\";s:11:\"Trade Winds\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Train One\";a:3:{s:5:\"label\";s:9:\"Train One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Trirong\";a:3:{s:5:\"label\";s:7:\"Trirong\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Trispace\";a:3:{s:5:\"label\";s:8:\"Trispace\";s:8:\"variants\";a:8:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Trocchi\";a:3:{s:5:\"label\";s:7:\"Trocchi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:7:\"Trochut\";a:3:{s:5:\"label\";s:7:\"Trochut\";s:8:\"variants\";a:3:{i:0;s:3:\"700\";i:1;s:6:\"italic\";i:2;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Truculenta\";a:3:{s:5:\"label\";s:10:\"Truculenta\";s:8:\"variants\";a:9:{i:0;s:3:\"100\";i:1;s:3:\"200\";i:2;s:3:\"300\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"800\";i:7;s:3:\"900\";i:8;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:7:\"Trykker\";a:3:{s:5:\"label\";s:7:\"Trykker\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:10:\"Tulpen One\";a:3:{s:5:\"label\";s:10:\"Tulpen One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:11:\"Turret Road\";a:3:{s:5:\"label\";s:11:\"Turret Road\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"800\";i:5;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Ubuntu\";a:3:{s:5:\"label\";s:6:\"Ubuntu\";s:8:\"variants\";a:8:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:6:\"italic\";i:7;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Ubuntu Condensed\";a:3:{s:5:\"label\";s:16:\"Ubuntu Condensed\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Ubuntu Mono\";a:3:{s:5:\"label\";s:11:\"Ubuntu Mono\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:5:\"Uchen\";a:3:{s:5:\"label\";s:5:\"Uchen\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"Ultra\";a:3:{s:5:\"label\";s:5:\"Ultra\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:14:\"Uncial Antiqua\";a:3:{s:5:\"label\";s:14:\"Uncial Antiqua\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Underdog\";a:3:{s:5:\"label\";s:8:\"Underdog\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Unica One\";a:3:{s:5:\"label\";s:9:\"Unica One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:14:\"UnifrakturCook\";a:3:{s:5:\"label\";s:14:\"UnifrakturCook\";s:8:\"variants\";a:1:{i:0;s:3:\"700\";}s:8:\"category\";s:7:\"display\";}s:18:\"UnifrakturMaguntia\";a:3:{s:5:\"label\";s:18:\"UnifrakturMaguntia\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Unkempt\";a:3:{s:5:\"label\";s:7:\"Unkempt\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Unlock\";a:3:{s:5:\"label\";s:6:\"Unlock\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:4:\"Unna\";a:3:{s:5:\"label\";s:4:\"Unna\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:5:\"VT323\";a:3:{s:5:\"label\";s:5:\"VT323\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:11:\"Vampiro One\";a:3:{s:5:\"label\";s:11:\"Vampiro One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Varela\";a:3:{s:5:\"label\";s:6:\"Varela\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"Varela Round\";a:3:{s:5:\"label\";s:12:\"Varela Round\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Varta\";a:3:{s:5:\"label\";s:5:\"Varta\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Vast Shadow\";a:3:{s:5:\"label\";s:11:\"Vast Shadow\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:12:\"Vesper Libre\";a:3:{s:5:\"label\";s:12:\"Vesper Libre\";s:8:\"variants\";a:4:{i:0;s:3:\"500\";i:1;s:3:\"700\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:12:\"Viaoda Libre\";a:3:{s:5:\"label\";s:12:\"Viaoda Libre\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Vibes\";a:3:{s:5:\"label\";s:5:\"Vibes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:5:\"Vibur\";a:3:{s:5:\"label\";s:5:\"Vibur\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Vidaloka\";a:3:{s:5:\"label\";s:8:\"Vidaloka\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:4:\"Viga\";a:3:{s:5:\"label\";s:4:\"Viga\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:5:\"Voces\";a:3:{s:5:\"label\";s:5:\"Voces\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:7:\"Volkhov\";a:3:{s:5:\"label\";s:7:\"Volkhov\";s:8:\"variants\";a:4:{i:0;s:3:\"700\";i:1;s:9:\"700italic\";i:2;s:6:\"italic\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Vollkorn\";a:3:{s:5:\"label\";s:8:\"Vollkorn\";s:8:\"variants\";a:12:{i:0;s:3:\"500\";i:1;s:9:\"500italic\";i:2;s:3:\"600\";i:3;s:9:\"600italic\";i:4;s:3:\"700\";i:5;s:9:\"700italic\";i:6;s:3:\"800\";i:7;s:9:\"800italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";i:10;s:6:\"italic\";i:11;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Vollkorn SC\";a:3:{s:5:\"label\";s:11:\"Vollkorn SC\";s:8:\"variants\";a:4:{i:0;s:3:\"600\";i:1;s:3:\"700\";i:2;s:3:\"900\";i:3;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Voltaire\";a:3:{s:5:\"label\";s:8:\"Voltaire\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:23:\"Waiting for the Sunrise\";a:3:{s:5:\"label\";s:23:\"Waiting for the Sunrise\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:8:\"Wallpoet\";a:3:{s:5:\"label\";s:8:\"Wallpoet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:15:\"Walter Turncoat\";a:3:{s:5:\"label\";s:15:\"Walter Turncoat\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Warnes\";a:3:{s:5:\"label\";s:6:\"Warnes\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Wellfleet\";a:3:{s:5:\"label\";s:9:\"Wellfleet\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:9:\"Wendy One\";a:3:{s:5:\"label\";s:9:\"Wendy One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:8:\"Wire One\";a:3:{s:5:\"label\";s:8:\"Wire One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Work Sans\";a:3:{s:5:\"label\";s:9:\"Work Sans\";s:8:\"variants\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"500\";i:7;s:9:\"500italic\";i:8;s:3:\"600\";i:9;s:9:\"600italic\";i:10;s:3:\"700\";i:11;s:9:\"700italic\";i:12;s:3:\"800\";i:13;s:9:\"800italic\";i:14;s:3:\"900\";i:15;s:9:\"900italic\";i:16;s:6:\"italic\";i:17;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Xanh Mono\";a:3:{s:5:\"label\";s:9:\"Xanh Mono\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:9:\"monospace\";}s:17:\"Yanone Kaffeesatz\";a:3:{s:5:\"label\";s:17:\"Yanone Kaffeesatz\";s:8:\"variants\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"600\";i:4;s:3:\"700\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:11:\"Yantramanav\";a:3:{s:5:\"label\";s:11:\"Yantramanav\";s:8:\"variants\";a:6:{i:0;s:3:\"100\";i:1;s:3:\"300\";i:2;s:3:\"500\";i:3;s:3:\"700\";i:4;s:3:\"900\";i:5;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Yatra One\";a:3:{s:5:\"label\";s:9:\"Yatra One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yellowtail\";a:3:{s:5:\"label\";s:10:\"Yellowtail\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:9:\"Yeon Sung\";a:3:{s:5:\"label\";s:9:\"Yeon Sung\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yeseva One\";a:3:{s:5:\"label\";s:10:\"Yeseva One\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:10:\"Yesteryear\";a:3:{s:5:\"label\";s:10:\"Yesteryear\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:6:\"Yomogi\";a:3:{s:5:\"label\";s:6:\"Yomogi\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:4:\"Yrsa\";a:3:{s:5:\"label\";s:4:\"Yrsa\";s:8:\"variants\";a:5:{i:0;s:3:\"300\";i:1;s:3:\"500\";i:2;s:3:\"600\";i:3;s:3:\"700\";i:4;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:11:\"Yusei Magic\";a:3:{s:5:\"label\";s:11:\"Yusei Magic\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:10:\"sans-serif\";}s:12:\"ZCOOL KuaiLe\";a:3:{s:5:\"label\";s:12:\"ZCOOL KuaiLe\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:21:\"ZCOOL QingKe HuangYou\";a:3:{s:5:\"label\";s:21:\"ZCOOL QingKe HuangYou\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"ZCOOL XiaoWei\";a:3:{s:5:\"label\";s:13:\"ZCOOL XiaoWei\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:8:\"Zen Dots\";a:3:{s:5:\"label\";s:8:\"Zen Dots\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:8:\"Zen Loop\";a:3:{s:5:\"label\";s:8:\"Zen Loop\";s:8:\"variants\";a:2:{i:0;s:6:\"italic\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:13:\"Zen Tokyo Zoo\";a:3:{s:5:\"label\";s:13:\"Zen Tokyo Zoo\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}s:6:\"Zeyada\";a:3:{s:5:\"label\";s:6:\"Zeyada\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:13:\"Zhi Mang Xing\";a:3:{s:5:\"label\";s:13:\"Zhi Mang Xing\";s:8:\"variants\";a:1:{i:0;s:7:\"regular\";}s:8:\"category\";s:11:\"handwriting\";}s:10:\"Zilla Slab\";a:3:{s:5:\"label\";s:10:\"Zilla Slab\";s:8:\"variants\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"500\";i:3;s:9:\"500italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:6:\"italic\";i:9;s:7:\"regular\";}s:8:\"category\";s:5:\"serif\";}s:20:\"Zilla Slab Highlight\";a:3:{s:5:\"label\";s:20:\"Zilla Slab Highlight\";s:8:\"variants\";a:2:{i:0;s:3:\"700\";i:1;s:7:\"regular\";}s:8:\"category\";s:7:\"display\";}}", "no");
INSERT INTO `HhhEP_options` VALUES("3435", "_site_transient_timeout_browser_ac7c1132b0f276bb32029ff0c4eabccd", "1638948177", "no");
INSERT INTO `HhhEP_options` VALUES("3436", "_site_transient_browser_ac7c1132b0f276bb32029ff0c4eabccd", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:12:\"96.0.4664.55\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "no");
INSERT INTO `HhhEP_options` VALUES("3437", "_transient_timeout_sbi_i_africanwildlifevets#10", "1638346977", "no");
INSERT INTO `HhhEP_options` VALUES("3438", "_transient_sbi_i_africanwildlifevets#10", "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", "no");
INSERT INTO `HhhEP_options` VALUES("3439", "_site_transient_timeout_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "1638948178", "no");
INSERT INTO `HhhEP_options` VALUES("3440", "_site_transient_php_check_1d343e7f9aee33bb3a30d3fe7077ec03", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"5.6.20\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "no");
INSERT INTO `HhhEP_options` VALUES("3441", "_transient_timeout_wc_onboarding_product_data", "1638429782", "no");
INSERT INTO `HhhEP_options` VALUES("3442", "_transient_wc_onboarding_product_data", "a:6:{s:7:\"headers\";O:42:\"Requests_Utility_CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:19:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Wed, 01 Dec 2021 07:23:02 GMT\";s:12:\"content-type\";s:31:\"application/json; charset=UTF-8\";s:14:\"content-length\";s:5:\"12426\";s:12:\"x-robots-tag\";s:7:\"noindex\";s:4:\"link\";s:60:\"<https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\";s:22:\"x-content-type-options\";s:7:\"nosniff\";s:29:\"access-control-expose-headers\";s:33:\"X-WP-Total, X-WP-TotalPages, Link\";s:28:\"access-control-allow-headers\";s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";s:13:\"x-wccom-cache\";s:3:\"HIT\";s:13:\"cache-control\";s:10:\"max-age=60\";s:5:\"allow\";s:3:\"GET\";s:4:\"x-rq\";s:13:\"jnb1 0 4 9980\";s:16:\"content-encoding\";s:4:\"gzip\";s:3:\"age\";s:2:\"45\";s:7:\"x-cache\";s:3:\"hit\";s:4:\"vary\";s:23:\"Accept-Encoding, Origin\";s:13:\"accept-ranges\";s:5:\"bytes\";s:25:\"strict-transport-security\";s:16:\"max-age=31536000\";}}s:4:\"body\";s:65308:\"{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Automatically calculate how much sales tax should be collected for WooCommerce orders - by city, country, or state - at checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/12\\/stripe-app-icon-7m1xi7.png\"},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Security, performance, and marketing tools made for WooCommerce stores by the WordPress experts. Get started with basic security and speed tools for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Jetpack\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/jetpack\\/\",\"icon\":null},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297,\"rating\":2.1,\"reviews_count\":51,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"Securely accept payments, track cash flow, and manage recurring revenue from your dashboard \\u2014 all without setup costs or monthly fees.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/02\\/wcpay-icon-fv4tef.png\"},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816,\"rating\":3.5,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503,\"rating\":3.2,\"reviews_count\":64,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147,\"rating\":3.6,\"reviews_count\":37,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Mailchimp\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/mailchimp\\/\",\"icon\":null},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618,\"rating\":3.1,\"reviews_count\":19,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Listings &amp; Ads\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/06\\/marketplace-card.png\",\"excerpt\":\"Reach millions of engaged shoppers across Google with free product listings and ads. Built in partnership with Google.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-listings-and-ads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"118f4d86-f126-4c3a-8525-644e3170d161\",\"slug\":\"google-listings-and-ads\",\"id\":7623964,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665,\"rating\":3.4,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Ads &amp; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145,\"rating\":4.4,\"reviews_count\":109,\"vendor_name\":\"Kliken\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/kliken\\/\",\"icon\":null},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890,\"rating\":2.7,\"reviews_count\":18,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayPal Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/PPCP-Tile-PayPal-Logo-and-Cart-Art-2x-2-uozwz8.jpg\",\"excerpt\":\"PayPal\'s latest, all-in-one checkout solution. Securely accept PayPal Digital Payments, credit\\/debit cards and local payment methods.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paypal-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"934115ab-e3f3-4435-9580-345b1ce21899\",\"slug\":\"woocommerce-paypal-payments\",\"id\":6410731,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/pp_v_rgb-didybc.jpg\"},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Power your membership association, online magazine, elearning sites, and more with access control to content\\/products and member discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589,\"rating\":4.4,\"reviews_count\":78,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/07\\/Bundles_logo-0cllvb.png\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages, and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716,\"rating\":4.9,\"reviews_count\":112,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Multichannel for WooCommerce: Google, Amazon, eBay &amp; Walmart Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/Woo-Extension-Store-Logo-v2.png\",\"excerpt\":\"Get the official Google, Amazon, eBay and Walmart extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890,\"rating\":3.2,\"reviews_count\":32,\"vendor_name\":\"Codisto\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/codisto\\/\",\"icon\":null},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982,\"rating\":3,\"reviews_count\":16,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Live Chat\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/live-chat\\/\",\"icon\":null},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481,\"rating\":4.8,\"reviews_count\":39,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259,\"rating\":2.9,\"reviews_count\":11,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652,\"rating\":4.5,\"reviews_count\":21,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729,\"rating\":4.6,\"reviews_count\":120,\"vendor_name\":\"StoreApps\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/storeapps\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/wc-icon-smart-coupons-160-p8fwgu.png\"},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate your WooCommerce store with 4000+ cloud apps and services today. Trusted by 11,000+ users.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589,\"rating\":4.4,\"reviews_count\":32,\"vendor_name\":\"OM4\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/om4\\/\",\"icon\":null},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Automate sales tax compliance for your multi-channel e-commerce business. Accurate sales tax calculations, data aggregation, quality reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"TaxJar\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/taxjar\\/\",\"icon\":null},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Sensei LMS Course Progress\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/sensei-course-progress.png\",\"excerpt\":\"Enable your students to easily see their progress and pick up where they left off in a course.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sensei-course-progress\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ec0f55d8fa7c517dc1844f5c873a77da\",\"slug\":\"sensei-course-progress\",\"id\":435833,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643,\"rating\":3.4,\"reviews_count\":27,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738,\"rating\":5,\"reviews_count\":51,\"vendor_name\":\"Backcourt Development\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/backcourt-development\\/\",\"icon\":null},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666,\"rating\":4.3,\"reviews_count\":27,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed rich product data to Google Merchant Center for setting up free product listings, product ads, and local inventory campaigns. Full control over your field mappings, and feed content so you can maximize campaign performance and ad spend.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619,\"rating\":4.3,\"reviews_count\":36,\"vendor_name\":\"Ademti Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/ademti-software\\/\",\"icon\":null},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on-time tax filing. No more tracking sales tax rates and rules.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/06\\/Composites_logo-8dctno.png\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836,\"rating\":4.9,\"reviews_count\":99,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Eway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/51456-Eway-logo-tagline-RGB-H-yellow-_-grey.png\",\"excerpt\":\"Take credit card payments securely via Eway (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/wc-paid-courses.png\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MyWorks Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/myworks-software\\/\",\"icon\":null},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/03\\/CSP_Logo-abcc0f.png\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253,\"rating\":4.8,\"reviews_count\":42,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Upgrade from Sequential Order Numbers with advanced features and with optional prefixes\\/suffixes.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497,\"rating\":4,\"reviews_count\":19,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174,\"rating\":4.4,\"reviews_count\":134,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Klarna Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Payments_Pink.png\",\"excerpt\":\"With Klarna Payments\\u00a0you can choose the payment that you want, Pay Now, Pay Later or Slice It. No credit card numbers, no passwords, no worries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnapayments\\/\",\"price\":\"&#36;0.00\",\"hash\":\"a19c689325bc8ea63c620765dd54b33a\",\"slug\":\"klarna-payments-for-woocommerce\",\"id\":2754217,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"Accept payment with First Data using the Payeezy Gateway, Payeezy, or legacy Global Gateway payment gateways.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"HubSpot for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/04\\/hubspotlogo-web-color-pxebeq.png\",\"excerpt\":\"Connect your WooCommerce store to HubSpot. Sync, automate &amp; analyze data with HubSpot WooCommerce Integration\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/hubspot-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e50acec8-3a6c-454c-8562-2da4898fa6c1\",\"slug\":\"hubspot-for-woocommerce\",\"id\":5785079,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MakeWebBetter\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/makewebbetter\\/\",\"icon\":null},{\"title\":\"Viva Wallet for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/04\\/Viva-Wallet-logo.png?w=374\",\"excerpt\":\"Integrate the Viva Wallet payment gateway with your WooCommerce store to process and sync your payments and help you sell more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/viva-wallet-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"7240a329-047f-4d8b-b7ec-ee3defd798bd\",\"slug\":\"viva-wallet-for-woocommerce\",\"id\":6137160,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Viva Wallet\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/viva-wallet\\/\",\"icon\":null},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Opayo Payment Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo Form, Opayo Direct or Opayo Pi. Supporting 3D Secure 2.0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Andrew Benbow\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/andrew-benbow\\/\",\"icon\":null}]}\";s:8:\"response\";a:2:{s:4:\"code\";i:200;s:7:\"message\";s:2:\"OK\";}s:7:\"cookies\";a:0:{}s:8:\"filename\";N;s:13:\"http_response\";O:25:\"WP_HTTP_Requests_Response\":5:{s:11:\"\0*\0response\";O:17:\"Requests_Response\":10:{s:4:\"body\";s:65308:\"{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Automatically calculate how much sales tax should be collected for WooCommerce orders - by city, country, or state - at checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/12\\/stripe-app-icon-7m1xi7.png\"},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Security, performance, and marketing tools made for WooCommerce stores by the WordPress experts. Get started with basic security and speed tools for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Jetpack\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/jetpack\\/\",\"icon\":null},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297,\"rating\":2.1,\"reviews_count\":51,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"Securely accept payments, track cash flow, and manage recurring revenue from your dashboard \\u2014 all without setup costs or monthly fees.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/02\\/wcpay-icon-fv4tef.png\"},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816,\"rating\":3.5,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503,\"rating\":3.2,\"reviews_count\":64,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147,\"rating\":3.6,\"reviews_count\":37,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Mailchimp\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/mailchimp\\/\",\"icon\":null},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618,\"rating\":3.1,\"reviews_count\":19,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Listings &amp; Ads\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/06\\/marketplace-card.png\",\"excerpt\":\"Reach millions of engaged shoppers across Google with free product listings and ads. Built in partnership with Google.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-listings-and-ads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"118f4d86-f126-4c3a-8525-644e3170d161\",\"slug\":\"google-listings-and-ads\",\"id\":7623964,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665,\"rating\":3.4,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Ads &amp; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145,\"rating\":4.4,\"reviews_count\":109,\"vendor_name\":\"Kliken\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/kliken\\/\",\"icon\":null},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890,\"rating\":2.7,\"reviews_count\":18,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayPal Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/PPCP-Tile-PayPal-Logo-and-Cart-Art-2x-2-uozwz8.jpg\",\"excerpt\":\"PayPal\'s latest, all-in-one checkout solution. Securely accept PayPal Digital Payments, credit\\/debit cards and local payment methods.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paypal-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"934115ab-e3f3-4435-9580-345b1ce21899\",\"slug\":\"woocommerce-paypal-payments\",\"id\":6410731,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/pp_v_rgb-didybc.jpg\"},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Power your membership association, online magazine, elearning sites, and more with access control to content\\/products and member discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589,\"rating\":4.4,\"reviews_count\":78,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/07\\/Bundles_logo-0cllvb.png\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages, and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716,\"rating\":4.9,\"reviews_count\":112,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Multichannel for WooCommerce: Google, Amazon, eBay &amp; Walmart Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/Woo-Extension-Store-Logo-v2.png\",\"excerpt\":\"Get the official Google, Amazon, eBay and Walmart extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890,\"rating\":3.2,\"reviews_count\":32,\"vendor_name\":\"Codisto\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/codisto\\/\",\"icon\":null},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982,\"rating\":3,\"reviews_count\":16,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Live Chat\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/live-chat\\/\",\"icon\":null},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481,\"rating\":4.8,\"reviews_count\":39,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259,\"rating\":2.9,\"reviews_count\":11,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652,\"rating\":4.5,\"reviews_count\":21,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729,\"rating\":4.6,\"reviews_count\":120,\"vendor_name\":\"StoreApps\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/storeapps\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/wc-icon-smart-coupons-160-p8fwgu.png\"},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate your WooCommerce store with 4000+ cloud apps and services today. Trusted by 11,000+ users.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589,\"rating\":4.4,\"reviews_count\":32,\"vendor_name\":\"OM4\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/om4\\/\",\"icon\":null},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Automate sales tax compliance for your multi-channel e-commerce business. Accurate sales tax calculations, data aggregation, quality reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"TaxJar\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/taxjar\\/\",\"icon\":null},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Sensei LMS Course Progress\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/sensei-course-progress.png\",\"excerpt\":\"Enable your students to easily see their progress and pick up where they left off in a course.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sensei-course-progress\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ec0f55d8fa7c517dc1844f5c873a77da\",\"slug\":\"sensei-course-progress\",\"id\":435833,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643,\"rating\":3.4,\"reviews_count\":27,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738,\"rating\":5,\"reviews_count\":51,\"vendor_name\":\"Backcourt Development\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/backcourt-development\\/\",\"icon\":null},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666,\"rating\":4.3,\"reviews_count\":27,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed rich product data to Google Merchant Center for setting up free product listings, product ads, and local inventory campaigns. Full control over your field mappings, and feed content so you can maximize campaign performance and ad spend.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619,\"rating\":4.3,\"reviews_count\":36,\"vendor_name\":\"Ademti Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/ademti-software\\/\",\"icon\":null},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on-time tax filing. No more tracking sales tax rates and rules.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/06\\/Composites_logo-8dctno.png\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836,\"rating\":4.9,\"reviews_count\":99,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Eway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/51456-Eway-logo-tagline-RGB-H-yellow-_-grey.png\",\"excerpt\":\"Take credit card payments securely via Eway (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/wc-paid-courses.png\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MyWorks Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/myworks-software\\/\",\"icon\":null},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/03\\/CSP_Logo-abcc0f.png\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253,\"rating\":4.8,\"reviews_count\":42,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Upgrade from Sequential Order Numbers with advanced features and with optional prefixes\\/suffixes.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497,\"rating\":4,\"reviews_count\":19,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174,\"rating\":4.4,\"reviews_count\":134,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Klarna Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Payments_Pink.png\",\"excerpt\":\"With Klarna Payments\\u00a0you can choose the payment that you want, Pay Now, Pay Later or Slice It. No credit card numbers, no passwords, no worries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnapayments\\/\",\"price\":\"&#36;0.00\",\"hash\":\"a19c689325bc8ea63c620765dd54b33a\",\"slug\":\"klarna-payments-for-woocommerce\",\"id\":2754217,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"Accept payment with First Data using the Payeezy Gateway, Payeezy, or legacy Global Gateway payment gateways.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"HubSpot for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/04\\/hubspotlogo-web-color-pxebeq.png\",\"excerpt\":\"Connect your WooCommerce store to HubSpot. Sync, automate &amp; analyze data with HubSpot WooCommerce Integration\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/hubspot-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e50acec8-3a6c-454c-8562-2da4898fa6c1\",\"slug\":\"hubspot-for-woocommerce\",\"id\":5785079,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MakeWebBetter\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/makewebbetter\\/\",\"icon\":null},{\"title\":\"Viva Wallet for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/04\\/Viva-Wallet-logo.png?w=374\",\"excerpt\":\"Integrate the Viva Wallet payment gateway with your WooCommerce store to process and sync your payments and help you sell more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/viva-wallet-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"7240a329-047f-4d8b-b7ec-ee3defd798bd\",\"slug\":\"viva-wallet-for-woocommerce\",\"id\":6137160,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Viva Wallet\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/viva-wallet\\/\",\"icon\":null},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Opayo Payment Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo Form, Opayo Direct or Opayo Pi. Supporting 3D Secure 2.0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Andrew Benbow\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/andrew-benbow\\/\",\"icon\":null}]}\";s:3:\"raw\";s:65988:\"HTTP/1.1 200 OK\r\nServer: nginx\r\nDate: Wed, 01 Dec 2021 07:23:02 GMT\r\nContent-Type: application/json; charset=UTF-8\r\nContent-Length: 12426\r\nConnection: close\r\nX-Robots-Tag: noindex\r\nLink: <https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\r\nX-Content-Type-Options: nosniff\r\nAccess-Control-Expose-Headers: X-WP-Total, X-WP-TotalPages, Link\r\nAccess-Control-Allow-Headers: Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\r\nX-WCCOM-Cache: HIT\r\nCache-Control: max-age=60\r\nAllow: GET\r\nX-rq: jnb1 0 4 9980\r\nContent-Encoding: gzip\r\nAge: 45\r\nX-Cache: hit\r\nVary: Accept-Encoding, Origin\r\nAccept-Ranges: bytes\r\nStrict-Transport-Security: max-age=31536000\r\n\r\n{\"products\":[{\"title\":\"WooCommerce Google Analytics\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/GA-Dark.png\",\"excerpt\":\"Understand your customers and increase revenue with world\\u2019s leading analytics platform - integrated with WooCommerce for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2d21f7de14dfb8e9885a4622be701ddf\",\"slug\":\"woocommerce-google-analytics-integration\",\"id\":1442927,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Tax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Tax-Dark.png\",\"excerpt\":\"Automatically calculate how much sales tax should be collected for WooCommerce orders - by city, country, or state - at checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/tax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":3220291,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Stripe\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Stripe-Dark-1.png\",\"excerpt\":\"Accept all major debit and credit cards as well as local payment methods with Stripe.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/stripe\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"50bb7a985c691bb943a9da4d2c8b5efd\",\"slug\":\"woocommerce-gateway-stripe\",\"id\":18627,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/12\\/stripe-app-icon-7m1xi7.png\"},{\"title\":\"Jetpack\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Jetpack-Dark.png\",\"excerpt\":\"Security, performance, and marketing tools made for WooCommerce stores by the WordPress experts. Get started with basic security and speed tools for free.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/jetpack\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"d5bfef9700b62b2b132c74c74c3193eb\",\"slug\":\"jetpack\",\"id\":2725249,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Jetpack\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/jetpack\\/\",\"icon\":null},{\"title\":\"Facebook for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Facebook-Dark.png\",\"excerpt\":\"Get the Official Facebook for WooCommerce plugin for three powerful ways to help grow your business.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/facebook\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"0ea4fe4c2d7ca6338f8a322fb3e4e187\",\"slug\":\"facebook-for-woocommerce\",\"id\":2127297,\"rating\":2.1,\"reviews_count\":51,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Pay-Dark.png\",\"excerpt\":\"Securely accept payments, track cash flow, and manage recurring revenue from your dashboard \\u2014 all without setup costs or monthly fees.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"8c6319ca-8f41-4e69-be63-6b15ee37773b\",\"slug\":\"woocommerce-payments\",\"id\":5278104,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/02\\/wcpay-icon-fv4tef.png\"},{\"title\":\"Amazon Pay\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Amazon-Pay-Dark.png\",\"excerpt\":\"Amazon Pay is embedded in your WooCommerce store. Transactions take place via\\u00a0Amazon widgets, so the buyer never leaves your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/pay-with-amazon\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9865e043bbbe4f8c9735af31cb509b53\",\"slug\":\"woocommerce-gateway-amazon-payments-advanced\",\"id\":238816,\"rating\":3.5,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Square for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Square-Dark.png\",\"excerpt\":\"Accepting payments is easy with Square. Clear rates, fast deposits (1-2 business days). Sell online and in person, and sync all payments, items and inventory.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/square\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e907be8b86d7df0c8f8e0d0020b52638\",\"slug\":\"woocommerce-square\",\"id\":1770503,\"rating\":3.2,\"reviews_count\":64,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Dark-1.png\",\"excerpt\":\"Print USPS and DHL labels right from your WooCommerce dashboard and instantly save up to 90%. WooCommerce Shipping is free to use and saves you time and money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"f31b3b9273cce188cc2b27f7849d02dd\",\"slug\":\"woocommerce-services\",\"id\":2165910,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscriptions\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Subscriptions-Dark.png\",\"excerpt\":\"Let customers subscribe to your products or services and pay on a weekly, monthly or annual basis.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscriptions\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"6115e6d7e297b623a169fdcf5728b224\",\"slug\":\"woocommerce-subscriptions\",\"id\":27147,\"rating\":3.6,\"reviews_count\":37,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Mailchimp for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/09\\/logo-mailchimp-dark-v2.png\",\"excerpt\":\"Increase traffic, drive repeat purchases, and personalize your marketing when you connect to Mailchimp.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/mailchimp-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"b4481616ebece8b1ff68fc59b90c1a91\",\"slug\":\"mailchimp-for-woocommerce\",\"id\":2545166,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Mailchimp\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/mailchimp\\/\",\"icon\":null},{\"title\":\"Product Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-Add-Ons-Dark.png\",\"excerpt\":\"Offer add-ons like gift wrapping, special messages or other special options for your products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"147d0077e591e16db9d0d67daeb8c484\",\"slug\":\"woocommerce-product-addons\",\"id\":18618,\"rating\":3.1,\"reviews_count\":19,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"ShipStation Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Shipstation-Dark.png\",\"excerpt\":\"Fulfill all your Woo orders (and wherever else you sell) quickly and easily using ShipStation. Try it free for 30 days today!\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipstation-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"9de8640767ba64237808ed7f245a49bb\",\"slug\":\"woocommerce-shipstation-integration\",\"id\":18734,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayFast Payment Gateway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Payfast-Dark-1.png\",\"excerpt\":\"Take payments on your WooCommerce store via PayFast (redirect method).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/payfast-payment-gateway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"557bf07293ad916f20c207c6c9cd15ff\",\"slug\":\"woocommerce-payfast-gateway\",\"id\":18596,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"USPS Shipping Method\",\"image\":\"\",\"excerpt\":\"Get shipping rates from the USPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/usps-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"83d1524e8f5f1913e58889f83d442c32\",\"slug\":\"woocommerce-shipping-usps\",\"id\":18657,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Listings &amp; Ads\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/06\\/marketplace-card.png\",\"excerpt\":\"Reach millions of engaged shoppers across Google with free product listings and ads. Built in partnership with Google.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-listings-and-ads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"118f4d86-f126-4c3a-8525-644e3170d161\",\"slug\":\"google-listings-and-ads\",\"id\":7623964,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"UPS Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/UPS-Shipping-Method-Dark.png\",\"excerpt\":\"Get shipping rates from the UPS API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ups-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8dae58502913bac0fbcdcaba515ea998\",\"slug\":\"woocommerce-shipping-ups\",\"id\":18665,\"rating\":3.4,\"reviews_count\":10,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Google Ads &amp; Marketing by Kliken\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/02\\/GA-for-Woo-Logo-374x192px-qu3duk.png\",\"excerpt\":\"Get in front of shoppers and drive traffic to your store so you can grow your business with Smart Shopping Campaigns and free listings.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-ads-and-marketing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"bf66e173-a220-4da7-9512-b5728c20fc16\",\"slug\":\"kliken-marketing-for-google\",\"id\":3866145,\"rating\":4.4,\"reviews_count\":109,\"vendor_name\":\"Kliken\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/kliken\\/\",\"icon\":null},{\"title\":\"Shipment Tracking\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Ship-Tracking-Dark-1.png\",\"excerpt\":\"Add shipment tracking information to your orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipment-tracking\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"1968e199038a8a001c9f9966fd06bf88\",\"slug\":\"woocommerce-shipment-tracking\",\"id\":18693,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Checkout Field Editor\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Checkout-Field-Editor-Dark.png\",\"excerpt\":\"Optimize your checkout process by adding, removing or editing fields to suit your needs.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-field-editor\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"2b8029f0d7cdd1118f4d843eb3ab43ff\",\"slug\":\"woocommerce-checkout-field-editor\",\"id\":184594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Table Rate Shipping\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Product-Table-Rate-Shipping-Dark.png\",\"excerpt\":\"Advanced, flexible shipping. Define multiple shipping rates based on location, price, weight, shipping class or item count.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/table-rate-shipping\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"3034ed8aff427b0f635fe4c86bbf008a\",\"slug\":\"woocommerce-table-rate-shipping\",\"id\":18718,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Dark.png\",\"excerpt\":\"Allow customers to book appointments, make reservations or rent equipment without leaving your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/hotel\\/\",\"price\":\"&#36;249.00\",\"hash\":\"911c438934af094c2b38d5560b9f50f3\",\"slug\":\"WooCommerce Bookings\",\"id\":390890,\"rating\":2.7,\"reviews_count\":18,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Braintree for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/02\\/braintree-black-copy.png\",\"excerpt\":\"Accept PayPal, credit cards and debit cards with a single payment gateway solution \\u2014 PayPal Powered by Braintree.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-paypal-powered-by-braintree\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"27f010c8e34ca65b205ddec88ad14536\",\"slug\":\"woocommerce-gateway-paypal-powered-by-braintree\",\"id\":1489837,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"PayPal Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/PPCP-Tile-PayPal-Logo-and-Cart-Art-2x-2-uozwz8.jpg\",\"excerpt\":\"PayPal\'s latest, all-in-one checkout solution. Securely accept PayPal Digital Payments, credit\\/debit cards and local payment methods.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paypal-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"934115ab-e3f3-4435-9580-345b1ce21899\",\"slug\":\"woocommerce-paypal-payments\",\"id\":6410731,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/10\\/pp_v_rgb-didybc.jpg\"},{\"title\":\"Min\\/Max Quantities\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Min-Max-Qua-Dark.png\",\"excerpt\":\"Specify minimum and maximum allowed product quantities for orders to be completed.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/minmax-quantities\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"2b5188d90baecfb781a5aa2d6abb900a\",\"slug\":\"woocommerce-min-max-quantities\",\"id\":18616,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Memberships\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/06\\/Thumbnail-Memberships-updated.png\",\"excerpt\":\"Power your membership association, online magazine, elearning sites, and more with access control to content\\/products and member discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-memberships\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;199.00\",\"hash\":\"9288e7609ad0b487b81ef6232efa5cfc\",\"slug\":\"woocommerce-memberships\",\"id\":958589,\"rating\":4.4,\"reviews_count\":78,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Product Bundles\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/07\\/Bundles_logo-0cllvb.png\",\"excerpt\":\"Offer personalized product bundles, bulk discount packages, and assembled\\u00a0products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-bundles\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa2518b5-ab19-4b75-bde9-60ca51e20f28\",\"slug\":\"woocommerce-product-bundles\",\"id\":18716,\"rating\":4.9,\"reviews_count\":112,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Australia Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/australia-post.gif\",\"excerpt\":\"Get shipping rates for your WooCommerce store from the Australia Post API, which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/australia-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1dbd4dc6bd91a9cda1bd6b9e7a5e4f43\",\"slug\":\"woocommerce-shipping-australia-post\",\"id\":18622,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Canada Post Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/canada-post.png\",\"excerpt\":\"Get shipping rates from the Canada Post Ratings API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/canada-post-shipping-method\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ac029cdf3daba20b20c7b9be7dc00e0e\",\"slug\":\"woocommerce-shipping-canada-post\",\"id\":18623,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"FedEx Shipping Method\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/01\\/FedEx_Logo_Wallpaper.jpeg\",\"excerpt\":\"Get shipping rates from the FedEx API which handles both domestic and international parcels.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/fedex-shipping-module\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1a48b598b47a81559baadef15e320f64\",\"slug\":\"woocommerce-shipping-fedex\",\"id\":18620,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Multichannel for WooCommerce: Google, Amazon, eBay &amp; Walmart Integration\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/10\\/Woo-Extension-Store-Logo-v2.png\",\"excerpt\":\"Get the official Google, Amazon, eBay and Walmart extension and create, sync and manage multichannel listings directly from WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-ebay-integration\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e4000666-9275-4c71-8619-be61fb41c9f9\",\"slug\":\"woocommerce-amazon-ebay-integration\",\"id\":3545890,\"rating\":3.2,\"reviews_count\":32,\"vendor_name\":\"Codisto\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/codisto\\/\",\"icon\":null},{\"title\":\"Product CSV Import Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Product-CSV-Import-Dark.png\",\"excerpt\":\"Import, merge, and export products and variations to and from WooCommerce using a CSV file.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-csv-import-suite\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"7ac9b00a1fe980fb61d28ab54d167d0d\",\"slug\":\"woocommerce-product-csv-import-suite\",\"id\":18680,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Follow-Ups\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Follow-Ups-Dark.png\",\"excerpt\":\"Automatically contact customers after purchase - be it everyone, your most loyal or your biggest spenders - and keep your store top-of-mind.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/follow-up-emails\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"05ece68fe94558e65278fe54d9ec84d2\",\"slug\":\"woocommerce-follow-up-emails\",\"id\":18686,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Royal Mail\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/04\\/royalmail.png\",\"excerpt\":\"Offer Royal Mail shipping rates to your customers\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/royal-mail\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"03839cca1a16c4488fcb669aeb91a056\",\"slug\":\"woocommerce-shipping-royalmail\",\"id\":182719,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Vendors\",\"image\":\"\",\"excerpt\":\"Turn your store into a multi-vendor marketplace\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-vendors\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"a97d99fccd651bbdd728f4d67d492c31\",\"slug\":\"woocommerce-product-vendors\",\"id\":219982,\"rating\":3,\"reviews_count\":16,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"LiveChat for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/11\\/LC_woo_regular-zmiaym.png\",\"excerpt\":\"Live Chat and messaging platform for sales and support -- increase average order value and overall sales through live conversations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/livechat\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.livechat.com\\/livechat-for-ecommerce\\/?a=woocommerce&amp;utm_source=woocommerce.com&amp;utm_medium=integration&amp;utm_campaign=woocommerce.com\",\"price\":\"&#36;0.00\",\"hash\":\"5344cc1f-ed4a-4d00-beff-9d67f6d372f3\",\"slug\":\"livechat-woocommerce\",\"id\":1348888,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Live Chat\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/live-chat\\/\",\"icon\":null},{\"title\":\"WooCommerce Accommodation Bookings\",\"image\":\"\",\"excerpt\":\"Book accommodation using WooCommerce and the WooCommerce Bookings extension.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-accommodation-bookings\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"99b2a7a4af90b6cefd2a733b3b1f78e7\",\"slug\":\"woocommerce-accommodation-bookings\",\"id\":1412069,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Authorize.Net\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2013\\/04\\/Thumbnail-Authorize.net-updated.png\",\"excerpt\":\"Authorize.Net gateway with support for pre-orders and subscriptions.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/authorize-net\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8b61524fe53add7fdd1a8d1b00b9327d\",\"slug\":\"woocommerce-gateway-authorize-net-cim\",\"id\":178481,\"rating\":4.8,\"reviews_count\":39,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Xero\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/xero2.png\",\"excerpt\":\"Save time with automated sync between WooCommerce and your Xero account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/xero\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"f0dd29d338d3c67cf6cee88eddf6869b\",\"slug\":\"woocommerce-xero\",\"id\":18733,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Brands\",\"image\":\"\",\"excerpt\":\"Create, assign and list brands for products, and allow customers to view by brand.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/brands\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"8a88c7cbd2f1e73636c331c7a86f818c\",\"slug\":\"woocommerce-brands\",\"id\":18737,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"AutomateWoo\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-AutomateWoo-Dark-1.png\",\"excerpt\":\"Powerful marketing automation for WooCommerce. AutomateWoo has the tools you need to grow your store and make more money.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/automatewoo\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"ba9299b8-1dba-4aa0-a313-28bc1755cb88\",\"slug\":\"automatewoo\",\"id\":4652610,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Advanced Notifications\",\"image\":\"\",\"excerpt\":\"Easily setup \\\"new order\\\" and stock email notifications for multiple recipients of your choosing.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/advanced-notifications\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"112372c44b002fea2640bd6bfafbca27\",\"slug\":\"woocommerce-advanced-notifications\",\"id\":18740,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Points and Rewards\",\"image\":\"\",\"excerpt\":\"Reward your customers for purchases and other actions with points which can be redeemed for discounts.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-points-and-rewards\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"1649b6cca5da8b923b01ca56b5cdd246\",\"slug\":\"woocommerce-points-and-rewards\",\"id\":210259,\"rating\":2.9,\"reviews_count\":11,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Pre-Orders\",\"image\":\"\",\"excerpt\":\"Allow customers to order products before they are available.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-pre-orders\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"b2dc75e7d55e6f5bbfaccb59830f66b7\",\"slug\":\"woocommerce-pre-orders\",\"id\":178477,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Customer \\/ Order \\/ Coupon Export\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-Customer-Order-Coupon-Export-updated.png\",\"excerpt\":\"Export customers, orders, and coupons from WooCommerce manually or on an automated schedule.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/ordercustomer-csv-export\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"914de15813a903c767b55445608bf290\",\"slug\":\"woocommerce-customer-order-csv-export\",\"id\":18652,\"rating\":4.5,\"reviews_count\":21,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Additional Variation Images\",\"image\":\"\",\"excerpt\":\"Add gallery images per variation on variable products within WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-additional-variation-images\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/themes.woocommerce.com\\/storefront\\/product\\/woo-single-1\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c61dd6de57dcecb32bd7358866de4539\",\"slug\":\"woocommerce-additional-variation-images\",\"id\":477384,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Subscription Downloads\",\"image\":\"\",\"excerpt\":\"Offer additional downloads to your subscribers, via downloadable products listed in your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-subscription-downloads\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5be9e21c13953253e4406d2a700382ec\",\"slug\":\"woocommerce-subscription-downloads\",\"id\":420458,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Deposits\",\"image\":\"\",\"excerpt\":\"Enable customers to pay for products using a deposit or a payment plan.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-deposits\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;179.00\",\"hash\":\"de192a6cf12c4fd803248da5db700762\",\"slug\":\"woocommerce-deposits\",\"id\":977087,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Smart Coupons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/10\\/wc-product-smart-coupons.png\",\"excerpt\":\"Everything you need for discounts, coupons, credits, gift cards, product giveaways, offers, and promotions. Most popular and complete coupons plugin for WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/smart-coupons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demo.storeapps.org\\/?demo=sc\",\"price\":\"&#36;99.00\",\"hash\":\"05c45f2aa466106a466de4402fff9dde\",\"slug\":\"woocommerce-smart-coupons\",\"id\":18729,\"rating\":4.6,\"reviews_count\":120,\"vendor_name\":\"StoreApps\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/storeapps\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/08\\/wc-icon-smart-coupons-160-p8fwgu.png\"},{\"title\":\"Amazon S3 Storage\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/09\\/amazon.png\",\"excerpt\":\"Serve digital products via Amazon S3\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/amazon-s3-storage\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"473bf6f221b865eff165c97881b473bb\",\"slug\":\"woocommerce-amazon-s3-storage\",\"id\":18663,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Cart Add-ons\",\"image\":\"\",\"excerpt\":\"A powerful tool for driving incremental and impulse purchases by customers once they are in the shopping cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/cart-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"3a8ef25334396206f5da4cf208adeda3\",\"slug\":\"woocommerce-cart-add-ons\",\"id\":18717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Shipping Multiple Addresses\",\"image\":\"\",\"excerpt\":\"Allow your customers to ship individual items in a single order to multiple addresses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/shipping-multiple-addresses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"aa0eb6f777846d329952d5b891d6f8cc\",\"slug\":\"woocommerce-shipping-multiple-addresses\",\"id\":18741,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Zapier\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/woocommerce-zapier-logo.png\",\"excerpt\":\"Integrate your WooCommerce store with 4000+ cloud apps and services today. Trusted by 11,000+ users.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-zapier\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;59.00\",\"hash\":\"0782bdbe932c00f4978850268c6cfe40\",\"slug\":\"woocommerce-zapier\",\"id\":243589,\"rating\":4.4,\"reviews_count\":32,\"vendor_name\":\"OM4\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/om4\\/\",\"icon\":null},{\"title\":\"Bulk Stock Management\",\"image\":\"\",\"excerpt\":\"Edit product and variation stock levels in bulk via this handy interface\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bulk-stock-management\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"02f4328d52f324ebe06a78eaaae7934f\",\"slug\":\"woocommerce-bulk-stock-management\",\"id\":18670,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Email Customizer\",\"image\":\"\",\"excerpt\":\"Connect with your customers with each email you send by visually modifying your email templates via the WordPress Customizer.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-email-customizer\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"bd909fa97874d431f203b5336c7e8873\",\"slug\":\"woocommerce-email-customizer\",\"id\":853277,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"TaxJar\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/10\\/taxjar-logotype.png\",\"excerpt\":\"Automate sales tax compliance for your multi-channel e-commerce business. Accurate sales tax calculations, data aggregation, quality reporting, and filing for your WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/taxjar\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"12072d8e-e933-4561-97b1-9db3c7eeed91\",\"slug\":\"taxjar-simplified-taxes-for-woocommerce\",\"id\":514914,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"TaxJar\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/taxjar\\/\",\"icon\":null},{\"title\":\"Force Sells\",\"image\":\"\",\"excerpt\":\"Force products to be added to the cart\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/force-sells\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"3ebddfc491ca168a4ea4800b893302b0\",\"slug\":\"woocommerce-force-sells\",\"id\":18678,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Quick View\",\"image\":\"\",\"excerpt\":\"Show a quick-view button to view product details and add to cart via lightbox popup\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-quick-view\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"619c6e57ce72c49c4b57e15b06eddb65\",\"slug\":\"woocommerce-quick-view\",\"id\":187509,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Purchase Order Gateway\",\"image\":\"\",\"excerpt\":\"Receive purchase orders via your WooCommerce-powered online store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gateway-purchase-order\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"573a92318244ece5facb449d63e74874\",\"slug\":\"woocommerce-gateway-purchase-order\",\"id\":478542,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Returns and Warranty Requests\",\"image\":\"\",\"excerpt\":\"Manage the RMA process, add warranties to products &amp; let customers request &amp; manage returns \\/ exchanges from their account.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/warranty-requests\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"9b4c41102e6b61ea5f558e16f9b63e25\",\"slug\":\"woocommerce-warranty\",\"id\":228315,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Box Office\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-BO-Dark.png\",\"excerpt\":\"Sell tickets for your next event, concert, function, fundraiser or conference directly on your own site\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-box-office\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"e704c9160de318216a8fa657404b9131\",\"slug\":\"woocommerce-box-office\",\"id\":1628717,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Product Enquiry Form\",\"image\":\"\",\"excerpt\":\"Allow visitors to contact you directly from the product details page via a reCAPTCHA protected form to enquire about a product.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/product-enquiry-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"5a0f5d72519a8ffcc86669f042296937\",\"slug\":\"woocommerce-product-enquiry-form\",\"id\":18601,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Sensei LMS Course Progress\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/sensei-course-progress.png\",\"excerpt\":\"Enable your students to easily see their progress and pick up where they left off in a course.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sensei-course-progress\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ec0f55d8fa7c517dc1844f5c873a77da\",\"slug\":\"sensei-course-progress\",\"id\":435833,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Barcodes\",\"image\":\"\",\"excerpt\":\"Generates a unique barcode for each order on your site - perfect for e-tickets, packing slips, reservations and a variety of other uses.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-barcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"889835bb29ee3400923653e1e44a3779\",\"slug\":\"woocommerce-order-barcodes\",\"id\":391708,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Dynamic Pricing\",\"image\":\"\",\"excerpt\":\"Bulk discounts, role-based pricing and much more\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/dynamic-pricing\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"9a41775bb33843f52c93c922b0053986\",\"slug\":\"woocommerce-dynamic-pricing\",\"id\":18643,\"rating\":3.4,\"reviews_count\":27,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"WooCommerce 360\\u00ba Image\",\"image\":\"\",\"excerpt\":\"An easy way to add a dynamic, controllable 360\\u00ba image rotation to your WooCommerce site, by adding a group of images to a product\\u2019s gallery.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-360-image\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"24eb2cfa3738a66bf3b2587876668cd2\",\"slug\":\"woocommerce-360-image\",\"id\":512186,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Name Your Price\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2012\\/09\\/nyp-icon-dark-v83owf.png\",\"excerpt\":\"Allow customers to define the product price. Also useful for accepting user-set donations.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/name-your-price\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"31b4e11696cd99a3c0572975a84f1c08\",\"slug\":\"woocommerce-name-your-price\",\"id\":18738,\"rating\":5,\"reviews_count\":51,\"vendor_name\":\"Backcourt Development\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/backcourt-development\\/\",\"icon\":null},{\"title\":\"WooCommerce Photography\",\"image\":\"\",\"excerpt\":\"Sell photos in the blink of an eye using this simple as dragging &amp; dropping interface.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-photography\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"ee76e8b9daf1d97ca4d3874cc9e35687\",\"slug\":\"woocommerce-photography\",\"id\":583602,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Bookings Availability\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Woo-Bookings-Aval-Dark.png\",\"excerpt\":\"Sell more bookings by presenting a calendar or schedule of available slots in a page or post.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/bookings-availability\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"30770d2a-e392-4e82-baaa-76cfc7d02ae3\",\"slug\":\"woocommerce-bookings-availability\",\"id\":4228225,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Software Add-on\",\"image\":\"\",\"excerpt\":\"Sell License Keys for Software\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/software-add-on\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"79f6dbfe1f1d3a56a86f0509b6d6b04b\",\"slug\":\"woocommerce-software-add-on\",\"id\":18683,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Products Compare\",\"image\":\"\",\"excerpt\":\"WooCommerce Products Compare will allow your potential customers to easily compare products within your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-products-compare\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"c3ba0a4a3199a0cc7a6112eb24414548\",\"slug\":\"woocommerce-products-compare\",\"id\":853117,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Store Catalog PDF Download\",\"image\":\"\",\"excerpt\":\"Offer your customers a PDF download of your product catalog, generated by WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-store-catalog-pdf-download\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"79ca7aadafe706364e2d738b7c1090c4\",\"slug\":\"woocommerce-store-catalog-pdf-download\",\"id\":675790,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Print Invoices &amp; Packing lists\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/03\\/Thumbnail-Print-Invoices-Packing-lists-updated.png\",\"excerpt\":\"Generate invoices, packing slips, and pick lists for your WooCommerce orders.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/print-invoices-packing-lists\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"465de1126817cdfb42d97ebca7eea717\",\"slug\":\"woocommerce-pip\",\"id\":18666,\"rating\":4.3,\"reviews_count\":27,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Klarna Checkout\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Checkout_Black-1.png\",\"excerpt\":\"Klarna Checkout is a full checkout experience embedded on your site that includes all popular payment methods (Pay Now, Pay Later, Financing, Installments).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnacheckout\\/\",\"price\":\"&#36;0.00\",\"hash\":\"90f8ce584e785fcd8c2d739fd4f40d78\",\"slug\":\"klarna-checkout-for-woocommerce\",\"id\":2754152,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"Google Product Feed\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2011\\/11\\/logo-regular-lscryp.png\",\"excerpt\":\"Feed rich product data to Google Merchant Center for setting up free product listings, product ads, and local inventory campaigns. Full control over your field mappings, and feed content so you can maximize campaign performance and ad spend.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/google-product-feed\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d55b4f852872025741312839f142447e\",\"slug\":\"woocommerce-product-feeds\",\"id\":18619,\"rating\":4.3,\"reviews_count\":36,\"vendor_name\":\"Ademti Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/ademti-software\\/\",\"icon\":null},{\"title\":\"WooCommerce AvaTax\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-Avalara-updated.png\",\"excerpt\":\"Get 100% accurate sales tax calculations and on-time tax filing. No more tracking sales tax rates and rules.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-avatax\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"57077a4b28ba71cacf692bcf4a1a7f60\",\"slug\":\"woocommerce-avatax\",\"id\":1389326,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Composite Products\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/06\\/Composites_logo-8dctno.png\",\"excerpt\":\"Create product kit builders and custom product configurators using existing products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/composite-products\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;99.00\",\"hash\":\"0343e0115bbcb97ccd98442b8326a0af\",\"slug\":\"woocommerce-composite-products\",\"id\":216836,\"rating\":4.9,\"reviews_count\":99,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Gravity Forms Product Add-ons\",\"image\":\"\",\"excerpt\":\"Powerful product add-ons, Gravity style\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/gravity-forms-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/gravity-forms\\/\",\"price\":\"&#36;99.00\",\"hash\":\"a6ac0ab1a1536e3a357ccf24c0650ed0\",\"slug\":\"woocommerce-gravityforms-product-addons\",\"id\":18633,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"PayPal Payments Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/06\\/Logo-Paypal-Payments-Pro-Dark.png\",\"excerpt\":\"Take credit card payments directly on your checkout using PayPal Pro.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/paypal-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"6d23ba7f0e0198937c0029f9e865b40e\",\"slug\":\"woocommerce-gateway-paypal-pro\",\"id\":18594,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Eway\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/51456-Eway-logo-tagline-RGB-H-yellow-_-grey.png\",\"excerpt\":\"Take credit card payments securely via Eway (SG, MY, HK, AU, and NZ) keeping customers on your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/eway\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"2c497769d98d025e0d340cd0b5ea5da1\",\"slug\":\"woocommerce-gateway-eway\",\"id\":18604,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Paid Courses\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2021\\/07\\/wc-paid-courses.png\",\"excerpt\":\"Sell your online courses using the most popular eCommerce platform on the web \\u2013 WooCommerce.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-paid-courses\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;129.00\",\"hash\":\"bad2a02a063555b7e2bee59924690763\",\"slug\":\"woothemes-sensei\",\"id\":152116,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Automattic\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/automattic\\/\",\"icon\":null},{\"title\":\"QuickBooks Sync for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2019\\/04\\/woocommerce-com-logo-1-hyhzbh.png\",\"excerpt\":\"Automatic two-way sync for orders, customers, products, inventory and more between WooCommerce and QuickBooks (Online, Desktop, or POS).\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/quickbooks-sync-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c5e32e20-7c1f-4585-8b15-d930c2d842ac\",\"slug\":\"myworks-woo-sync-for-quickbooks-online\",\"id\":4065824,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MyWorks Software\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/myworks-software\\/\",\"icon\":null},{\"title\":\"WooCommerce Blocks\",\"image\":\"\",\"excerpt\":\"WooCommerce Blocks offers a range of Gutenberg blocks you can use to build and customise your site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-gutenberg-products-block\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"c2e9f13a-f90c-4ffe-a8a5-b432399ec263\",\"slug\":\"woo-gutenberg-products-block\",\"id\":3076677,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Catalog Visibility Options\",\"image\":\"\",\"excerpt\":\"Transform WooCommerce into an online catalog by removing eCommerce functionality\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/catalog-visibility-options\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"12e791110365fdbb5865c8658907967e\",\"slug\":\"woocommerce-catalog-visibility-options\",\"id\":18648,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Conditional Shipping and Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/03\\/CSP_Logo-abcc0f.png\",\"excerpt\":\"Use conditional logic to restrict the shipping and payment options available on your store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/conditional-shipping-and-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"1f56ff002fa830b77017b0107505211a\",\"slug\":\"woocommerce-conditional-shipping-and-payments\",\"id\":680253,\"rating\":4.8,\"reviews_count\":42,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"WooCommerce Order Status Manager\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2015\\/02\\/Thumbnail-Order-Status-Manager-updated.png\",\"excerpt\":\"Create, edit, and delete completely custom order statuses and integrate them seamlessly into your order management flow.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-manager\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"51fd9ab45394b4cad5a0ebf58d012342\",\"slug\":\"woocommerce-order-status-manager\",\"id\":588398,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Sequential Order Numbers Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/05\\/Thumbnail-Sequential-Order-Numbers-Pro-updated.png\",\"excerpt\":\"Tame your order numbers! Upgrade from Sequential Order Numbers with advanced features and with optional prefixes\\/suffixes.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sequential-order-numbers-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;49.00\",\"hash\":\"0b18a2816e016ba9988b93b1cd8fe766\",\"slug\":\"woocommerce-sequential-order-numbers-pro\",\"id\":18688,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Google Analytics Pro\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2016\\/01\\/Thumbnail-GAPro-updated.png\",\"excerpt\":\"Add advanced event tracking and enhanced eCommerce tracking to your WooCommerce site.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-google-analytics-pro\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"d8aed8b7306b509eec1589e59abe319f\",\"slug\":\"woocommerce-google-analytics-pro\",\"id\":1312497,\"rating\":4,\"reviews_count\":19,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Checkout Add-Ons\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/07\\/Thumbnail-Checkout-Add-Ons-updated.png\",\"excerpt\":\"Highlight relevant products, offers like free shipping and other up-sells during checkout.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-checkout-add-ons\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"8fdca00b4000b7a8cc26371d0e470a8f\",\"slug\":\"woocommerce-checkout-add-ons\",\"id\":466854,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Coupon Shortcodes\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2013\\/09\\/woocommerce-coupon-shortcodes-product-image-1870x960-1-vc5gux.png\",\"excerpt\":\"Show coupon discount info using shortcodes. Allows to render coupon information and content conditionally, based on the validity of coupons.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/coupon-shortcodes\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"ac5d9d51-70b2-4d8f-8b89-24200eea1394\",\"slug\":\"woocommerce-coupon-shortcodes\",\"id\":244762,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce Product Search\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2014\\/10\\/woocommerce-product-search-product-image-1870x960-1-jvsljj.png\",\"excerpt\":\"The perfect search engine helps customers to find and buy products quickly \\u2013 essential for every WooCommerce store.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-product-search\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.itthinx.com\\/wps\\/\",\"price\":\"&#36;49.00\",\"hash\":\"c84cc8ca16ddac3408e6b6c5871133a8\",\"slug\":\"woocommerce-product-search\",\"id\":512174,\"rating\":4.4,\"reviews_count\":134,\"vendor_name\":\"itthinx\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/itthinx\\/\",\"icon\":null},{\"title\":\"WooCommerce One Page Checkout\",\"image\":\"\",\"excerpt\":\"Create special pages where customers can choose products, checkout &amp; pay all on the one page.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-one-page-checkout\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"c9ba8f8352cd71b5508af5161268619a\",\"slug\":\"woocommerce-one-page-checkout\",\"id\":527886,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"WooCommerce\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/woocommerce\\/\",\"icon\":null},{\"title\":\"Klarna Payments\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2018\\/01\\/Partner_marketing_Klarna_Payments_Pink.png\",\"excerpt\":\"With Klarna Payments\\u00a0you can choose the payment that you want, Pay Now, Pay Later or Slice It. No credit card numbers, no passwords, no worries.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/klarna-payments\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/demo.krokedil.se\\/klarnapayments\\/\",\"price\":\"&#36;0.00\",\"hash\":\"a19c689325bc8ea63c620765dd54b33a\",\"slug\":\"klarna-payments-for-woocommerce\",\"id\":2754217,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Krokedil\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/krokedil\\/\",\"icon\":null},{\"title\":\"First Data\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2012\\/02\\/Thumbnail-FirstData-updated.png\",\"excerpt\":\"Accept payment with First Data using the Payeezy Gateway, Payeezy, or legacy Global Gateway payment gateways.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/firstdata\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"eb3e32663ec0810592eaf0d097796230\",\"slug\":\"woocommerce-gateway-firstdata\",\"id\":18645,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"WooCommerce Order Status Control\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/06\\/Thumbnail-Order-Status-Control-updated.png\",\"excerpt\":\"Use this extension to automatically change the order status to \\\"completed\\\" after successful payment.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-order-status-control\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;29.00\",\"hash\":\"32400e509c7c36dcc1cd368e8267d981\",\"slug\":\"woocommerce-order-status-control\",\"id\":439037,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"HubSpot for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2020\\/04\\/hubspotlogo-web-color-pxebeq.png\",\"excerpt\":\"Connect your WooCommerce store to HubSpot. Sync, automate &amp; analyze data with HubSpot WooCommerce Integration\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/hubspot-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"e50acec8-3a6c-454c-8562-2da4898fa6c1\",\"slug\":\"hubspot-for-woocommerce\",\"id\":5785079,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"MakeWebBetter\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/makewebbetter\\/\",\"icon\":null},{\"title\":\"Viva Wallet for WooCommerce\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2020\\/04\\/Viva-Wallet-logo.png?w=374\",\"excerpt\":\"Integrate the Viva Wallet payment gateway with your WooCommerce store to process and sync your payments and help you sell more.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/viva-wallet-for-woocommerce\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;0.00\",\"hash\":\"7240a329-047f-4d8b-b7ec-ee3defd798bd\",\"slug\":\"viva-wallet-for-woocommerce\",\"id\":6137160,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Viva Wallet\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/viva-wallet\\/\",\"icon\":null},{\"title\":\"WooCommerce Social Login\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2014\\/08\\/Thumbnail-Social-Login-updated.png\",\"excerpt\":\"Enable Social Login for seamless checkout and account creation.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/woocommerce-social-login\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"http:\\/\\/demos.skyverge.com\\/woocommerce-social-login\\/\",\"price\":\"&#36;79.00\",\"hash\":\"b231cd6367a79cc8a53b7d992d77525d\",\"slug\":\"woocommerce-social-login\",\"id\":473617,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"SkyVerge\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/skyverge\\/\",\"icon\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/woocommerce_uploads\\/2015\\/06\\/skyverge-wc-icon-b2vhw6.png\"},{\"title\":\"Variation Swatches and Photos\",\"image\":\"\",\"excerpt\":\"Show color and image swatches instead of dropdowns for variable products.\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/variation-swatches-and-photos\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"https:\\/\\/www.elementstark.com\\/woocommerce-extension-demos\\/product-category\\/swatches-and-photos\\/\",\"price\":\"&#36;99.00\",\"hash\":\"37bea8d549df279c8278878d081b062f\",\"slug\":\"woocommerce-variation-swatches-and-photos\",\"id\":18697,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Element Stark\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/element-stark\\/\",\"icon\":null},{\"title\":\"Opayo Payment Suite\",\"image\":\"https:\\/\\/woocommerce.com\\/wp-content\\/uploads\\/2011\\/10\\/Opayo_logo_RGB.png\",\"excerpt\":\"Take payments on your WooCommerce store via Opayo Form, Opayo Direct or Opayo Pi. Supporting 3D Secure 2.0\",\"link\":\"https:\\/\\/woocommerce.com\\/products\\/sage-pay-form\\/?utm_source=extensionsscreen&utm_medium=product&utm_campaign=wcaddons\",\"demo_url\":\"\",\"price\":\"&#36;79.00\",\"hash\":\"6bc0cca47d0274d8ef9b164f6fbec1cc\",\"slug\":\"woocommerce-gateway-sagepay-form\",\"id\":18599,\"rating\":null,\"reviews_count\":null,\"vendor_name\":\"Andrew Benbow\",\"vendor_url\":\"https:\\/\\/woocommerce.com\\/vendor\\/andrew-benbow\\/\",\"icon\":null}]}\";s:7:\"headers\";O:25:\"Requests_Response_Headers\":1:{s:7:\"\0*\0data\";a:19:{s:6:\"server\";a:1:{i:0;s:5:\"nginx\";}s:4:\"date\";a:1:{i:0;s:29:\"Wed, 01 Dec 2021 07:23:02 GMT\";}s:12:\"content-type\";a:1:{i:0;s:31:\"application/json; charset=UTF-8\";}s:14:\"content-length\";a:1:{i:0;s:5:\"12426\";}s:12:\"x-robots-tag\";a:1:{i:0;s:7:\"noindex\";}s:4:\"link\";a:1:{i:0;s:60:\"<https://woocommerce.com/wp-json/>; rel=\"https://api.w.org/\"\";}s:22:\"x-content-type-options\";a:1:{i:0;s:7:\"nosniff\";}s:29:\"access-control-expose-headers\";a:1:{i:0;s:33:\"X-WP-Total, X-WP-TotalPages, Link\";}s:28:\"access-control-allow-headers\";a:1:{i:0;s:73:\"Authorization, X-WP-Nonce, Content-Disposition, Content-MD5, Content-Type\";}s:13:\"x-wccom-cache\";a:1:{i:0;s:3:\"HIT\";}s:13:\"cache-control\";a:1:{i:0;s:10:\"max-age=60\";}s:5:\"allow\";a:1:{i:0;s:3:\"GET\";}s:4:\"x-rq\";a:1:{i:0;s:13:\"jnb1 0 4 9980\";}s:16:\"content-encoding\";a:1:{i:0;s:4:\"gzip\";}s:3:\"age\";a:1:{i:0;s:2:\"45\";}s:7:\"x-cache\";a:1:{i:0;s:3:\"hit\";}s:4:\"vary\";a:1:{i:0;s:23:\"Accept-Encoding, Origin\";}s:13:\"accept-ranges\";a:1:{i:0;s:5:\"bytes\";}s:25:\"strict-transport-security\";a:1:{i:0;s:16:\"max-age=31536000\";}}}s:11:\"status_code\";i:200;s:16:\"protocol_version\";d:1.100000000000000088817841970012523233890533447265625;s:7:\"success\";b:1;s:9:\"redirects\";i:0;s:3:\"url\";s:59:\"https://woocommerce.com/wp-json/wccom-extensions/1.0/search\";s:7:\"history\";a:0:{}s:7:\"cookies\";O:19:\"Requests_Cookie_Jar\":1:{s:10:\"\0*\0cookies\";a:0:{}}}s:11:\"\0*\0filename\";N;s:4:\"data\";N;s:7:\"headers\";N;s:6:\"status\";N;}}", "no");
INSERT INTO `HhhEP_options` VALUES("3445", "_transient_timeout_wpseo-statistics-totals", "1638429782", "no");
INSERT INTO `HhhEP_options` VALUES("3446", "_transient_wpseo-statistics-totals", "a:1:{i:1;a:2:{s:6:\"scores\";a:2:{i:0;a:4:{s:8:\"seo_rank\";s:2:\"ok\";s:5:\"label\";s:45:\"Posts with the SEO score: <strong>OK</strong>\";s:5:\"count\";i:1;s:4:\"link\";s:121:\"https://dev.africanwildlifevets.xcontent.com/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=ok\";}i:1;a:4:{s:8:\"seo_rank\";s:4:\"good\";s:5:\"label\";s:47:\"Posts with the SEO score: <strong>Good</strong>\";s:5:\"count\";i:2;s:4:\"link\";s:123:\"https://dev.africanwildlifevets.xcontent.com/wp-admin/edit.php?post_status=publish&#038;post_type=post&#038;seo_filter=good\";}}s:8:\"division\";a:5:{s:3:\"bad\";i:0;s:2:\"ok\";d:0.333333333333333314829616256247390992939472198486328125;s:4:\"good\";d:0.66666666666666662965923251249478198587894439697265625;s:2:\"na\";i:0;s:7:\"noindex\";i:0;}}}", "no");
INSERT INTO `HhhEP_options` VALUES("3447", "_site_transient_timeout_community-events-96e8962b3b7da79d368ec3957c842e72", "1638386582", "no");
INSERT INTO `HhhEP_options` VALUES("3448", "_site_transient_community-events-96e8962b3b7da79d368ec3957c842e72", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:11:\"169.0.114.0\";}s:6:\"events\";a:1:{i:0;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:22:\"WordCamp Taiwan Online\";s:3:\"url\";s:33:\"https://taiwan.wordcamp.org/2021/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2021-12-11 13:00:00\";s:8:\"end_date\";s:19:\"2021-12-12 00:00:00\";s:20:\"start_unix_timestamp\";i:1639198800;s:18:\"end_unix_timestamp\";i:1639238400;s:8:\"location\";a:4:{s:8:\"location\";s:6:\"Online\";s:7:\"country\";s:2:\"TW\";s:8:\"latitude\";d:25.032963599999998649536792072467505931854248046875;s:9:\"longitude\";d:121.5654267999999973426383803598582744598388671875;}}}}", "no");
INSERT INTO `HhhEP_options` VALUES("3449", "_transient_timeout_feed_9bbd59226dc36b9b26cd43f15694c5c3", "1638386584", "no");
INSERT INTO `HhhEP_options` VALUES("3450", "_transient_feed_9bbd59226dc36b9b26cd43f15694c5c3", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:79:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"News –  – WordPress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"https://wordpress.org/news\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"The latest news about WordPress and the WordPress community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Dec 2021 03:18:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=5.9-beta1-52296\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:20:{i:0;a:6:{s:4:\"data\";s:60:\"\n		\n		\n		\n		\n		\n				\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:20:\"WordPress 5.9 Beta 1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/news/2021/11/wordpress-5-9-beta-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Nov 2021 23:35:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"Releases\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11584\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:307:\"WordPress 5.9 Beta 1 is now available for testing! This version of the WordPress software is under development. You don’t want to run this version on a production site. Instead, it is recommended that you run this on a test site. This will allow you to test out the new version. You can test the [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10992:\"\n<p>WordPress 5.9 Beta 1 is now available for testing!</p>\n\n\n\n<p><strong>This version of the WordPress software is under development</strong>. You don’t want to run this version on a production site. Instead, it is recommended that you run this on a test site. This will allow you to test out the new version.</p>\n\n\n\n<p>You can test the WordPress 5.9 Beta 1 in three ways:</p>\n\n\n\n<ul><li>Option 1: Install and activate the<a href=\"https://wordpress.org/plugins/wordpress-beta-tester/\"> WordPress Beta Tester</a> plugin (select the “Bleeding edge” channel and “Beta/RC Only” stream).</li><li>Option 2: Direct download the <a href=\"https://wordpress.org/wordpress-5.9-beta1.zip\">beta version here (zip)</a>.</li><li>Option 3: Use WP-CLI to test: <code>wp core update --version=5.9-beta1</code>. <strong><em>Do not use this option if your filesystem is case-insensitive.</em></strong></li></ul>\n\n\n\n<p>The current target for the final release is January 25, 2021, which is just eight weeks away. Your help testing this version is vital to make sure the release is as good as it can be.</p>\n\n\n\n<p>Check the <a href=\"https://make.wordpress.org/core/\">Make WordPress Core blog</a> for <a href=\"https://make.wordpress.org/core/tag/5-9+dev-notes/\">5.9-related developer notes</a> in the coming weeks which will break down all upcoming changes in greater detail.</p>\n\n\n\n<h2 id=\"how-you-can-help-testing\"><strong>How You Can Help – Testing!</strong></h2>\n\n\n\n<p>Testing for bugs is a critical part of polishing the release in the beta stage. It is also a great way to contribute. If you’ve never tested a beta release before, <a href=\"https://make.wordpress.org/test/2021/11/30/help-test-wordpress-5-9-features/\">this detailed guide will help</a> walk you through what and how to test.</p>\n\n\n\n<p>If you think you’ve found a bug, please report it to the <a href=\"https://wordpress.org/support/forum/alphabeta/\">Alpha/Beta area</a> in the support forums. If you’re comfortable writing a reproducible bug report, <a href=\"https://core.trac.wordpress.org/newticket\">file one on WordPress Trac</a>. That’s also where you can find a list of <a href=\"https://core.trac.wordpress.org/tickets/major\">known bugs</a>.</p>\n\n\n\n<p>To see every feature in the Gutenberg releases since WordPress 5.8, check out the What’s New In Gutenberg posts for <a href=\"https://make.wordpress.org/core/2021/06/10/whats-new-in-gutenberg-10-8-9-june/\">10.8</a>, <a href=\"https://make.wordpress.org/core/2021/06/24/whats-new-in-gutenberg-10-9-23-june/\">10.9</a>, <a href=\"https://make.wordpress.org/core/2021/07/09/whats-new-in-gutenberg-11-0-0-9-july/\">11.0</a>, <a href=\"https://make.wordpress.org/core/2021/07/21/whats-new-in-gutenberg-11-1-0-21-july/\">11.1</a>, <a href=\"https://make.wordpress.org/core/2021/08/05/whats-new-in-gutenberg-11-2-0-4-august/\">11.2</a>, <a href=\"https://make.wordpress.org/core/2021/08/18/whats-new-in-gutenberg-11-3-18-august/\">11.3</a>, <a href=\"https://make.wordpress.org/core/2021/09/01/whats-new-in-gutenberg-11-4-1-september/\">11.4</a>, <a href=\"https://make.wordpress.org/core/2021/09/17/whats-new-in-gutenberg-11-5-16-september/\">11.5</a>, <a href=\"https://make.wordpress.org/core/2021/10/01/whats-new-in-gutenberg-11-6-29-september/\">11.6</a>, <a href=\"https://make.wordpress.org/core/2021/10/14/whats-new-in-gutenberg-11-7-october-13th/\">11.7</a>, <a href=\"https://make.wordpress.org/core/2021/10/28/whats-new-in-gutenberg-11-8-0-27-october/\">11.8</a>, and <a href=\"https://make.wordpress.org/core/2021/11/12/whats-new-in-gutenberg-11-9-0-10-november/\">11.9</a>.&nbsp;</p>\n\n\n\n<p>Beyond the noted changes, which include 580 enhancements and nearly 450 bug fixes, contributors have fixed <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;milestone=5.9&amp;group=component&amp;max=500&amp;col=id&amp;col=summary&amp;col=owner&amp;col=type&amp;col=priority&amp;col=component&amp;col=version&amp;order=priority\">297 tickets for WordPress 5.9</a>, including <a href=\"https://core.trac.wordpress.org/query?status=closed&amp;status=reopened&amp;type=enhancement&amp;type=feature+request&amp;milestone=5.9&amp;col=id&amp;col=summary&amp;col=type&amp;col=status&amp;col=milestone&amp;col=owner&amp;col=priority&amp;col=changetime&amp;col=keywords&amp;order=changetime\">110 new features and enhancements</a>. More fixes are on the way.</p>\n\n\n\n<p>Happy testing!</p>\n\n\n\n<p><em>Want to know what’s new in version 5.9? Read on for some highlights.</em></p>\n\n\n\n<hr class=\"wp-block-separator\" />\n\n\n\n<h2 id=\"full-site-editing\"><strong><strong>Full Site Editing</strong></strong></h2>\n\n\n\n<h3 id=\"styles-interface\">The <strong>Styles Interface</strong></h3>\n\n\n\n<p>Combine all the features that went live in 5.8 with those making their entrance in 5.9, and you get <strong>Full Site Editing.</strong></p>\n\n\n\n<p>Formerly known as Global Styles, the Styles Interface lets you interact directly with your blocks and elements right in the WordPress Admin. From typography to color palettes, this cohesive design interface means a design change—even a dramatic one—can happen without a theme switch. <strong>No code needed.</strong></p>\n\n\n\n<h3 id=\"theme-json\"><strong>Theme.json</strong></h3>\n\n\n\n<p>Introduced in WordPress 5.8, theme.json has been improved to enable features and default styles for your site and its blocks. With 5.9, theme.json can support child themes and the duotone treatment. Coordinate layers of style with theme.json, taking the weight off of your theme’s required CSS.</p>\n\n\n\n<p>Other features supported by theme.json include: </p>\n\n\n\n<ul><li><strong>Border:</strong> color, style, and width augment the border-radius property that landed in 5.8.</li><li><strong>Flex layouts:</strong> Block Gap support, courtesy of spacing.blockGap.</li><li><strong>Typography:</strong> font families, font style, font weight, text decoration, and text transform.</li><li><strong>Images</strong>: Duotones.</li></ul>\n\n\n\n<h3 id=\"a-new-navigation-block\"><strong>A New Navigation Block</strong></h3>\n\n\n\n<p>Welcome to the most intuitive way to build navigation: the Navigation Block.&nbsp;</p>\n\n\n\n<p>Here are the features that need testing the most:</p>\n\n\n\n<ul><li>Responsive menu options you can turn off, have always on, or opt to use only for small screens.</li><li>Built-in keyboard accessibility.&nbsp; For accessibility, for speed, or both.</li><li>Add extra blocks like Search and Site Icon blocks (and customize them to your liking).</li><li>Submenu items with styling options.</li><li>Horizontal or vertical alignment.</li><li>Reusable navigation? Even across themes? Yes. Because the Navigation Block you build gets saved as a custom post type.</li></ul>\n\n\n\n<h3 id=\"a-better-gallery-block\"><strong>A Better Gallery Block</strong></h3>\n\n\n\n<p>What if you could treat single images in your Gallery Block the same way you treat the Image Block? <strong>Now you can.</strong></p>\n\n\n\n<p> Make every image in your gallery different from the next, with inline cropping or a duotone and change layouts with the ease of drag and drop. With the improved gallery block, every image is its own Image block.</p>\n\n\n\n<p><strong>One thing to note: </strong>Have you built a plugin or theme on the Gallery Block functionality?<a href=\"https://make.wordpress.org/core/2021/08/20/gallery-block-refactor-dev-note/\"> Be sure to review this Dev Note, which details what you need to do for compatibility</a>.</p>\n\n\n\n<h3 id=\"focused-template-part-mode\"><strong>Focused Template Part Mode</strong></h3>\n\n\n\n<p>Building template parts can take a level of focus all its own because you’re making decisions for the entire site. So WordPress 5.9 adds a focus mode that shows you only the part you’re working on right now (and you can get back to the regular view with a keystroke).&nbsp;</p>\n\n\n\n<h3 id=\"block-pattern-directory\"><strong>Block Pattern Directory</strong></h3>\n\n\n\n<p>The <a href=\"https://wordpress.org/patterns/\">Pattern Directory</a> offers a range of prebuilt block patterns, from a couple of blocks that show an image and text, to an entire page layout with columns and sections. Since the 5.8 release, the directory has become a hub for exploratory UI and patterns, taking submissions and offering them to the community. So now, your creation can help other people build out their perfect site.</p>\n\n\n\n<h2 id=\"twenty-twenty-two-default-theme\"><strong>Twenty Twenty-Two Default Theme</strong></h2>\n\n\n\n<p><strong>A whole new way of building WordPress themes.</strong></p>\n\n\n\n<p>WordPress 5.9 introduces features that make Full Site Editing possible, including <strong>the first default block theme</strong>.</p>\n\n\n\n<p>Using minimal CSS, theme styles reside in theme.json so that you can configure them in the Styles interface of the WordPress Admin. Make this theme take on its own personality site-wide, with a wide array of color schemes, type combinations, page templates, premade components (forms), and image treatments to choose from.</p>\n\n\n\n<h2 id=\"more-improvements-and-updates\"><strong>More Improvements and Updates</strong></h2>\n\n\n\n<ul><li>Do you love to blog? New tweaks to the publishing flow let you add new posts just seconds after hitting Publish on your latest post.</li><li>List View lets you drag and drop content as easily as you could always cruise through it – and collapse entire sections – so you can concentrate on a task or get the bigger picture.</li><li><a href=\"https://github.com/WordPress/gutenberg/pull/33955\">The Buttons and Social icons blocks now absorb</a> and display their parent block’s toolbar controls.&nbsp;&nbsp;</li><li><a href=\"https://core.trac.wordpress.org/ticket/43700\">Choose your language</a> on the login screen.</li><li>More <a href=\"https://github.com/WordPress/gutenberg/pull/33868\">performance improvements</a> (i.e., speed).</li></ul>\n\n\n\n<p><em>Props to <a href=\'https://profiles.wordpress.org/chanthaboune/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>chanthaboune</a>, <a href=\'https://profiles.wordpress.org/priethor/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>priethor</a>, <a href=\'https://profiles.wordpress.org/psykro/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>psykro</a>, <a href=\'https://profiles.wordpress.org/annezazu/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>annezazu</a>, <a href=\'https://profiles.wordpress.org/webcommsat/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>webcommsat</a>, <a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>, <a href=\'https://profiles.wordpress.org/hellofromtonya/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>hellofromtonya</a>, <a href=\'https://profiles.wordpress.org/davidbaumwald/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>davidbaumwald</a>, and <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a> for their research and copy.</em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11584\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:72:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"People of WordPress: Devin Maeztri\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/news/2021/11/people-of-wordpress-devin-maeztri/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 30 Nov 2021 22:21:09 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:6:{i:0;a:5:{s:4:\"data\";s:9:\"Community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:10:\"Interviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"Contributor Story\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"Indonesia\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:19:\"People of WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:5;a:5:{s:4:\"data\";s:20:\"Polyglot Contributor\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11678\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Devin Maeztri, a campaigner from Indonesia talks about the difference WordPress makes in her life and her work.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:28:\"webcommsat AbhaNonStopNewsUK\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16547:\"\n<p>In this series, we share some of the inspiring stories of how WordPress and its global network of contributors can change people&#8217;s lives for the better. This month we feature a translator and campaigner who uses WordPress to highlight good causes and helps people in her area benefit from the open source platform.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img width=\"632\" height=\"843\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat.jpg?resize=632%2C843&#038;ssl=1\" alt=\"Devin pictured with one of her cats\" class=\"wp-image-11690\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?resize=768%2C1024&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?resize=225%2C300&amp;ssl=1 225w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?resize=1152%2C1536&amp;ssl=1 1152w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?resize=1536%2C2048&amp;ssl=1 1536w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?w=1920&amp;ssl=1 1920w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-with-her-cat-scaled.jpg?w=1264&amp;ssl=1 1264w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure></div>\n\n\n\n<p>Going to a WordCamp can be a life-changing experience, as Devin Maeztri discovered. Every event she attends is a further step on a journey of discovering the WordPress community and its many opportunities.</p>\n\n\n\n<figure class=\"wp-block-pullquote\"><blockquote><p>“It is not that hard to fall for WordPress if you have a chance to experience WordPress. For me, it took a WordCamp.”</p><cite>Devin Maeztri</cite></blockquote></figure>\n\n\n\n<p>Devin&#8217;s first experience with camps came when she volunteered impromptu at an Indonesian event, WordCamp Denpasar, Bali in 2016.&nbsp;</p>\n\n\n\n<p>Here, she made a profound discovery: “WordCamps can bring people who will give back to the community, even if they don’t get anything from WordPress directly.”</p>\n\n\n\n<p>With every WordCamp after that first experience, she became more interested in WordPress and the community.&nbsp;</p>\n\n\n\n<p>Over time, Devin found she wanted to be part of WordPress events more often. She became a regular at Meetups in Ubud and Jakarta, joining as a co-organizer at WordCamp Jakarta in 2017 and 2019. Later, she took on the role of co-organizer for Meetups in Jakarta and Ubud.&nbsp;</p>\n\n\n\n<p>Smitten by what WordCamps can offer and how they can bring people together across national borders, she joined the organizing team for WordCamp Asia 2020. Sadly, this event was to become the first major WordPress event to be cancelled in the COVID-19 pandemic.&nbsp;</p>\n\n\n\n<p>Naturally, Devin hopes WordCamp Asia will happen someday very soon. Beyond the expected WordPress learning and sharing that event will promote, she believes its very scale will showcase how WordCamps add international tourism and cultural understanding everywhere they take place.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img loading=\"lazy\" width=\"632\" height=\"632\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/11/wcasia_2020_organizers_in_wceu_2019.jpeg?resize=632%2C632&#038;ssl=1\" alt=\"Devin pictured with other WordCamp Asia organizers who attended WordCamp Europe in 2019\" class=\"wp-image-11692\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/11/wcasia_2020_organizers_in_wceu_2019.jpeg?w=1024&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/11/wcasia_2020_organizers_in_wceu_2019.jpeg?resize=300%2C300&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/11/wcasia_2020_organizers_in_wceu_2019.jpeg?resize=150%2C150&amp;ssl=1 150w, https://i1.wp.com/wordpress.org/news/files/2021/11/wcasia_2020_organizers_in_wceu_2019.jpeg?resize=768%2C768&amp;ssl=1 768w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /><figcaption>WordCamp Asia 2020 Organizers at WordCamp Europe 2019. Devin is pictured in the front row, second from left. Photo Credit: Abha Thakor</figcaption></figure></div>\n\n\n\n<h2 id=\"showing-how-wordpress-can-be-used-locally\">Showing how WordPress can be used locally</h2>\n\n\n\n<p>After experiencing several events, Devin had questions: “At WordCamps and Meetups, you hear stories about how WordPress powers the web. How it changes the lives of so many people, how it helps dreams come true. It made me think, considering WordPress is that powerful, why are there not even more people in Indonesia using websites, and more using WordPress? Why aren’t more talented Indonesian WordPress users, developers, designers, and business owners taking part in WordPress.org projects? Language, for me, was the main answer.”</p>\n\n\n\n<p>The solution Devin felt was to make WordPress available in the main local language. She said: “I believe, the more content translated into Indonesian, the more Indonesian WordPress users see WordPress as more than just a blogging platform or a content management system. They will realize it’s a huge open source community that works together to make the web a better place. The more plugins and themes translated, the easier the work of the developer and designer will be. The more people see how WordPress can enhance their life, the better the ecosystem for business owners becomes.”</p>\n\n\n\n<h3 id=\"encouraging-others-to-translate-wordpress\">Encouraging others to translate WordPress</h3>\n\n\n\n<p>After talking with others about how WordPress could be even more useful in Indonesia, Devin felt she had to make a personal commitment to reviving the polyglot project in Indonesia. With another volunteer contributor and through promotion, the local polyglot team got bigger and the interest in translation grew. She also took on the responsibility of a General Translation Editor for the language.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img loading=\"lazy\" width=\"632\" height=\"318\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/11/featured-img-used-for-devin-pow2.jpg?resize=632%2C318&#038;ssl=1\" alt=\"Polyglot nominatee - Devin Maeztri\" class=\"wp-image-11706\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/11/featured-img-used-for-devin-pow2.jpg?resize=1024%2C515&amp;ssl=1 1024w, https://i1.wp.com/wordpress.org/news/files/2021/11/featured-img-used-for-devin-pow2.jpg?resize=300%2C151&amp;ssl=1 300w, https://i1.wp.com/wordpress.org/news/files/2021/11/featured-img-used-for-devin-pow2.jpg?resize=768%2C386&amp;ssl=1 768w, https://i1.wp.com/wordpress.org/news/files/2021/11/featured-img-used-for-devin-pow2.jpg?w=1247&amp;ssl=1 1247w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /></figure>\n\n\n\n<p>Through the efforts of Devin and the other translation editors, Indonesia took part in <a href=\"https://wptranslationday.org/\">WordPress Translation Day</a> in 2020, and in 2021 held sprints and learning sessions spanning the whole 30 days of the event. </p>\n\n\n\n<p>Her enthusiasm and dedication to helping others translate WordPress locally and promoting the global community were recognized in the Polyglot Appreciation Nominations for 2021. </p>\n\n\n\n<h2 id=\"helping-to-give-access-to-more-diverse-audiences\">Helping to give access to more diverse audiences</h2>\n\n\n\n<p>Through her involvement in translation, Devin noticed there were not many women involved in the WordPress community in Indonesia. Often, she found herself the only woman at an event.</p>\n\n\n\n<p>So, along with a couple of community members, she started Perempuan WordPress, a local initiative. This group is open for everyone to join, but prioritizes women as event speakers.</p>\n\n\n\n<p>Devin has gone on to support the work of the Diversity Speaker Training group in the Community Team, translating materials and promoting initiatives in Indonesia.&nbsp;She is keen to encourage others to get involved with this initiative which helps increase the diversity of presenters at Meetups and WordCamps. </p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-full\"><img loading=\"lazy\" width=\"600\" height=\"534\" src=\"https://i1.wp.com/wordpress.org/news/files/2021/11/devin-at-wc-jakarta2019.png?resize=600%2C534&#038;ssl=1\" alt=\"\" class=\"wp-image-11689\" srcset=\"https://i1.wp.com/wordpress.org/news/files/2021/11/devin-at-wc-jakarta2019.png?w=600&amp;ssl=1 600w, https://i1.wp.com/wordpress.org/news/files/2021/11/devin-at-wc-jakarta2019.png?resize=300%2C267&amp;ssl=1 300w\" sizes=\"(max-width: 600px) 100vw, 600px\" data-recalc-dims=\"1\" /><figcaption><em>Organizing at WordCamp Jakarta 2019</em></figcaption></figure></div>\n\n\n\n<p>In her professional roles, Devin is an advocate for WordPress as a tool for people with a wide variety of skill sets. She does not code, but uses the platform extensively for her projects. In 2014, she signed up for a free account on WordPress.com to keep and share notes about what she saw or was thinking about as she commuted on public transport to work. This site did not turn into a blog, but instead introduced her to other opportunities and the vast capabilities of the platform.</p>\n\n\n\n<h2 id=\"wordpress-can-support-your-skills-and-passions\">WordPress can support your skills and passions</h2>\n\n\n\n<p>With a background in environmental activism, Devin has worked for international development organizations on everything from policymaking to campaigning.&nbsp;</p>\n\n\n\n<p>Behind the desk, she worked with policymakers and organized conferences and meetings. That meant doing a lot of writing and translating and working with people on the ground who were impacted by the policies. “My work on the ground usually involved researching, movement building and community empowerment,” she noted.</p>\n\n\n\n<p>Her work with events inspired Devin to get involved in WordCamps and Meetups and share her energy for making things happen. As in her professional work, she felt WordPress was an opportunity to work and share with people about something that can make a positive impact on someone else’s life.</p>\n\n\n\n<p>“For me, everything comes from the heart. I do things that I feel so strongly about. Things that call me, and things that I am good at but still giving me room to learn and become better at. WordPress can be the perfect place for this.”</p>\n\n\n\n<p>While she was between jobs, Devin was encouraged to volunteer at WordCamp Denpasar 2016. With some help, she created an online CV. She also learned to manage a WordPress site, navigate the wp-admin, and make the content appeal to potential employers.&nbsp;</p>\n\n\n\n<p>She eventually got a job as a campaigner to build a movement online and offline. The brainchild of many university friends in America, who used digital campaigns to go global, the campaign used WordPress.&nbsp;</p>\n\n\n\n<p>Devin worked alongside a digital campaigner and helped shape the content, the call to action, and the user experience. She also had to use the wp-admin to make some amendments. As a global movement, it developed its resources in English, so she also reviewed the work of the translators she worked with.</p>\n\n\n\n<div class=\"wp-block-image\"><figure class=\"aligncenter size-large\"><img loading=\"lazy\" width=\"632\" height=\"474\" src=\"https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation.jpg?resize=632%2C474&#038;ssl=1\" alt=\"One of Devin\'s cats watches the WPTranslationDay 2021 livestreamed events.\" class=\"wp-image-11688\" srcset=\"https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?resize=1024%2C768&amp;ssl=1 1024w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?resize=300%2C225&amp;ssl=1 300w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?resize=768%2C576&amp;ssl=1 768w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?resize=1536%2C1152&amp;ssl=1 1536w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?resize=2048%2C1536&amp;ssl=1 2048w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?w=1264&amp;ssl=1 1264w, https://i2.wp.com/wordpress.org/news/files/2021/11/cat-watching-translation-scaled.jpg?w=1896&amp;ssl=1 1896w\" sizes=\"(max-width: 632px) 100vw, 632px\" data-recalc-dims=\"1\" /><figcaption>Devin&#8217;s cat became a regular on social media posts about #WPTranslationDay 2021</figcaption></figure></div>\n\n\n\n<p>She left her job as a campaigner at the end of 2018 to concentrate on freelancing – and to spend more of her free time contributing to the WordPress community. She also took up the initiative to help street cats in Jakarta.&nbsp;</p>\n\n\n\n<p>Devin said: “So, I am busy helping these cats but also learning how to fundraise using a website. I’m learning to use online forms, set up a payment service provider, work on SEO, and do other new things I need to learn to grow my initiative. I do have the privilege to learn directly from a personal guru. The same person who convinced me to volunteer at WordCamp Denpasar, and who I married in 2018.”</p>\n\n\n\n<h2 id=\"wordpress-gives-everyone-a-chance-to-learn\">WordPress gives everyone a chance to learn</h2>\n\n\n\n<p>Devin was so enthused by being a contributor for WordPress, she took part in the video shorts following the Translation Day events.</p>\n\n\n\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-16-9 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"632\" height=\"356\" src=\"https://www.youtube.com/embed/VsiQzdmAz8g?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div><figcaption>Devin talks about translating in this short <a rel=\"noreferrer noopener\" href=\"https://www.youtube.com/watch?v=VsiQzdmAz8g\" target=\"_blank\">video</a> (opens in a new tab on YouTube)</figcaption></figure>\n\n\n\n<p>She is also active in other Contributor Teams and decided to become a Community Team Deputy to support meetups in new cities across Indonesia and perhaps future WordCamps.&nbsp;</p>\n\n\n\n<p>She said: “One of the things that I like about WordPress is that it is very welcoming and open to people like me, who don’t code at all. At the same time, it shows me a different way of looking at the world.”</p>\n\n\n\n<p>Devin believes in the power of WordPress to give ‘everyone a chance to learn new things’ and allows her to contribute and share her knowledge and experience. “By contributing, I hope to make a difference in someone’s life. I hope they feel the benefit of using WordPress and want to give back to create a healthier WordPress community.”</p>\n\n\n\n<h2 id=\"contributors\">Contributors</h2>\n\n\n\n<p>Thank you to Abha Thakor (<a href=\"https://profiles.wordpress.org/webcommsat/\">@</a><a href=\"https://profiles.wordpress.org/webcommsat/\" data-type=\"URL\" data-id=\"https://profiles.wordpress.org/webcommsat/\">webcommsat</a>) and Mary Baum (<a href=\'https://profiles.wordpress.org/marybaum/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>marybaum</a>) for the interviews and writing this feature, and to Devin Maeztri (<a href=\"https://profiles.wordpress.org/devinmaeztri/\">@devinmaeztri</a>) for sharing her story. Thanks to Meher Bala (<a href=\"https://profiles.wordpress.org/meher/\">@meher</a>) for work on the images, and to Chloé Bringmann (<a href=\"https://profiles.wordpress.org/cbringmann/\">@cbringmann</a>) and Collieth Clarke (<a href=\'https://profiles.wordpress.org/callye/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>callye</a>) for proofing.</p>\n\n\n\n<p>Thanks to Josepha Haden Chomphosy&nbsp;(@<a href=\"https://profiles.wordpress.org/chanthaboune/\">chanthaboune</a>) and Topher DeRosia (<a href=\"https://profiles.wordpress.org/topher1kenobe/\">@topher1kenobe</a>) for their support for the series.</p>\n\n\n\n<p><em>This People of WordPress feature is inspired by an essay originally published on </em><a href=\"https://heropress.com/\"><em>HeroPress.com</em></a><em>, a community initiative created by Topher DeRosia. It highlights people in the WordPress community who have overcome barriers and whose stories might otherwise go unheard. </em>#HeroPress #ContributorStory</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11678\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:55:\"\n		\n		\n		\n		\n		\n				\n\n					\n										\n					\n		\n		\n\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"WP Briefing: Episode 21: All Things Block Themes!\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://wordpress.org/news/2021/11/episode-21-all-things-block-themes/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 29 Nov 2021 12:07:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/news/?post_type=podcast&p=11636\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:436:\"In episode 21 of the WordPress Briefing, Executive Director, Josepha Haden Chomphosy, talks all things block themes with developers and theme specialists Maggie Cabrera and Jeff Ong. Have a question you&#8217;d like answered? You can submit them to wpbriefing@wordpress.org, either written or as a voice recording. Credits Editor:&#160;Dustin Hartzler Logo:&#160;Beatriz Fialho Production:&#160;Chloé Bringmann Song: Fearless [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"enclosure\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:3:\"url\";s:60:\"https://wordpress.org/news/files/2021/11/WP-Briefing-021.mp3\";s:6:\"length\";s:1:\"0\";s:4:\"type\";s:0:\"\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"Chloe Bringmann\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:26887:\"\n<p>In episode 21 of the WordPress Briefing, Executive Director, Josepha Haden Chomphosy, talks all things block themes with developers and theme specialists Maggie Cabrera and Jeff Ong.</p>\n\n\n\n<p><em><strong>Have a question you&#8217;d like answered? You can submit them to <a href=\"mailto:wpbriefing@wordpress.org\">wpbriefing@wordpress.org</a>, either written or as a voice recording.</strong></em></p>\n\n\n\n<h2 id=\"credits\">Credits</h2>\n\n\n\n<ul><li>Editor:&nbsp;<a href=\"https://profiles.wordpress.org/dustinhartzler/\">Dustin Hartzler</a></li><li>Logo:&nbsp;<a href=\"https://profiles.wordpress.org/beafialho/\">Beatriz Fialho</a></li><li>Production:&nbsp;<a href=\"https://profiles.wordpress.org/cbringmann/\">Chloé Bringmann</a></li><li>Song: Fearless First by Kevin MacLeod</li></ul>\n\n\n\n<h2 id=\"references\">References </h2>\n\n\n\n<ul><li><a href=\"https://make.wordpress.org/core/2021/11/17/wordpress-5-9-beta-1-delayed/\">5.9 Beta 1 Delay Announcement </a></li><li><a href=\"https://make.wordpress.org/core/2021/11/22/wordpress-5-9-revised-release-schedule/\">5.9 Revised Release Schedule</a></li><li><a href=\"https://sevilla.wordcamp.org/2021/\">WordCamp Sevilla 2021</a></li><li>Charitable Giving: <ul><li><a href=\"https://wordpressfoundation.org/donate/\">WordPress Foundation</a></li><li><a href=\"https://donate.bigorangeheart.org/\">Big Orange Heart</a></li><li><a href=\"https://heropressnetwork.com/support/\">HeroPress</a> <em>(Update: This organization is not a non-profit.)</em></li></ul></li></ul>\n\n\n\n<h2 id=\"transcript\">Transcript</h2>\n\n\n\n<span id=\"more-11636\"></span>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:11</p>\n\n\n\n<p>Hello, everyone, and welcome to the WordPress Briefing, the podcast where you can catch quick explanations of the ideas behind the WordPress open source project, some insight into the community that supports it, and get a small list of big things coming up in the next two weeks. I&#8217;m your host, Josepha Haden Chomphosy. See, here we go!</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>00:40</p>\n\n\n\n<p>Well, today, folks, in our podcast, I am joined by a couple of special guests. I know it&#8217;s been a bit since I&#8217;ve had a guest, so I&#8217;m very excited to introduce you to who I have with me today. Today, I have <a href=\"https://profiles.wordpress.org/onemaggie/\">Maggie Cabrera</a> and <a href=\"https://profiles.wordpress.org/jffng/\">Jeff Ong</a>. They both are working on themes, and especially the future of themes as we move into this low code, no code block based experience of editing things in WordPress. And there have been so many questions lately about what does the landscape of being a theme developer turns into once we move fully into this excellent promise of user empowerment for Gutenberg? I figured who best to come and talk to us about that than these two. So welcome, Maggie. Welcome, Jeff. I&#8217;m really excited to have this conversation with you today.</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>01:39</p>\n\n\n\n<p>Thank you for having us. Excited to be here.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>01:45</p>\n\n\n\n<p>I&#8217;m just gonna hop right in, and we will see what happens. The first thing that I want to chat about, I hear so many questions and so much discussion about patterns in a lot of different places. Like obviously, the work that I helped to steward the most is around like the Block Pattern directory and various other user-facing tools. And so I have never really been able to give a really solid answer about like patterns and how they work inside themes. And so I wondered if you all had anything that you could offer to our listeners to help clarify what is the power of patterns inside themes in the future? Implementation of themes?</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>02:34</p>\n\n\n\n<p>I can try to start unless, Maggie? Okay. Well, if you take a look at what I&#8217;ve been doing for the last couple of months working on Twenty Twenty-Two. And if you look at that theme, it&#8217;s mostly just the collection of patterns. Patterns. As you know, if you read the description, the theme, it&#8217;s designed to be the most flexible and kind of like flexible theme ever, dare I say ever created.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>03:04</p>\n\n\n\n<p>I think you can dare to say it.&nbsp;</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>03:03</p>\n\n\n\n<p>And, you know, I think a huge part of that is because of the Full Site Editing being launched, introduced in 5.9. And also that theme itself ships with all of these patterns in it that work with the overall design, but really can be configured to your own kind of unique liking and kind of taste and ultimately, what you want to accomplish, whether that&#8217;s I want to make a portfolio, I want to make, you know, a single-page website promoting like my podcast, or there are patterns for that kind of shipping with the theme. And they&#8217;ve all been kind of designed and tailored to work with the typography choices at a baseline level with the color choices at a baseline level, but can very easily be tweaked. And you can kind of rely on them to work with the editor. And I guess, kind of zooming out for a little bit, not just about Twenty-Twenty Two.&nbsp;</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>04:04</p>\n\n\n\n<p>But like patterns as this idea that a theme, hopefully, what it is, it&#8217;s a collection of different design options or layout options that are ultimately presented as patterns to the user, the patterns are just a really easy way to basically say &#8220;I want you this layout, like two columns of text or with like some images here.&#8221; Basically, a theme becomes a way of packaging the patterns together in a way that feels like a coherent piece of a coherent website. And I think that&#8217;s a pretty powerful idea. I know that the patterns directory is also opening up making those patterns pretty widely available. But I think a theme you could think of as like a curation of those patterns in a way that makes sense. And I think Twenty-Twenty Two is a really good example. I mean, I&#8217;m biased.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>05:03</p>\n\n\n\n<p>I also think it&#8217;s a good example. Maggie, did you have anything that you wanted to add to that?</p>\n\n\n\n<p><strong>Maggie Cabrera&nbsp; </strong>05:08</p>\n\n\n\n<p>Yeah, What I really like about patterns is how it empowers the user, even if they don&#8217;t really have like a deep knowledge of code, or they&#8217;re not used to the more complex blocks. When the theme developer gives you this pattern about using the query block, for example, it lays out your posts in a very compelling manner. And you can edit it if you want it or just use it out of the box. And you have this dynamic blog that it&#8217;s, like, such a big important part of your website. Like if you want to have a page where you have, you have maybe a podcast website, and you want to showcase your podcasts differently than your regular blog posts. So you can use a different gray pattern for that. And it&#8217;s like, really, really easy to use, even if you&#8217;re not familiar with it.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:07</p>\n\n\n\n<p>One of the things that I have found compelling about this new version of themes and kind of the way that themes are planning to look in the future; it&#8217;s going to be like a super throwback, so everyone get ready for me to sound old, my guests and my listeners alike. It reminds me of my original days of blogging on the web. I was not a developer and even though I had this really short stint of working with JavaScript in my career, at some point. Like no one actually would ever look to me and be like, that one is excellent at design and fixing everything with code, like I was just killer at searching for the right pieces of code, right.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>06:57</p>\n\n\n\n<p>And so I remember sitting there on Zynga, which is, of course, now powered by WordPress, I absolutely just went out and found bundles of code that are now what we would consider themes and modified the small pieces that I needed to change in order to like really suit what I wanted to have happen on the site at the time. And they&#8217;re like, I knew I could break it all. Really easily. But also, it was, it was not scary to think about breaking it. Like it was clear how I could fix it if I really broke it. The content, like what I had written, was separate from everything to do with the way that it was looking. And so like, I wouldn&#8217;t destroy all of my work, just because I didn&#8217;t put a semicolon in the right place, or whatever it was in that moment. And so like, this future of themes really reminds me of this a lot where someone has curated how it can look how it should look. And you can just like add in modular pieces that will augment what was already intended, but still kind of work. And if it&#8217;s not gonna work, it&#8217;s kind of easy to fix too. So like, I&#8217;m excited. That was a really exciting time in my learning of the web and certainly was formative in my career, as we all now see. And so yeah, I think that&#8217;s really exciting.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>08:20</p>\n\n\n\n<p>I did have actually another question that this conversation has kind of brought up for me. I have, obviously just use the term modular, which no one has ever used in the context of themes for WordPress. And I know that there is a lot there are a lot of terms kind of wandering around about themes right now. And especially as we&#8217;re moving into what themes can look like in the future. There was block based theme as a term for a while. And now it&#8217;s block themes. There was like this floating around the term, universal themes. And now we&#8217;re looking at just like block themes forever. And so I wondered if y&#8217;all could give us a just like a clear understanding of these terms that had been being used and maybe are going out of fashion? Like, are they important for us to keep knowing?</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>09:11</p>\n\n\n\n<p>So yes, the history of terms around themes. And obviously, even my knowledge only goes back so far. But it was around when we started doing the block based themes meeting. And trying to I think that&#8217;s where that term kind of came from is like, oh, let&#8217;s, let&#8217;s start talking about this idea that themes can be completely made up out of blocks. And what does that mean?&nbsp;</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>09:33</p>\n\n\n\n<p>I think over time, it wasn&#8217;t just block themes, because, you know, previously, there were themes and even default themes that used and took into account the fact that blocks existed. So there was some confusion there. Enough time has gone on where we focus on this idea that themes whose templates are ultimately made out of blocks are block themes. And to me, it&#8217;s kind of as simple as that. Its themes that supply a set of templates that previously in the past were a collection of PHP and various template tags and whatnot is all transitioned to themes made up including other blocks, as well as themes that supply styles through theme.json configuration instead of supplying it in raw CSS. To me this idea is really crystallizing around like this is a block theme, one that is really, at its core, supplying a set of templates, and styles through a language that WordPress understands natively, and can allow it to be configured and customized in a really powerful way. And then maybe someday in the future, they&#8217;ll just be called themes again. If we do a good enough they will just be called themes.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>10:57</p>\n\n\n\n<p>I&#8217;m gonna, I&#8217;m gonna take us into a philosophical area now that you&#8217;ve just put us in there. You said, someday they&#8217;ll be called Themes. Again, I&#8217;ve talked about this on this podcast a few times. And for anyone who&#8217;s worked with me for any length of time, like you all probably heard this from me as well. But like, adjectives are so frequently the realm of things that are not what you expect, right? Because like you have coffee, and then decaf coffee, no one&#8217;s like caffeinated coffee, because that&#8217;s what you expect out of it. And so when you&#8217;re like themes, and block themes, it makes it look like block themes are secondary, which at the moment, they are, ish. But in the future, I think you&#8217;re probably right, there will be a time when the modifier isn&#8217;t necessary anymore because it will be hopefully a much better way for people to kind of change the way that their themes work and make it more usable for users and people who are, you know, having to manage their own site without necessarily wanting to or being able to, like, have a Maggie in the room to fix everything that they break.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>12:08</p>\n\n\n\n<p>Maggie is nowhere near me. And so she&#8217;s never been in the room when I&#8217;ve broken anything. But I believe that Maggie on one occasion, at least, has come in and helped me fix something that I definitely broke. I&#8217;m an excellent breaker of WordPress things. Maggie, did you have anything you wanted to add to that question?&nbsp;</p>\n\n\n\n<p>12:29</p>\n\n\n\n<p>Yeah, I guess, maybe clarify a bit, what universal themes are because, yeah, maybe some people have heard about the term but they don&#8217;t really know what they are. And maybe just clarify that. The term was born when developing block themes wasn&#8217;t something that you could actually do for production websites like you could build them to test some experiments, but they weren&#8217;t really ready for users to use. So universal themes want to grasp the power of love themes while still being ready for users. So the way they do it is they are block based, like we used to call them in the sense that the templates are made of blocks. But they are also able to be customized using the customizer, which is the old way of customizing themes, instead of using the site editor. So they can have a balance between two worlds between the worlds of classic themes and block themes. But they are, at heart, a temporary concept. They are bound to be blocked themes in the future, but with maybe a foot in the past, where they can actually serve users who are not ready for full-on site editor. But they are bound to be full block themes in the future.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>14:00</p>\n\n\n\n<p>There&#8217;s a really interesting concept in there. So universal themes, it sounds like are basically kind of like an on-ramp for people who are not really ready to fully commit to this for any number of reasons. Like we never want to say that we know the reason that people would be a little bit shy to get started with this. But like it&#8217;s kind of like an on-ramp, it&#8217;s a safe way to get back to something that they do know, in the event that what they don&#8217;t know, really hinders their progress makes it hard for them to get the work done.</p>\n\n\n\n<p><strong>Maggie Cabrera&nbsp; </strong>14:31</p>\n\n\n\n<p>I think I wouldn&#8217;t say that they are for people shyer to get into new stuff rather than developers who want to embrace the new stuff before it&#8217;s even really ready. They really want to embrace the power of the blocks instead of doing things the old way. But even if it&#8217;s not fully ready.</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>14:54</p>\n\n\n\n<p>They still need to support the old way of doing things.</p>\n\n\n\n<p><strong>Maggie Cabrera&nbsp; </strong>14:58</p>\n\n\n\n<p>Like being backward compatible and being ready for any kind of user.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>15:05</p>\n\n\n\n<p>So mostly for developers, everyone who heard me just talking about how it was a great thing for users, ignore it. </p>\n\n\n\n<p><strong>Maggie Cabrera&nbsp; </strong>15:12</p>\n\n\n\n<p>It&#8217;s also good for users; If they feel secure in using the customizer.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>15:20</p>\n\n\n\n<p>Well, I think that there&#8217;s something important here that we certainly learned with the adoption of Gutenberg in 5.0. Right, which is that there is certainly one method of helping people to adopt things, which is to go like the art of war style, and kind of smash their rice pots and burn all their boats, like, that&#8217;s one way. Which works for a lot of companies in the world, I&#8217;m sure. But WordPress has always had kind of a commitment, not even kind of, has always had a commitment to backward compatibility. And like, we know that a lot of the work on Gutenberg is going to represent some breaking changes around the around workflows and around the user experience the interface, especially like, we know that. But the opportunity to like have a thing that gives you an early taste of what&#8217;s coming but also the ability to keep kind of working in your old space where you need to, I think it&#8217;s an excellent way to bring people forward into the future of things, I have never been a fan of the just like cut off all avenues and hope that they stay with your method because of course, like you can&#8217;t cut off all the methods. You can&#8217;t cut off all the ways people can get away from you. And even if we could, it wouldn&#8217;t be in line with how WordPress hopes to kind of help people through some tough stuff like making your first website is hard. If you are doing it as part of, an overall campaign that&#8217;s supposed to bring in leads for you or generate revenue like you don&#8217;t want to necessarily play with that in a way that could break things and be risky for you in the long term. So I think all the tools that we offer to help people kind of move forward with the technology move forward with the CMS as it&#8217;s moving forward, I think it&#8217;s really smart. And so universal themes are one of those things, but also not around to stay. As we move into non modified themes, just the word themes that happen to be based in blocks. If I&#8217;ve confused anyone, please email me at wpbriefing@wordpress.org. And tell me how I confused you. And I will do a follow-up to unconfuse everyone.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>17:40</p>\n\n\n\n<p>So speaking of the way that we help people kind of move forward with WordPress and with the technology. So much has been done in the CMS in the past 12 months in the past 18 months to be able to move themes into this same future as the rest of the editor. Right. So like, for folks who have not been listening to me for the last five years, you may not know this. So I&#8217;m going to tell everybody now, like one of the pain points that Gutenberg overall is solving is the fact that you for a long time had to learn five different editing interfaces to get one thing done in WordPress, right. And so like the advent of blocks and moving it into more and more spaces in the CMS is intended to really flatten the editing experience by making the type of user interaction the type of workflow really similar across all of the editing interfaces in the CMS. And so themes are a natural extension of that, where we can take similar user patterns and workflows, and work them out into themes. So over the last 12 months or so probably a little bit more, there&#8217;s been a lot of work on the CMS to move us forward in that that is now enabling the work that we want to be able to do to move things forward ahead. And so, I mean, this is probably our last question. Is there anything that you all want to offer to people who maybe saw themes early on or saw Gutenberg early on and felt like this is just not for me, in that in that context of like, how far it&#8217;s moved ahead in the past 12 months or so.</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>19:23</p>\n\n\n\n<p>So you&#8217;re asking like, what in the last 12 months has maybe like really surprised me or like sticks out to me as something that like, Wow, look how far we&#8217;ve come?</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>19:36</p>\n\n\n\n<p>Yeah, yeah. So like, if you&#8217;re looking at what is the one thing that you saw in the last 12 months, that changed in the CMS that really enabled something wonderful for themes or from the other side of it. Like if someone had looked at themes or WordPress 18 months ago, and now they&#8217;re looking at it and seeing this new and different way to do things with the look and feel of their site, like what is one thing that they should be aware of? On either side of that question,</p>\n\n\n\n<p><strong>Maggie Cabrera&nbsp; </strong>20:05</p>\n\n\n\n<p>I think there&#8217;s more than one thing that has really evolved through this last year, year and a half. Like the maturity of some of the blocks is astounding now, like navigation blog, for example, was really bare-bones at the start and now it&#8217;s full potential, and it&#8217;s really looking really great. I would say the same thing about those days or the features on fire, like how basic it was at the start, was full potential. But now it&#8217;s really, really mature in terms of how much you can do with it. Like, I think the example, the perfect example of that is the work that <a href=\"https://profiles.wordpress.org/kjellr/\">Kjell [Reigstad]</a> has done on Twenty-Twenty Two with the alternative theme.json files, where just changing that file basically feels like a new theme, with just the configuration and the styles. And without writing any CSS without changing any templates. It&#8217;s really, really amazing how that can turn into a reality. And it&#8217;s so easy for users to tinker with that if they want to. And it&#8217;s much easier than having to delve deep into CSS and changing everything in like 2000 lines of code.&nbsp;</p>\n\n\n\n<p><strong>Jeff Ong&nbsp; </strong>21:23</p>\n\n\n\n<p>Yeah, I probably would echo most of that. What the thing that astounds me is global styles and how the UI can be shipping a theme or default theme with basically like, 20 lines of CSS, and have it be one of them. A beautiful, beautiful, like crisp and sharp, like, experience. It&#8217;s super fast. And it&#8217;s like, what this is a theme, you know, I thought a theme was supposed to supply all the styles like no, like, it&#8217;s just yeah. And workers do for you. Exactly. And like that. That&#8217;s pretty amazing to think in the last 12 months, we can go from, you know, shipping 1000s of lines of CSS to you none, it&#8217;s like, Wow, pretty cool.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>22:10</p>\n\n\n\n<p>Well, my friends, thank you so much for joining me today. This has been a really interesting conversation. I hope that all y&#8217;all out listening. Also find it interesting. As I mentioned, if you have any follow-up questions, absolutely. Send them to me via email. And I collect all of my questions that I get through the year for answering at the end of the year, mostly because I don&#8217;t get lots of questions that people want to be answered on this. Everyone just asked me their questions on Twitter and in Slack, which is fine as well.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>22:41</p>\n\n\n\n<p>So, Maggie, Jeff, thank you both for joining me. And I&#8217;m sure that we&#8217;ll talk to you all again soon.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>22:56</p>\n\n\n\n<p>That brings us now to our small list of big things. In the last episode, I got all excited about being in the beta phase. But today, I&#8217;m rolling that back a little bit. As part of our usual open source processes, a group of contributors did a deep dive review on the WordPress 5.9 release and found a workflow that needed some refinement. So we are delaying the beta.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>23:19</p>\n\n\n\n<p>Since we are in the midst of a major commerce slash/sales season, and of course, a lengthy holiday season, that delay also means that it makes sense to delay WordPress 5.9 final release a little as well. And so we are delaying that all the way into 2022 to January 25. For me, the trade-off works really well there. Every decision that we make in open source, of course, has some balance to it. It&#8217;s great for these aspects, it is less great for these aspects over here. But for myself, the opportunity to make sure that we have a really excellent experience for our users and also an opportunity to kind of avoid all of the chaos and hustle and bustle of the end of the year. Really, it seemed like a no-brainer for me. So in case you want to learn a little bit more about why we made the decision and get some insight into the actual milestones and where they have moved now, I&#8217;ll include some posts in the show notes below in case you want to read more and of course, if you have any additional questions you can always ask.</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:33</p>\n\n\n\n<p>The second small list of big things is that the first back to people WordCamp. I don&#8217;t think that&#8217;s what we&#8217;re calling it. Our first back to people WordCamp is happening in a couple of weeks actually. WordCamp Sevilla is happening in person on December 11. And I&#8217;m so excited I wish I were local, but I&#8217;m not so if you are local stop by their website and pick up your ticket.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>24:55</p>\n\n\n\n<p>And the third thing on our smallest a big things is that it is, of course, charitable giving season. I don&#8217;t know if you do your charitable giving at the end of the year or if that&#8217;s even part of your general ways of giving back. But I can think of two or three charitable organizations inside the WordPress ecosystem. There&#8217;s of course the WordPress Foundation, but also Big Orange Heart and HeroPress. If there are others out there, I certainly do want to know about them. WordPress Foundation also does additional giving on behalf of just like the open web and open source as a whole. So if you&#8217;re the sort of person who does their charitable giving at the end of the year, just a reminder that you have some options inside the WordPress ecosystem if you were trying to figure out some new places to donate to in 2021.&nbsp;</p>\n\n\n\n<p><strong>Josepha Haden Chomphosy&nbsp; </strong>25:42</p>\n\n\n\n<p>And that is your small list of big things. Thank you so much for tuning in today for the WordPress Briefing. Thank you again to our special guests, Maggie and Jeff. I&#8217;m your host Josepha Haden Chomphosy, and I&#8217;ll see you again in a couple of weeks.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11636\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Watch State of the Word at a Watch Party with your WordPress Friends\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:104:\"https://wordpress.org/news/2021/11/watch-state-of-the-word-at-a-watch-party-with-your-wordpress-friends/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 Nov 2021 18:30:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11641\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:322:\"State of the Word 2021 is just around the corner!&#160; Although attending State of the Word in person would be ideal, not all WordPress community members get to enjoy the experience of attending the speech live with friends.&#160; This year, as State of the Word is streamed live for the second time, we want to [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Hari Shanker R\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7280:\"\n<p><a href=\"https://wordpress.org/news/2021/11/state-of-the-word-2021/\">State of the Word 2021</a> is just around the corner!&nbsp;</p>\n\n\n\n<p>Although attending State of the Word in person would be ideal, not all WordPress community members get to enjoy the experience of attending the speech live with friends.&nbsp;</p>\n\n\n\n<p>This year, as State of the Word is streamed live for the second time, we want to restore that in person camaraderie through State of the Word watch parties for WordPress Community members around the world.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>We encourage WordPress meetup organizers and community members worldwide to (safely) host State of the Word 2021 watch parties —</strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>read this handbook to learn more</strong></a><strong>.</strong></p></blockquote>\n\n\n\n<h2 id=\"why-organize-a-watch-party\">Why organize a watch party?&nbsp;</h2>\n\n\n\n<ul><li>If you are a <a href=\"https://meetup.com/pro/wordpress\">WordPress meetup</a> organizer, many folks in your meetup may be unaware of the State of the Word, and a watch party could be a great opportunity to introduce or remind them.</li><li>As meetup organizers slowly bid goodbye to a tough year, the watch party could be an excellent opportunity to revitalize your group, especially if you haven’t had many events this year.</li><li>Along with your Meetup group members, you get a platform to ask questions directly to Matt Mullenweg.</li><li>And last but not least, even if you are not a Meetup Organizer, a watch party can be the perfect opportunity to reconnect and have a blast with your WordPress friends!</li></ul>\n\n\n\n<h2 id=\"how-do-i-organize-a-state-of-the-word-watch-party\">How do I organize a State of the Word watch party?</h2>\n\n\n\n<p>You can choose to host a watch party online or in person. Check out <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#schedule-a-state-of-the-word-watch-party-for-your-meetup\">our handbook</a> for detailed instructions on how to schedule an event (including event templates).</p>\n\n\n\n<div class=\"wp-block-columns\">\n<div class=\"wp-block-column\">\n<h3 id=\"online\">Online</h3>\n\n\n\n<p>The simplest way to organize an online watch party is to schedule an online event for your WordPress group and add the State of the Word YouTube streaming link directly on Meetup.com. Alternatively, you can schedule an online meeting using tools like Zoom and broadcast the live stream over there by screen sharing––thereby facilitating better engagement. </p>\n\n\n\n<div class=\"wp-container-61a721db4a39f wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-online-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Organize an Online Watch Party</a></div>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-column\">\n<h3 id=\"in-person\">In Person</h3>\n\n\n\n<p>If your region meets <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/2021-returning-to-in-person-meetups/\">the guidelines for in person events</a> (if vaccines and testing are freely available), you can organize an in person watch party event (for fully vaccinated OR recently tested OR recently recovered folks) for your WordPress Meetup! Group members can hang out together (following local safety guidelines of course) and watch State of the Word live.</p>\n\n\n\n<div class=\"wp-container-61a721db4a692 wp-block-buttons\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link\" href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/#organizing-an-in-person-watch-party\" target=\"_blank\" rel=\"noreferrer noopener\">Plan an In person Watch Party</a></div>\n</div>\n</div>\n</div>\n\n\n\n<div style=\"height:20px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p><strong>NOTE:</strong> If State of the Word is happening at an odd hour in your timezone, you can still organize a watch party by organizing a replay of live stream, at a date/time that is convenient for your group.</p>\n\n\n\n<blockquote class=\"wp-block-quote\"><p>If your Local WordPress Meetup is organizing an in person watch party, <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/request-swag-for-in-person-watch-parties/\"><strong>fill out this form</strong></a><strong> so that we can ship some swag for your group to celebrate!</strong><br>Deadline: November 30, 2021</p></blockquote>\n\n\n\n<h2 id=\"what-else-do-i-need-to-know-about-organizing-a-state-of-the-word-watch-party\">What else do I need to know about organizing a State of the Word watch party?</h2>\n\n\n\n<p>Excited? To help you get started, we’ve put together a few resources:</p>\n\n\n\n<ul><li><strong>Check out this </strong><a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/\"><strong>handbook</strong></a><strong> for detailed instructions on how to organize a watch party, </strong>be it online or in person.</li><li>Looking for a Zoom Pro account to host your online watch party?&nbsp;<a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/getting-started/special-virtual-events-zoom-request/\">Request a community zoom pro account</a>&nbsp;for your event right away!</li><li>We have prepared some <a href=\"https://make.wordpress.org/community/handbook/meetup-organizer/event-formats/2021-state-of-the-word-watch-parties/email-templates-for-state-of-the-word/\">email templates</a> that Meetup Organizers can use to spread the word in their Meetup groups.</li><li>Don’t forget to share on social media about your watch party events using the hashtag <strong>#StateOfTheWord</strong> so we can join in on the fun!</li></ul>\n\n\n\n<blockquote class=\"wp-block-quote\"><p><strong>NOTE: </strong> The guidelines in this post are primarily aimed at WordPress Meetup organizers. <strong>However, you do not need to be a Meetup organizer to schedule a watch party!</strong> You can simply hang out together with your friends online or in person (while following local safety guidelines) and catch the event live!</p></blockquote>\n\n\n\n<p>If you are planning a watch party for State of the Word, and have questions, please drop us an email to: <a href=\"mailto:support@wordcamp.org\">support@wordcamp.org</a> if you have any questions. We are happy to help you in the best way possible.</p>\n\n\n\n<p><em>The following folks contributed to this post: <a href=\'https://profiles.wordpress.org/anjanavasan/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>anjanavasan</a> <a href=\'https://profiles.wordpress.org/eidolonnight/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>eidolonnight</a> <em><a href=\'https://profiles.wordpress.org/evarlese/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>evarlese</a></em></em> <em>and <a href=\'https://profiles.wordpress.org/rmartinezduque/\' class=\'mention\'><span class=\'mentions-prefix\'>@</span>rmartinezduque</a></em></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"11641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:63:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:23:\"A Look at WordPress 5.9\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/news/2021/11/a-look-at-wordpress-5-9/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 23 Nov 2021 21:02:02 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:3:{i:0;a:5:{s:4:\"data\";s:6:\"Design\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:11:\"Development\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"Features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://wordpress.org/news/?p=11625\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:322:\"WordPress 5.9 is expected to be a ground-breaking release. It will introduce the next generation of themes with Twenty Twenty-Two joining the fun and over 30 theme blocks to build all parts of your site. In anticipation of the January 25th release, we hope you enjoy this sneak peek of 5.9. New design tools will [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Kelly Hoffman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2987:\"\n<figure class=\"wp-block-embed is-type-video is-provider-youtube wp-block-embed-youtube wp-embed-aspect-4-3 wp-has-aspect-ratio\"><div class=\"wp-block-embed__wrapper\">\n<iframe loading=\"lazy\" class=\"youtube-player\" width=\"632\" height=\"356\" src=\"https://www.youtube.com/embed/XvEG9XWD4JI?version=3&#038;rel=1&#038;showsearch=0&#038;showinfo=1&#038;iv_load_policy=1&#038;fs=1&#038;hl=en-US&#038;autohide=2&#038;wmode=transparent\" allowfullscreen=\"true\" style=\"border:0;\" sandbox=\"allow-scripts allow-same-origin allow-popups allow-presentation\"></iframe>\n</div></figure>\n\n\n\n<p>WordPress 5.9 is ex